/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.inlong.manager.common.pojo.query.ColumnInfoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class HiveServerDao {
    private static final String HIVE_DRIVER_CLASS = "org.apache.hive.jdbc.HiveDriver";
    private static final Logger LOG = LoggerFactory.getLogger(HiveServerDao.class);

    public void executeDDL(String ddl, String hiveUrl, String user, String password) throws Exception {
        try (Connection conn = this.getHiveConnection(hiveUrl, user, password);){
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
        }
    }

    public List<ColumnInfoBean> queryStructure(String querySql, String jdbcUrl, String user, String password) throws Exception {
        try (Connection conn = this.getHiveConnection(jdbcUrl, user, password);){
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(querySql);
            ArrayList<ColumnInfoBean> columnInfoBeans = new ArrayList<ColumnInfoBean>();
            try {
                while (rs.next()) {
                    ColumnInfoBean columnInfoBean = new ColumnInfoBean();
                    columnInfoBean.setColumnName(rs.getString(1));
                    columnInfoBean.setColumnType(rs.getString(2));
                    columnInfoBean.setColumnDesc(rs.getString(3));
                    columnInfoBeans.add(columnInfoBean);
                }
            }
            catch (Exception e) {
                LOG.error("query table structure error", (Throwable)e);
            }
            ArrayList<ColumnInfoBean> arrayList = columnInfoBeans;
            return arrayList;
        }
    }

    public List<String> getTables(String hiveUrl, String user, String password, String dbname) throws Exception {
        ArrayList<String> tables = new ArrayList<String>();
        try (Connection conn = this.getHiveConnection(hiveUrl, user, password);){
            HiveDatabaseMetaData metaData = (HiveDatabaseMetaData)conn.getMetaData();
            LOG.info("dbname is {}", (Object)dbname);
            ResultSet rs = metaData.getTables(dbname, dbname, null, new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                tables.add(tableName);
            }
        }
        catch (Exception e) {
            LOG.error("a database access error occurs or this method is called on a closed connection", (Throwable)e);
            throw e;
        }
        return tables;
    }

    public Connection getHiveConnection(String hiveUrl, String user, String password) throws Exception {
        Connection conn;
        try {
            Class.forName(HIVE_DRIVER_CLASS);
            conn = DriverManager.getConnection(hiveUrl, user, password);
        }
        catch (Exception e) {
            LOG.error("get hive connection error, please check hive jdbc url, username or password", (Throwable)e);
            throw new Exception("get hive connection error, please check jdbc url, username or password. other error msg: " + e.getMessage());
        }
        if (conn == null) {
            throw new Exception("get hive connection failed, please contact administrator");
        }
        LOG.info("get hive connection success, url={}", (Object)hiveUrl);
        return conn;
    }

    public boolean isExistTable(String jdbcUrl, String user, String password, String dbName, String tableName) throws Exception {
        List<String> tables = this.getTables(jdbcUrl, user, password, dbName);
        return tables.contains(tableName);
    }
}

