/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import java.util.List;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.fieldformat.ArrayFormat;
import org.apache.inlong.manager.pojo.fieldformat.BinaryFormat;
import org.apache.inlong.manager.pojo.fieldformat.DecimalFormat;
import org.apache.inlong.manager.pojo.fieldformat.MapFormat;
import org.apache.inlong.manager.pojo.fieldformat.StructFormat;
import org.apache.inlong.manager.pojo.fieldformat.VarBinaryFormat;

public class FieldFormatUtils {
    public static String createBinaryFormat(int length) {
        return JsonUtils.toJsonString((Object)new BinaryFormat(length));
    }

    public static BinaryFormat parseBinaryFormat(String formatJson) {
        return (BinaryFormat)JsonUtils.parseObject((String)formatJson, BinaryFormat.class);
    }

    public static String createVarBinaryFormat(int length) {
        return JsonUtils.toJsonString((Object)new VarBinaryFormat(length));
    }

    public static VarBinaryFormat parseVarBinaryFormat(String formatJson) {
        return (VarBinaryFormat)JsonUtils.parseObject((String)formatJson, VarBinaryFormat.class);
    }

    public static String createDecimalFormat(int precision, int scale) {
        return JsonUtils.toJsonString((Object)new DecimalFormat(precision, scale));
    }

    public static DecimalFormat parseDecimalFormat(String formatJson) {
        return (DecimalFormat)JsonUtils.parseObject((String)formatJson, DecimalFormat.class);
    }

    public static String createArrayFormat(FieldType elementType, String elementFormat) {
        return JsonUtils.toJsonString((Object)new ArrayFormat(elementType, elementFormat));
    }

    public static ArrayFormat parseArrayFormat(String formatJson) {
        return (ArrayFormat)JsonUtils.parseObject((String)formatJson, ArrayFormat.class);
    }

    public static String createMapFormat(FieldType keyType, String keyFormat, FieldType valueType, String valueFormat) {
        return JsonUtils.toJsonString((Object)new MapFormat(keyType, keyFormat, valueType, valueFormat));
    }

    public static MapFormat parseMapFormat(String formatJson) {
        return (MapFormat)JsonUtils.parseObject((String)formatJson, MapFormat.class);
    }

    public static String createStructFormat(List<StructFormat.Element> elements) {
        return JsonUtils.toJsonString((Object)new StructFormat(elements));
    }

    public static StructFormat parseStructFormat(String formatJson) {
        return (StructFormat)JsonUtils.parseObject((String)formatJson, StructFormat.class);
    }
}

