/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.sort.util.StreamParseUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.pojo.transform.encrypt.EncryptDefinition;
import org.apache.inlong.manager.pojo.transform.replacer.StringReplacerDefinition;
import org.apache.inlong.manager.pojo.transform.splitter.SplitterDefinition;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.StringTypeInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.transformation.CascadeFunction;
import org.apache.inlong.sort.protocol.transformation.ConstantParam;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;
import org.apache.inlong.sort.protocol.transformation.function.CascadeFunctionWrapper;
import org.apache.inlong.sort.protocol.transformation.function.EncryptFunction;
import org.apache.inlong.sort.protocol.transformation.function.RegexpReplaceFirstFunction;
import org.apache.inlong.sort.protocol.transformation.function.RegexpReplaceFunction;
import org.apache.inlong.sort.protocol.transformation.function.SplitIndexFunction;

public class FieldRelationUtils {
    public static List<FieldRelation> createFieldRelations(TransformResponse transformResponse, Map<String, StreamField> constantFieldMap) {
        TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
        TransformDefinition transformDefinition = StreamParseUtils.parseTransformDefinition(transformResponse.getTransformDefinition(), transformType);
        List<StreamField> fieldList = transformResponse.getFieldList();
        String transformName = transformResponse.getTransformName();
        String preNodes = transformResponse.getPreNodeNames();
        switch (transformType) {
            case SPLITTER: {
                SplitterDefinition splitterDefinition = (SplitterDefinition)transformDefinition;
                return FieldRelationUtils.createSplitterFieldRelations(fieldList, transformName, splitterDefinition, preNodes, constantFieldMap);
            }
            case STRING_REPLACER: {
                StringReplacerDefinition replacerDefinition = (StringReplacerDefinition)transformDefinition;
                return FieldRelationUtils.createReplacerFieldRelations(fieldList, transformName, replacerDefinition, preNodes, constantFieldMap);
            }
            case ENCRYPT: {
                EncryptDefinition encryptDefinition = (EncryptDefinition)transformDefinition;
                return FieldRelationUtils.createEncryptFieldRelations(fieldList, transformName, encryptDefinition, preNodes, constantFieldMap);
            }
            case DE_DUPLICATION: 
            case FILTER: {
                return FieldRelationUtils.createFieldRelations(fieldList, constantFieldMap);
            }
            case JOINER: 
            case LOOKUP_JOINER: 
            case TEMPORAL_JOINER: 
            case INTERVAL_JOINER: {
                return FieldRelationUtils.createJoinerFieldRelations(fieldList, constantFieldMap);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported transformType=%s", transformType));
    }

    private static List<FieldRelation> createFieldRelations(List<StreamField> fieldList, Map<String, StreamField> constantFieldMap) {
        return fieldList.stream().map(FieldInfoUtils::parseStreamField).map(fieldInfo -> {
            String fieldKey = String.format("%s-%s", fieldInfo.getNodeId(), fieldInfo.getName());
            StreamField constantField = (StreamField)constantFieldMap.get(fieldKey);
            Object inputField = constantField != null ? (fieldInfo.getFormatInfo() != null && fieldInfo.getFormatInfo().getTypeInfo() == StringTypeInfo.INSTANCE ? new StringConstantParam(constantField.getFieldValue()) : new ConstantParam((Object)constantField.getFieldValue())) : new FieldInfo(fieldInfo.getName(), fieldInfo.getNodeId(), fieldInfo.getFormatInfo());
            FieldInfo outputField = new FieldInfo(fieldInfo.getName(), fieldInfo.getFormatInfo());
            return new FieldRelation((FunctionParam)inputField, outputField);
        }).collect(Collectors.toList());
    }

    private static List<FieldRelation> createJoinerFieldRelations(List<StreamField> fieldList, Map<String, StreamField> constantFieldMap) {
        return fieldList.stream().map(streamField -> {
            FormatInfo formatInfo = FieldInfoUtils.convertFieldFormat(streamField.getFieldType(), streamField.getFieldFormat());
            String fieldKey = String.format("%s-%s", streamField.getOriginNodeName(), streamField.getOriginFieldName());
            StreamField constantField = (StreamField)constantFieldMap.get(fieldKey);
            Object inputField = constantField != null ? (formatInfo != null && formatInfo.getTypeInfo() == StringTypeInfo.INSTANCE ? new StringConstantParam(constantField.getFieldValue()) : new ConstantParam((Object)constantField.getFieldValue())) : new FieldInfo(streamField.getOriginFieldName(), streamField.getOriginNodeName(), formatInfo);
            FieldInfo outputField = new FieldInfo(streamField.getFieldName(), formatInfo);
            return new FieldRelation((FunctionParam)inputField, outputField);
        }).collect(Collectors.toList());
    }

    private static List<FieldRelation> createSplitterFieldRelations(List<StreamField> fieldList, String transformName, SplitterDefinition splitterDefinition, String preNodes, Map<String, StreamField> constantFieldMap) {
        Preconditions.expectNotBlank((String)preNodes, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"PreNodes of splitter should not be null");
        String preNode = preNodes.split(",")[0];
        List<SplitterDefinition.SplitRule> splitRules = splitterDefinition.getSplitRules();
        HashSet splitFields = Sets.newHashSet();
        List fieldRelations = splitRules.stream().map(splitRule -> FieldRelationUtils.parseSplitRule(splitRule, splitFields, transformName, preNode)).reduce(Lists.newArrayList(), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        });
        List<StreamField> filteredFieldList = fieldList.stream().filter(streamFieldInfo -> !splitFields.contains(streamFieldInfo.getFieldName())).collect(Collectors.toList());
        fieldRelations.addAll(FieldRelationUtils.createFieldRelations(filteredFieldList, constantFieldMap));
        return fieldRelations;
    }

    private static List<FieldRelation> createReplacerFieldRelations(List<StreamField> fieldList, String transformName, StringReplacerDefinition replacerDefinition, String preNodes, Map<String, StreamField> constantFieldMap) {
        Preconditions.expectNotBlank((String)preNodes, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"PreNodes of splitter should not be null");
        String preNode = preNodes.split(",")[0];
        List<StringReplacerDefinition.ReplaceRule> replaceRules = replacerDefinition.getReplaceRules();
        HashSet replaceFields = Sets.newHashSet();
        List<FieldRelation> fieldRelations = replaceRules.stream().map(replaceRule -> FieldRelationUtils.parseReplaceRule(replaceRule, replaceFields, transformName, preNode)).collect(Collectors.toList());
        fieldRelations = FieldRelationUtils.cascadeFunctionRelations(fieldRelations);
        List<StreamField> filteredFieldList = fieldList.stream().filter(streamFieldInfo -> !replaceFields.contains(streamFieldInfo.getFieldName())).collect(Collectors.toList());
        fieldRelations.addAll(FieldRelationUtils.createFieldRelations(filteredFieldList, constantFieldMap));
        return fieldRelations;
    }

    private static List<FieldRelation> createEncryptFieldRelations(List<StreamField> fieldList, String transformName, EncryptDefinition encryptDefinition, String preNodes, Map<String, StreamField> constantFieldMap) {
        Preconditions.expectNotBlank((String)preNodes, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"PreNodes of encrypt should not be null");
        String preNode = preNodes.split(",")[0];
        List<EncryptDefinition.EncryptRule> encryptRules = encryptDefinition.getEncryptRules();
        HashSet encryptFields = Sets.newHashSet();
        List<FieldRelation> fieldRelations = encryptRules.stream().map(replaceRule -> FieldRelationUtils.parseEncryptRule(replaceRule, encryptFields, transformName, preNode)).collect(Collectors.toList());
        List<StreamField> filteredFieldList = fieldList.stream().filter(streamFieldInfo -> !encryptFields.contains(streamFieldInfo.getFieldName())).collect(Collectors.toList());
        fieldRelations.addAll(FieldRelationUtils.createFieldRelations(filteredFieldList, constantFieldMap));
        return fieldRelations;
    }

    private static List<FieldRelation> cascadeFunctionRelations(List<FieldRelation> fieldRelations) {
        String targetField;
        HashMap cascadeFunctions = Maps.newHashMap();
        HashMap targetFields = Maps.newHashMap();
        for (FieldRelation fieldRelation : fieldRelations) {
            CascadeFunction cascadeFunction = (CascadeFunction)fieldRelation.getInputField();
            targetField = fieldRelation.getOutputField().getName();
            cascadeFunctions.computeIfAbsent(targetField, k -> Lists.newArrayList()).add(cascadeFunction);
            targetFields.put(targetField, fieldRelation.getOutputField());
        }
        ArrayList cascadeRelations = Lists.newArrayList();
        for (Map.Entry entry : cascadeFunctions.entrySet()) {
            targetField = (String)entry.getKey();
            CascadeFunctionWrapper functionWrapper = new CascadeFunctionWrapper((List)entry.getValue());
            FieldInfo targetFieldInfo = (FieldInfo)targetFields.get(targetField);
            cascadeRelations.add(new FieldRelation((FunctionParam)functionWrapper, targetFieldInfo));
        }
        return cascadeRelations;
    }

    private static FieldRelation parseReplaceRule(StringReplacerDefinition.ReplaceRule replaceRule, Set<String> replaceFields, String transformName, String preNode) {
        StreamField sourceField = replaceRule.getSourceField();
        String fieldName = sourceField.getFieldName();
        String regex = replaceRule.getRegex();
        String targetValue = replaceRule.getTargetValue();
        StringReplacerDefinition.ReplaceMode replaceMode = replaceRule.getMode();
        FieldInfo fieldInfo = FieldInfoUtils.parseStreamField(sourceField);
        fieldInfo.setNodeId(preNode);
        FieldInfo targetFieldInfo = new FieldInfo(fieldName, transformName, FieldInfoUtils.convertFieldFormat(FieldType.STRING.name()));
        replaceFields.add(fieldName);
        if (replaceMode == StringReplacerDefinition.ReplaceMode.RELACE_ALL) {
            RegexpReplaceFunction regexpReplaceFunction = new RegexpReplaceFunction(fieldInfo, new StringConstantParam(regex), new StringConstantParam(targetValue));
            return new FieldRelation((FunctionParam)regexpReplaceFunction, targetFieldInfo);
        }
        RegexpReplaceFirstFunction regexpReplaceFirstFunction = new RegexpReplaceFirstFunction((FunctionParam)fieldInfo, new StringConstantParam(regex), new StringConstantParam(targetValue));
        return new FieldRelation((FunctionParam)regexpReplaceFirstFunction, targetFieldInfo);
    }

    private static FieldRelation parseEncryptRule(EncryptDefinition.EncryptRule encryptRule, Set<String> encryptFields, String transformName, String preNode) {
        StreamField sourceField = encryptRule.getSourceField();
        String fieldName = sourceField.getFieldName();
        String key = Objects.isNull(encryptRule.getKey()) ? "" : encryptRule.getKey();
        String encrypt = encryptRule.getEncrypt();
        FieldInfo fieldInfo = FieldInfoUtils.parseStreamField(sourceField);
        fieldInfo.setNodeId(preNode);
        FieldInfo targetFieldInfo = new FieldInfo(fieldName, transformName, FieldInfoUtils.convertFieldFormat(FieldType.STRING.name()));
        encryptFields.add(fieldName);
        EncryptFunction encryptFunction = new EncryptFunction(fieldInfo, new StringConstantParam(key), new StringConstantParam(encrypt));
        return new FieldRelation((FunctionParam)encryptFunction, targetFieldInfo);
    }

    private static List<FieldRelation> parseSplitRule(SplitterDefinition.SplitRule splitRule, Set<String> splitFields, String transformName, String preNode) {
        StreamField sourceField = splitRule.getSourceField();
        FieldInfo fieldInfo = FieldInfoUtils.parseStreamField(sourceField);
        fieldInfo.setNodeId(preNode);
        String separator = splitRule.getSeparator();
        List<String> targetSources = splitRule.getTargetFields();
        ArrayList splitRelations = Lists.newArrayList();
        for (int index = 0; index < targetSources.size(); ++index) {
            SplitIndexFunction splitIndexFunction = new SplitIndexFunction(fieldInfo, new StringConstantParam(separator), new ConstantParam((Object)index));
            FieldInfo targetFieldInfo = new FieldInfo(targetSources.get(index), transformName, FieldInfoUtils.convertFieldFormat(FieldType.STRING.name()));
            splitFields.add(targetSources.get(index));
            splitRelations.add(new FieldRelation((FunctionParam)splitIndexFunction, targetFieldInfo));
        }
        return splitRelations;
    }
}

