/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.tubemq;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.TreeSet;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.tubemq.TubeMQSourceRequest;

public class TubeMQSourceDTO {
    @ApiModelProperty(value="Master RPC of the TubeMQ,127.0.0.1:8715")
    private String masterRpc;
    @ApiModelProperty(value="Topic of the TubeMQ")
    private String topic;
    @ApiModelProperty(value="Group of the TubeMQ")
    private String consumeGroup;
    @ApiModelProperty(value="Session key of the TubeMQ")
    private String sessionKey;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="The message body wrap  wrap type, including: RAW, INLONG_MSG_V0, INLONG_MSG_V1, etc")
    private String wrapType;
    @ApiModelProperty(value="streamId of the TubeMQ")
    private TreeSet<String> streamId;
    @ApiModelProperty(value="Properties for TubeMQ")
    private Map<String, Object> properties;

    public static TubeMQSourceDTO getFromRequest(TubeMQSourceRequest request, String extParams) {
        TubeMQSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? TubeMQSourceDTO.getFromJson(extParams) : new TubeMQSourceDTO();
        return (TubeMQSourceDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static TubeMQSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (TubeMQSourceDTO)JsonUtils.parseObject((String)extParams, TubeMQSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Parse extParams of TubeMQSource failure: %s", e.getMessage()));
        }
    }

    public static TubeMQSourceDTOBuilder builder() {
        return new TubeMQSourceDTOBuilder();
    }

    public String getMasterRpc() {
        return this.masterRpc;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getConsumeGroup() {
        return this.consumeGroup;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getWrapType() {
        return this.wrapType;
    }

    public TreeSet<String> getStreamId() {
        return this.streamId;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setMasterRpc(String masterRpc) {
        this.masterRpc = masterRpc;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setConsumeGroup(String consumeGroup) {
        this.consumeGroup = consumeGroup;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setWrapType(String wrapType) {
        this.wrapType = wrapType;
    }

    public void setStreamId(TreeSet<String> streamId) {
        this.streamId = streamId;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeMQSourceDTO)) {
            return false;
        }
        TubeMQSourceDTO other = (TubeMQSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$masterRpc = this.getMasterRpc();
        String other$masterRpc = other.getMasterRpc();
        if (this$masterRpc == null ? other$masterRpc != null : !this$masterRpc.equals(other$masterRpc)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$consumeGroup = this.getConsumeGroup();
        String other$consumeGroup = other.getConsumeGroup();
        if (this$consumeGroup == null ? other$consumeGroup != null : !this$consumeGroup.equals(other$consumeGroup)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$wrapType = this.getWrapType();
        String other$wrapType = other.getWrapType();
        if (this$wrapType == null ? other$wrapType != null : !this$wrapType.equals(other$wrapType)) {
            return false;
        }
        TreeSet<String> this$streamId = this.getStreamId();
        TreeSet<String> other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !((Object)this$streamId).equals(other$streamId)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TubeMQSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $masterRpc = this.getMasterRpc();
        result = result * 59 + ($masterRpc == null ? 43 : $masterRpc.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $consumeGroup = this.getConsumeGroup();
        result = result * 59 + ($consumeGroup == null ? 43 : $consumeGroup.hashCode());
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $wrapType = this.getWrapType();
        result = result * 59 + ($wrapType == null ? 43 : $wrapType.hashCode());
        TreeSet<String> $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : ((Object)$streamId).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "TubeMQSourceDTO(masterRpc=" + this.getMasterRpc() + ", topic=" + this.getTopic() + ", consumeGroup=" + this.getConsumeGroup() + ", sessionKey=" + this.getSessionKey() + ", dataSeparator=" + this.getDataSeparator() + ", wrapType=" + this.getWrapType() + ", streamId=" + this.getStreamId() + ", properties=" + this.getProperties() + ")";
    }

    public TubeMQSourceDTO() {
    }

    public TubeMQSourceDTO(String masterRpc, String topic, String consumeGroup, String sessionKey, String dataSeparator, String wrapType, TreeSet<String> streamId, Map<String, Object> properties) {
        this.masterRpc = masterRpc;
        this.topic = topic;
        this.consumeGroup = consumeGroup;
        this.sessionKey = sessionKey;
        this.dataSeparator = dataSeparator;
        this.wrapType = wrapType;
        this.streamId = streamId;
        this.properties = properties;
    }

    public static class TubeMQSourceDTOBuilder {
        private String masterRpc;
        private String topic;
        private String consumeGroup;
        private String sessionKey;
        private String dataSeparator;
        private String wrapType;
        private TreeSet<String> streamId;
        private Map<String, Object> properties;

        TubeMQSourceDTOBuilder() {
        }

        public TubeMQSourceDTOBuilder masterRpc(String masterRpc) {
            this.masterRpc = masterRpc;
            return this;
        }

        public TubeMQSourceDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public TubeMQSourceDTOBuilder consumeGroup(String consumeGroup) {
            this.consumeGroup = consumeGroup;
            return this;
        }

        public TubeMQSourceDTOBuilder sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return this;
        }

        public TubeMQSourceDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public TubeMQSourceDTOBuilder wrapType(String wrapType) {
            this.wrapType = wrapType;
            return this;
        }

        public TubeMQSourceDTOBuilder streamId(TreeSet<String> streamId) {
            this.streamId = streamId;
            return this;
        }

        public TubeMQSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public TubeMQSourceDTO build() {
            return new TubeMQSourceDTO(this.masterRpc, this.topic, this.consumeGroup, this.sessionKey, this.dataSeparator, this.wrapType, this.streamId, this.properties);
        }

        public String toString() {
            return "TubeMQSourceDTO.TubeMQSourceDTOBuilder(masterRpc=" + this.masterRpc + ", topic=" + this.topic + ", consumeGroup=" + this.consumeGroup + ", sessionKey=" + this.sessionKey + ", dataSeparator=" + this.dataSeparator + ", wrapType=" + this.wrapType + ", streamId=" + this.streamId + ", properties=" + this.properties + ")";
        }
    }
}

