/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Data node paging query request")
public class DataNodePageRequest
extends PageRequest {
    @ApiModelProperty(value="Data node type, including MYSQL, HIVE, KAFKA, ES, etc.")
    @Length(max=20, message="length must be less than or equal to 20")
    private @Length(max=20, message="length must be less than or equal to 20") String type;
    @ApiModelProperty(value="Data node name")
    @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'")
    private @Pattern(regexp="^[A-Za-z0-9_-]{1,128}$", message="only supports letters, numbers, '-', or '_'") String name;
    @ApiModelProperty(value="Data node display name, just for display")
    private String displayName;
    @ApiModelProperty(value="Keywords, name, url, etc.")
    private String keyword;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;
    @ApiModelProperty(value="Whether the current user is in the administrator role", hidden=true)
    private Boolean isAdminRole;
    @ApiModelProperty(value="Inlong tenant to which the data node belongs", hidden=true)
    private String tenant;

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String toString() {
        return "DataNodePageRequest(type=" + this.getType() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", keyword=" + this.getKeyword() + ", status=" + this.getStatus() + ", currentUser=" + this.getCurrentUser() + ", isAdminRole=" + this.getIsAdminRole() + ", tenant=" + this.getTenant() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataNodePageRequest)) {
            return false;
        }
        DataNodePageRequest other = (DataNodePageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        if (this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataNodePageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }
}

