/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.kafka;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.kafka.KafkaDataNodeRequest;

@ApiModel(value="Kafka data node info")
public class KafkaDataNodeDTO {
    @ApiModelProperty(value="kafka bootstrapServers")
    private String bootstrapServers;
    @ApiModelProperty(value="kafka client id")
    private String clientId;
    @ApiModelProperty(value="kafka produce confirmation mechanism")
    private String ack;
    @ApiModelProperty(value="audit set name")
    private String auditSetName;

    public static KafkaDataNodeDTO getFromRequest(KafkaDataNodeRequest request, String extParams) {
        KafkaDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? KafkaDataNodeDTO.getFromJson(extParams) : new KafkaDataNodeDTO();
        return (KafkaDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static KafkaDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (KafkaDataNodeDTO)JsonUtils.parseObject((String)extParams, KafkaDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_INFO_INCORRECT, String.format("Failed to parse extParams for kafka node: %s", e.getMessage()));
        }
    }

    public static KafkaDataNodeDTOBuilder builder() {
        return new KafkaDataNodeDTOBuilder();
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAck() {
        return this.ack;
    }

    public String getAuditSetName() {
        return this.auditSetName;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAck(String ack) {
        this.ack = ack;
    }

    public void setAuditSetName(String auditSetName) {
        this.auditSetName = auditSetName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaDataNodeDTO)) {
            return false;
        }
        KafkaDataNodeDTO other = (KafkaDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$ack = this.getAck();
        String other$ack = other.getAck();
        if (this$ack == null ? other$ack != null : !this$ack.equals(other$ack)) {
            return false;
        }
        String this$auditSetName = this.getAuditSetName();
        String other$auditSetName = other.getAuditSetName();
        return !(this$auditSetName == null ? other$auditSetName != null : !this$auditSetName.equals(other$auditSetName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $ack = this.getAck();
        result = result * 59 + ($ack == null ? 43 : $ack.hashCode());
        String $auditSetName = this.getAuditSetName();
        result = result * 59 + ($auditSetName == null ? 43 : $auditSetName.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaDataNodeDTO(bootstrapServers=" + this.getBootstrapServers() + ", clientId=" + this.getClientId() + ", ack=" + this.getAck() + ", auditSetName=" + this.getAuditSetName() + ")";
    }

    public KafkaDataNodeDTO() {
    }

    public KafkaDataNodeDTO(String bootstrapServers, String clientId, String ack, String auditSetName) {
        this.bootstrapServers = bootstrapServers;
        this.clientId = clientId;
        this.ack = ack;
        this.auditSetName = auditSetName;
    }

    public static class KafkaDataNodeDTOBuilder {
        private String bootstrapServers;
        private String clientId;
        private String ack;
        private String auditSetName;

        KafkaDataNodeDTOBuilder() {
        }

        public KafkaDataNodeDTOBuilder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public KafkaDataNodeDTOBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public KafkaDataNodeDTOBuilder ack(String ack) {
            this.ack = ack;
            return this;
        }

        public KafkaDataNodeDTOBuilder auditSetName(String auditSetName) {
            this.auditSetName = auditSetName;
            return this;
        }

        public KafkaDataNodeDTO build() {
            return new KafkaDataNodeDTO(this.bootstrapServers, this.clientId, this.ack, this.auditSetName);
        }

        public String toString() {
            return "KafkaDataNodeDTO.KafkaDataNodeDTOBuilder(bootstrapServers=" + this.bootstrapServers + ", clientId=" + this.clientId + ", ack=" + this.ack + ", auditSetName=" + this.auditSetName + ")";
        }
    }
}

