/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.doris.DorisSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.load.DorisLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisProvider
implements LoadNodeProvider {
    private static final Logger log = LoggerFactory.getLogger(DorisProvider.class);

    @Override
    public Boolean accept(String sinkType) {
        return "DORIS".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        DorisSink dorisSink = (DorisSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(dorisSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(dorisSink.getSinkFieldList(), dorisSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(dorisSink.getSinkFieldList(), constantFieldMap);
        Format format = this.parsingSinkMultipleFormat(dorisSink.getSinkMultipleEnable(), dorisSink.getSinkMultipleFormat());
        log.info("Test sink doris pro username ={}", (Object)dorisSink);
        return new DorisLoadNode(dorisSink.getSinkName(), dorisSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, dorisSink.getFeNodes(), dorisSink.getUsername(), dorisSink.getPassword(), dorisSink.getTableIdentifier(), null, dorisSink.getSinkMultipleEnable(), format, dorisSink.getDatabasePattern(), dorisSink.getTablePattern());
    }

    @Override
    public Boolean isSinkMultiple(StreamNode nodeInfo) {
        DorisSink dorisSink = (DorisSink)nodeInfo;
        return dorisSink.getSinkMultipleEnable();
    }

    @Override
    public List<StreamField> addStreamFieldsForSinkMultiple(List<StreamField> streamFields) {
        if (CollectionUtils.isEmpty(streamFields)) {
            streamFields = new ArrayList<StreamField>();
        }
        streamFields.add(0, new StreamField(0, "varbinary", MetaField.DATA_BYTES_CANAL.name(), "meta.data_canal", null, 1, MetaField.DATA_BYTES_CANAL.name()));
        return streamFields;
    }

    @Override
    public List<SinkField> addSinkFieldsForSinkMultiple(List<SinkField> sinkFields) {
        if (CollectionUtils.isEmpty(sinkFields)) {
            sinkFields = new ArrayList<SinkField>();
        }
        sinkFields.add(0, new SinkField(0, "varbinary", MetaField.DATA_BYTES_CANAL.name(), "meta.data_canal", MetaField.DATA_BYTES_CANAL.name(), "varbinary", 0, MetaField.DATA_BYTES_CANAL.name(), null));
        return sinkFields;
    }
}

