/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.MySQLFieldTypeStrategy;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.source.mysql.MySQLBinlogSource;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.extract.MySqlExtractNode;

public class MySQLBinlogProvider
implements ExtractNodeProvider {
    private static final FieldTypeMappingStrategy FIELD_TYPE_MAPPING_STRATEGY = new MySQLFieldTypeStrategy();

    @Override
    public Boolean accept(String sourceType) {
        return "MYSQL_BINLOG".equals(sourceType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        MySQLBinlogSource binlogSource = (MySQLBinlogSource)streamNodeInfo;
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(binlogSource.getFieldList(), binlogSource.getSourceName(), FIELD_TYPE_MAPPING_STRATEGY);
        Map<String, String> properties = this.parseProperties(binlogSource.getProperties());
        String database = binlogSource.getDatabaseWhiteList();
        String primaryKey = binlogSource.getPrimaryKey();
        String hostName = binlogSource.getHostname();
        String username = binlogSource.getUser();
        String password = binlogSource.getPassword();
        Integer port = binlogSource.getPort();
        Integer serverId = null;
        if (binlogSource.getServerId() != null && binlogSource.getServerId() > 0) {
            serverId = binlogSource.getServerId();
        }
        String tables = binlogSource.getTableWhiteList();
        List tableNames = Splitter.on((String)",").splitToList((CharSequence)tables);
        String serverTimeZone = binlogSource.getServerTimezone();
        if (binlogSource.isAllMigration()) {
            properties.put("migrate-all", "true");
        }
        if (binlogSource.isOnlyIncremental()) {
            properties.put("scan.startup.mode", "latest-offset");
        }
        return new MySqlExtractNode(binlogSource.getSourceName(), binlogSource.getSourceName(), fieldInfos, null, properties, primaryKey, tableNames, hostName, username, password, database, port, serverId, Boolean.valueOf(true), serverTimeZone);
    }
}

