/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.standalone;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortSourceStreamSinkInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSourceStreamSinkInfo.class);
    private static final Gson GSON = new Gson();
    String sortClusterName;
    String sortTaskName;
    String groupId;
    String streamId;
    String extParams;
    Map<String, String> extParamsMap;

    public Map<String, String> getExtParamsMap() {
        if (this.extParamsMap != null) {
            return this.extParamsMap;
        }
        if (StringUtils.isNotBlank((CharSequence)this.extParams)) {
            try {
                JsonObject jo = (JsonObject)GSON.fromJson(this.extParams, JsonObject.class);
                this.extParamsMap = new HashMap<String, String>();
                jo.keySet().forEach(k -> {
                    JsonElement element = jo.get(k);
                    if (element.isJsonPrimitive()) {
                        this.extParamsMap.put((String)k, element.getAsString());
                    } else {
                        this.extParamsMap.put((String)k, element.toString());
                    }
                });
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse source stream ext params", t);
                this.extParamsMap = new ConcurrentHashMap<String, String>();
            }
        }
        return this.extParamsMap;
    }

    public String getSortClusterName() {
        return this.sortClusterName;
    }

    public String getSortTaskName() {
        return this.sortTaskName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setSortClusterName(String sortClusterName) {
        this.sortClusterName = sortClusterName;
    }

    public void setSortTaskName(String sortTaskName) {
        this.sortTaskName = sortTaskName;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setExtParamsMap(Map<String, String> extParamsMap) {
        this.extParamsMap = extParamsMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortSourceStreamSinkInfo)) {
            return false;
        }
        SortSourceStreamSinkInfo other = (SortSourceStreamSinkInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sortClusterName = this.getSortClusterName();
        String other$sortClusterName = other.getSortClusterName();
        if (this$sortClusterName == null ? other$sortClusterName != null : !this$sortClusterName.equals(other$sortClusterName)) {
            return false;
        }
        String this$sortTaskName = this.getSortTaskName();
        String other$sortTaskName = other.getSortTaskName();
        if (this$sortTaskName == null ? other$sortTaskName != null : !this$sortTaskName.equals(other$sortTaskName)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$streamId = this.getStreamId();
        String other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !this$streamId.equals(other$streamId)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        Map<String, String> this$extParamsMap = this.getExtParamsMap();
        Map<String, String> other$extParamsMap = other.getExtParamsMap();
        return !(this$extParamsMap == null ? other$extParamsMap != null : !((Object)this$extParamsMap).equals(other$extParamsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortSourceStreamSinkInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sortClusterName = this.getSortClusterName();
        result = result * 59 + ($sortClusterName == null ? 43 : $sortClusterName.hashCode());
        String $sortTaskName = this.getSortTaskName();
        result = result * 59 + ($sortTaskName == null ? 43 : $sortTaskName.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : $streamId.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        Map<String, String> $extParamsMap = this.getExtParamsMap();
        result = result * 59 + ($extParamsMap == null ? 43 : ((Object)$extParamsMap).hashCode());
        return result;
    }

    public String toString() {
        return "SortSourceStreamSinkInfo(sortClusterName=" + this.getSortClusterName() + ", sortTaskName=" + this.getSortTaskName() + ", groupId=" + this.getGroupId() + ", streamId=" + this.getStreamId() + ", extParams=" + this.getExtParams() + ", extParamsMap=" + this.getExtParamsMap() + ")";
    }
}

