/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.dataproxy;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.dataproxy.DataProxyClusterRequest;

@ApiModel(value="DataProxy cluster info")
public class DataProxyClusterDTO {
    @ApiModelProperty(value="Is the DataProxy cluster an intranet? 0: no, 1: yes")
    private Integer isIntranet = 1;
    @ApiModelProperty(value="Is the DataProxy cluster in a switch status? 0: no, 1: yes")
    private Integer isSwitch = 0;
    @ApiModelProperty(value="Load of the DataProxy cluster, default is 20")
    private Integer load = 20;

    public static DataProxyClusterDTO getFromRequest(DataProxyClusterRequest request) {
        return DataProxyClusterDTO.builder().isIntranet(request.getIsIntranet()).isSwitch(request.getIsSwitch()).load(request.getLoad()).build();
    }

    public static DataProxyClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (DataProxyClusterDTO)JsonUtils.parseObject((String)extParams, DataProxyClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static DataProxyClusterDTOBuilder builder() {
        return new DataProxyClusterDTOBuilder();
    }

    public Integer getIsIntranet() {
        return this.isIntranet;
    }

    public Integer getIsSwitch() {
        return this.isSwitch;
    }

    public Integer getLoad() {
        return this.load;
    }

    public void setIsIntranet(Integer isIntranet) {
        this.isIntranet = isIntranet;
    }

    public void setIsSwitch(Integer isSwitch) {
        this.isSwitch = isSwitch;
    }

    public void setLoad(Integer load) {
        this.load = load;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataProxyClusterDTO)) {
            return false;
        }
        DataProxyClusterDTO other = (DataProxyClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isIntranet = this.getIsIntranet();
        Integer other$isIntranet = other.getIsIntranet();
        if (this$isIntranet == null ? other$isIntranet != null : !((Object)this$isIntranet).equals(other$isIntranet)) {
            return false;
        }
        Integer this$isSwitch = this.getIsSwitch();
        Integer other$isSwitch = other.getIsSwitch();
        if (this$isSwitch == null ? other$isSwitch != null : !((Object)this$isSwitch).equals(other$isSwitch)) {
            return false;
        }
        Integer this$load = this.getLoad();
        Integer other$load = other.getLoad();
        return !(this$load == null ? other$load != null : !((Object)this$load).equals(other$load));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataProxyClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isIntranet = this.getIsIntranet();
        result = result * 59 + ($isIntranet == null ? 43 : ((Object)$isIntranet).hashCode());
        Integer $isSwitch = this.getIsSwitch();
        result = result * 59 + ($isSwitch == null ? 43 : ((Object)$isSwitch).hashCode());
        Integer $load = this.getLoad();
        result = result * 59 + ($load == null ? 43 : ((Object)$load).hashCode());
        return result;
    }

    public String toString() {
        return "DataProxyClusterDTO(isIntranet=" + this.getIsIntranet() + ", isSwitch=" + this.getIsSwitch() + ", load=" + this.getLoad() + ")";
    }

    public DataProxyClusterDTO() {
    }

    public DataProxyClusterDTO(Integer isIntranet, Integer isSwitch, Integer load) {
        this.isIntranet = isIntranet;
        this.isSwitch = isSwitch;
        this.load = load;
    }

    public static class DataProxyClusterDTOBuilder {
        private Integer isIntranet;
        private Integer isSwitch;
        private Integer load;

        DataProxyClusterDTOBuilder() {
        }

        public DataProxyClusterDTOBuilder isIntranet(Integer isIntranet) {
            this.isIntranet = isIntranet;
            return this;
        }

        public DataProxyClusterDTOBuilder isSwitch(Integer isSwitch) {
            this.isSwitch = isSwitch;
            return this;
        }

        public DataProxyClusterDTOBuilder load(Integer load) {
            this.load = load;
            return this;
        }

        public DataProxyClusterDTO build() {
            return new DataProxyClusterDTO(this.isIntranet, this.isSwitch, this.load);
        }

        public String toString() {
            return "DataProxyClusterDTO.DataProxyClusterDTOBuilder(isIntranet=" + this.isIntranet + ", isSwitch=" + this.isSwitch + ", load=" + this.load + ")";
        }
    }
}

