/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.schedule;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.validation.UpdateValidation;

@ApiModel(value="Schedule response")
public class ScheduleInfo {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateValidation.class})
    private Integer id;
    @ApiModelProperty(value="Inlong Group ID")
    @NotNull
    private String inlongGroupId;
    @ApiModelProperty(value="Schedule type")
    private Integer scheduleType;
    @ApiModelProperty(value="TimeUnit for schedule interval")
    private String scheduleUnit;
    @ApiModelProperty(value="Schedule interval")
    private Integer scheduleInterval;
    @ApiModelProperty(value="Start time")
    private Timestamp startTime;
    @ApiModelProperty(value="End time")
    private Timestamp endTime;
    @ApiModelProperty(value="Delay time")
    private Integer delayTime;
    @ApiModelProperty(value="Self depend")
    private Integer selfDepend;
    @ApiModelProperty(value="Schedule task parallelism")
    private Integer taskParallelism;
    @ApiModelProperty(value="Schedule task parallelism")
    private String crontabExpression;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="version cannot be null") Integer version;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleInfo that = (ScheduleInfo)o;
        return Objects.equals(this.inlongGroupId, that.inlongGroupId) && Objects.equals(this.scheduleType, that.scheduleType) && Objects.equals(this.scheduleUnit, that.scheduleUnit) && Objects.equals(this.scheduleInterval, that.scheduleInterval) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.delayTime, that.delayTime) && Objects.equals(this.selfDepend, that.selfDepend) && Objects.equals(this.taskParallelism, that.taskParallelism) && Objects.equals(this.crontabExpression, that.crontabExpression);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.inlongGroupId, this.scheduleType, this.scheduleUnit, this.scheduleInterval, this.startTime, this.endTime, this.delayTime, this.selfDepend, this.taskParallelism, this.crontabExpression, this.version);
    }

    public static ScheduleInfoBuilder builder() {
        return new ScheduleInfoBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public Integer getScheduleType() {
        return this.scheduleType;
    }

    public String getScheduleUnit() {
        return this.scheduleUnit;
    }

    public Integer getScheduleInterval() {
        return this.scheduleInterval;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public Integer getDelayTime() {
        return this.delayTime;
    }

    public Integer getSelfDepend() {
        return this.selfDepend;
    }

    public Integer getTaskParallelism() {
        return this.taskParallelism;
    }

    public String getCrontabExpression() {
        return this.crontabExpression;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setScheduleType(Integer scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setScheduleUnit(String scheduleUnit) {
        this.scheduleUnit = scheduleUnit;
    }

    public void setScheduleInterval(Integer scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setDelayTime(Integer delayTime) {
        this.delayTime = delayTime;
    }

    public void setSelfDepend(Integer selfDepend) {
        this.selfDepend = selfDepend;
    }

    public void setTaskParallelism(Integer taskParallelism) {
        this.taskParallelism = taskParallelism;
    }

    public void setCrontabExpression(String crontabExpression) {
        this.crontabExpression = crontabExpression;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String toString() {
        return "ScheduleInfo(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", scheduleType=" + this.getScheduleType() + ", scheduleUnit=" + this.getScheduleUnit() + ", scheduleInterval=" + this.getScheduleInterval() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", delayTime=" + this.getDelayTime() + ", selfDepend=" + this.getSelfDepend() + ", taskParallelism=" + this.getTaskParallelism() + ", crontabExpression=" + this.getCrontabExpression() + ", version=" + this.getVersion() + ")";
    }

    public ScheduleInfo() {
    }

    public ScheduleInfo(Integer id, String inlongGroupId, Integer scheduleType, String scheduleUnit, Integer scheduleInterval, Timestamp startTime, Timestamp endTime, Integer delayTime, Integer selfDepend, Integer taskParallelism, String crontabExpression, Integer version) {
        this.id = id;
        this.inlongGroupId = inlongGroupId;
        this.scheduleType = scheduleType;
        this.scheduleUnit = scheduleUnit;
        this.scheduleInterval = scheduleInterval;
        this.startTime = startTime;
        this.endTime = endTime;
        this.delayTime = delayTime;
        this.selfDepend = selfDepend;
        this.taskParallelism = taskParallelism;
        this.crontabExpression = crontabExpression;
        this.version = version;
    }

    public static class ScheduleInfoBuilder {
        private Integer id;
        private String inlongGroupId;
        private Integer scheduleType;
        private String scheduleUnit;
        private Integer scheduleInterval;
        private Timestamp startTime;
        private Timestamp endTime;
        private Integer delayTime;
        private Integer selfDepend;
        private Integer taskParallelism;
        private String crontabExpression;
        private Integer version;

        ScheduleInfoBuilder() {
        }

        public ScheduleInfoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ScheduleInfoBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public ScheduleInfoBuilder scheduleType(Integer scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public ScheduleInfoBuilder scheduleUnit(String scheduleUnit) {
            this.scheduleUnit = scheduleUnit;
            return this;
        }

        public ScheduleInfoBuilder scheduleInterval(Integer scheduleInterval) {
            this.scheduleInterval = scheduleInterval;
            return this;
        }

        public ScheduleInfoBuilder startTime(Timestamp startTime) {
            this.startTime = startTime;
            return this;
        }

        public ScheduleInfoBuilder endTime(Timestamp endTime) {
            this.endTime = endTime;
            return this;
        }

        public ScheduleInfoBuilder delayTime(Integer delayTime) {
            this.delayTime = delayTime;
            return this;
        }

        public ScheduleInfoBuilder selfDepend(Integer selfDepend) {
            this.selfDepend = selfDepend;
            return this;
        }

        public ScheduleInfoBuilder taskParallelism(Integer taskParallelism) {
            this.taskParallelism = taskParallelism;
            return this;
        }

        public ScheduleInfoBuilder crontabExpression(String crontabExpression) {
            this.crontabExpression = crontabExpression;
            return this;
        }

        public ScheduleInfoBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public ScheduleInfo build() {
            return new ScheduleInfo(this.id, this.inlongGroupId, this.scheduleType, this.scheduleUnit, this.scheduleInterval, this.startTime, this.endTime, this.delayTime, this.selfDepend, this.taskParallelism, this.crontabExpression, this.version);
        }

        public String toString() {
            return "ScheduleInfo.ScheduleInfoBuilder(id=" + this.id + ", inlongGroupId=" + this.inlongGroupId + ", scheduleType=" + this.scheduleType + ", scheduleUnit=" + this.scheduleUnit + ", scheduleInterval=" + this.scheduleInterval + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", delayTime=" + this.delayTime + ", selfDepend=" + this.selfDepend + ", taskParallelism=" + this.taskParallelism + ", crontabExpression=" + this.crontabExpression + ", version=" + this.version + ")";
        }
    }
}

