/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sort.node.ExtractNodeProviderFactory;
import org.apache.inlong.manager.pojo.sort.node.LoadNodeProviderFactory;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.sort.util.TransformNodeUtils;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.Node;
import org.apache.inlong.sort.protocol.node.transform.TransformNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodeFactory {
    private static final Logger log = LoggerFactory.getLogger(NodeFactory.class);
    @Autowired
    private LoadNodeProviderFactory loadNodeProviderFactory;
    @Autowired
    private ExtractNodeProviderFactory extractNodeProviderFactory;

    public List<ExtractNode> createExtractNodes(List<StreamSource> sourceInfos) {
        if (CollectionUtils.isEmpty(sourceInfos)) {
            return Lists.newArrayList();
        }
        return sourceInfos.stream().map(v -> {
            String sourceType = v.getSourceType();
            return this.extractNodeProviderFactory.getExtractNodeProvider(sourceType).createExtractNode((StreamNode)v);
        }).collect(Collectors.toList());
    }

    public List<LoadNode> createLoadNodes(List<StreamSink> sinkInfos, Map<String, StreamField> constantFieldMap) {
        if (CollectionUtils.isEmpty(sinkInfos)) {
            return Lists.newArrayList();
        }
        return sinkInfos.stream().map(v -> {
            String sinkType = v.getSinkType();
            return this.loadNodeProviderFactory.getLoadNodeProvider(sinkType).createLoadNode((StreamNode)v, constantFieldMap);
        }).collect(Collectors.toList());
    }

    public ExtractNode createExtractNode(StreamSource sourceInfo) {
        if (sourceInfo == null) {
            return null;
        }
        String sourceType = sourceInfo.getSourceType();
        return this.extractNodeProviderFactory.getExtractNodeProvider(sourceType).createExtractNode(sourceInfo);
    }

    public LoadNode createLoadNode(StreamSink sinkInfo, Map<String, StreamField> constantFieldMap) {
        if (sinkInfo == null) {
            return null;
        }
        String sinkType = sinkInfo.getSinkType();
        return this.loadNodeProviderFactory.getLoadNodeProvider(sinkType).createLoadNode(sinkInfo, constantFieldMap);
    }

    public List<Node> addBuiltInField(StreamSource sourceInfo, StreamSink sinkInfo, List<TransformResponse> transformResponses, Map<String, StreamField> constantFieldMap) {
        ExtractNodeProvider extractNodeProvider = this.extractNodeProviderFactory.getExtractNodeProvider(sourceInfo.getSourceType());
        LoadNodeProvider loadNodeProvider = this.loadNodeProviderFactory.getLoadNodeProvider(sinkInfo.getSinkType());
        if (loadNodeProvider.isSinkMultiple(sinkInfo).booleanValue()) {
            sourceInfo.setFieldList(loadNodeProvider.addStreamFieldsForSinkMultiple(sourceInfo.getFieldList()));
            sinkInfo.setSinkFieldList(loadNodeProvider.addSinkFieldsForSinkMultiple(sinkInfo.getSinkFieldList()));
        }
        if (FieldInfoUtils.compareFields(extractNodeProvider.getMetaFields(), loadNodeProvider.getMetaFields())) {
            extractNodeProvider.addStreamMetaFields(sourceInfo.getFieldList());
            if (CollectionUtils.isNotEmpty(transformResponses)) {
                transformResponses.forEach(v -> extractNodeProvider.addStreamMetaFields(v.getFieldList()));
            }
            loadNodeProvider.addSinkMetaFields(sinkInfo.getSinkFieldList());
        }
        ExtractNode extractNode = extractNodeProvider.createExtractNode(sourceInfo);
        List<TransformNode> transformNodes = TransformNodeUtils.createTransformNodes(transformResponses, constantFieldMap);
        LoadNode loadNode = loadNodeProvider.createLoadNode(sinkInfo, constantFieldMap);
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add((Node)extractNode);
        nodes.addAll(transformNodes);
        nodes.add((Node)loadNode);
        return nodes;
    }
}

