/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.file;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.file.FileSourceRequest;

public class FileSourceDTO {
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt")
    private String pattern;
    @ApiModelProperty(value="Path blacklist for file, which will be filtered and not collect")
    private String blackList;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;
    @ApiModelProperty(value="Properties for File")
    private Map<String, Object> properties;
    @ApiModelProperty(value="Line end regex pattern, for example: &end&")
    private String lineEndPattern;
    @ApiModelProperty(value="Type of file content, for example: FULL, INCREMENT")
    private String contentCollectType;
    @ApiModelProperty(value="File needs to collect environment information, for example: kubernetes")
    private String envList;
    @ApiModelProperty(value="Metadata of data, for example: [{data:field1,field2},{kubernetes:namespace,labels,name,uuid}] and so on")
    private List<Map<String, String>> metaFields;
    @ApiModelProperty(value=" Type of data result for column separator         CSV format, set this parameter to a custom separator: , | :          Json format, set this parameter to json ")
    private String dataContentStyle;
    @ApiModelProperty(value="Column separator of data source ")
    private String dataSeparator;
    @ApiModelProperty(value="Cycle unit")
    private String cycleUnit = "D";
    @ApiModelProperty(value="Max file count")
    private String maxFileCount;
    @ApiModelProperty(value="Time zone")
    private String timeZone;
    @ApiModelProperty(value="Whether retry")
    private Boolean retry = false;
    @ApiModelProperty(value="Start time")
    private Long startTime = 0L;
    @ApiModelProperty(value="End time")
    private Long endTime = 0L;
    @ApiModelProperty(value="Audit version")
    private String auditVersion;

    public static FileSourceDTO getFromRequest(@NotNull FileSourceRequest fileSourceRequest, String extParams) {
        FileSourceDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? FileSourceDTO.getFromJson(extParams) : new FileSourceDTO();
        return (FileSourceDTO)CommonBeanUtils.copyProperties((Object)fileSourceRequest, (Object)dto, (boolean)true);
    }

    public static FileSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (FileSourceDTO)JsonUtils.parseObject((String)extParams, FileSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("parse extParams of FileSource failure: %s", e.getMessage()));
        }
    }

    public static FileSourceDTOBuilder builder() {
        return new FileSourceDTOBuilder();
    }

    public FileSourceDTO(String pattern, String blackList, String timeOffset, Map<String, Object> properties, String lineEndPattern, String contentCollectType, String envList, List<Map<String, String>> metaFields, String dataContentStyle, String dataSeparator, String cycleUnit, String maxFileCount, String timeZone, Boolean retry, Long startTime, Long endTime, String auditVersion) {
        this.pattern = pattern;
        this.blackList = blackList;
        this.timeOffset = timeOffset;
        this.properties = properties;
        this.lineEndPattern = lineEndPattern;
        this.contentCollectType = contentCollectType;
        this.envList = envList;
        this.metaFields = metaFields;
        this.dataContentStyle = dataContentStyle;
        this.dataSeparator = dataSeparator;
        this.cycleUnit = cycleUnit;
        this.maxFileCount = maxFileCount;
        this.timeZone = timeZone;
        this.retry = retry;
        this.startTime = startTime;
        this.endTime = endTime;
        this.auditVersion = auditVersion;
    }

    public FileSourceDTO() {
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getBlackList() {
        return this.blackList;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getLineEndPattern() {
        return this.lineEndPattern;
    }

    public String getContentCollectType() {
        return this.contentCollectType;
    }

    public String getEnvList() {
        return this.envList;
    }

    public List<Map<String, String>> getMetaFields() {
        return this.metaFields;
    }

    public String getDataContentStyle() {
        return this.dataContentStyle;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getCycleUnit() {
        return this.cycleUnit;
    }

    public String getMaxFileCount() {
        return this.maxFileCount;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getAuditVersion() {
        return this.auditVersion;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setBlackList(String blackList) {
        this.blackList = blackList;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setLineEndPattern(String lineEndPattern) {
        this.lineEndPattern = lineEndPattern;
    }

    public void setContentCollectType(String contentCollectType) {
        this.contentCollectType = contentCollectType;
    }

    public void setEnvList(String envList) {
        this.envList = envList;
    }

    public void setMetaFields(List<Map<String, String>> metaFields) {
        this.metaFields = metaFields;
    }

    public void setDataContentStyle(String dataContentStyle) {
        this.dataContentStyle = dataContentStyle;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setCycleUnit(String cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public void setMaxFileCount(String maxFileCount) {
        this.maxFileCount = maxFileCount;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public void setAuditVersion(String auditVersion) {
        this.auditVersion = auditVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSourceDTO)) {
            return false;
        }
        FileSourceDTO other = (FileSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$retry = this.getRetry();
        Boolean other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$blackList = this.getBlackList();
        String other$blackList = other.getBlackList();
        if (this$blackList == null ? other$blackList != null : !this$blackList.equals(other$blackList)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        if (this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$lineEndPattern = this.getLineEndPattern();
        String other$lineEndPattern = other.getLineEndPattern();
        if (this$lineEndPattern == null ? other$lineEndPattern != null : !this$lineEndPattern.equals(other$lineEndPattern)) {
            return false;
        }
        String this$contentCollectType = this.getContentCollectType();
        String other$contentCollectType = other.getContentCollectType();
        if (this$contentCollectType == null ? other$contentCollectType != null : !this$contentCollectType.equals(other$contentCollectType)) {
            return false;
        }
        String this$envList = this.getEnvList();
        String other$envList = other.getEnvList();
        if (this$envList == null ? other$envList != null : !this$envList.equals(other$envList)) {
            return false;
        }
        List<Map<String, String>> this$metaFields = this.getMetaFields();
        List<Map<String, String>> other$metaFields = other.getMetaFields();
        if (this$metaFields == null ? other$metaFields != null : !((Object)this$metaFields).equals(other$metaFields)) {
            return false;
        }
        String this$dataContentStyle = this.getDataContentStyle();
        String other$dataContentStyle = other.getDataContentStyle();
        if (this$dataContentStyle == null ? other$dataContentStyle != null : !this$dataContentStyle.equals(other$dataContentStyle)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$cycleUnit = this.getCycleUnit();
        String other$cycleUnit = other.getCycleUnit();
        if (this$cycleUnit == null ? other$cycleUnit != null : !this$cycleUnit.equals(other$cycleUnit)) {
            return false;
        }
        String this$maxFileCount = this.getMaxFileCount();
        String other$maxFileCount = other.getMaxFileCount();
        if (this$maxFileCount == null ? other$maxFileCount != null : !this$maxFileCount.equals(other$maxFileCount)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$auditVersion = this.getAuditVersion();
        String other$auditVersion = other.getAuditVersion();
        return !(this$auditVersion == null ? other$auditVersion != null : !this$auditVersion.equals(other$auditVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $blackList = this.getBlackList();
        result = result * 59 + ($blackList == null ? 43 : $blackList.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $lineEndPattern = this.getLineEndPattern();
        result = result * 59 + ($lineEndPattern == null ? 43 : $lineEndPattern.hashCode());
        String $contentCollectType = this.getContentCollectType();
        result = result * 59 + ($contentCollectType == null ? 43 : $contentCollectType.hashCode());
        String $envList = this.getEnvList();
        result = result * 59 + ($envList == null ? 43 : $envList.hashCode());
        List<Map<String, String>> $metaFields = this.getMetaFields();
        result = result * 59 + ($metaFields == null ? 43 : ((Object)$metaFields).hashCode());
        String $dataContentStyle = this.getDataContentStyle();
        result = result * 59 + ($dataContentStyle == null ? 43 : $dataContentStyle.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $cycleUnit = this.getCycleUnit();
        result = result * 59 + ($cycleUnit == null ? 43 : $cycleUnit.hashCode());
        String $maxFileCount = this.getMaxFileCount();
        result = result * 59 + ($maxFileCount == null ? 43 : $maxFileCount.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $auditVersion = this.getAuditVersion();
        result = result * 59 + ($auditVersion == null ? 43 : $auditVersion.hashCode());
        return result;
    }

    public String toString() {
        return "FileSourceDTO(pattern=" + this.getPattern() + ", blackList=" + this.getBlackList() + ", timeOffset=" + this.getTimeOffset() + ", properties=" + this.getProperties() + ", lineEndPattern=" + this.getLineEndPattern() + ", contentCollectType=" + this.getContentCollectType() + ", envList=" + this.getEnvList() + ", metaFields=" + this.getMetaFields() + ", dataContentStyle=" + this.getDataContentStyle() + ", dataSeparator=" + this.getDataSeparator() + ", cycleUnit=" + this.getCycleUnit() + ", maxFileCount=" + this.getMaxFileCount() + ", timeZone=" + this.getTimeZone() + ", retry=" + this.getRetry() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", auditVersion=" + this.getAuditVersion() + ")";
    }

    public static class FileSourceDTOBuilder {
        private String pattern;
        private String blackList;
        private String timeOffset;
        private Map<String, Object> properties;
        private String lineEndPattern;
        private String contentCollectType;
        private String envList;
        private List<Map<String, String>> metaFields;
        private String dataContentStyle;
        private String dataSeparator;
        private String cycleUnit;
        private String maxFileCount;
        private String timeZone;
        private Boolean retry;
        private Long startTime;
        private Long endTime;
        private String auditVersion;

        FileSourceDTOBuilder() {
        }

        public FileSourceDTOBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public FileSourceDTOBuilder blackList(String blackList) {
            this.blackList = blackList;
            return this;
        }

        public FileSourceDTOBuilder timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public FileSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public FileSourceDTOBuilder lineEndPattern(String lineEndPattern) {
            this.lineEndPattern = lineEndPattern;
            return this;
        }

        public FileSourceDTOBuilder contentCollectType(String contentCollectType) {
            this.contentCollectType = contentCollectType;
            return this;
        }

        public FileSourceDTOBuilder envList(String envList) {
            this.envList = envList;
            return this;
        }

        public FileSourceDTOBuilder metaFields(List<Map<String, String>> metaFields) {
            this.metaFields = metaFields;
            return this;
        }

        public FileSourceDTOBuilder dataContentStyle(String dataContentStyle) {
            this.dataContentStyle = dataContentStyle;
            return this;
        }

        public FileSourceDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public FileSourceDTOBuilder cycleUnit(String cycleUnit) {
            this.cycleUnit = cycleUnit;
            return this;
        }

        public FileSourceDTOBuilder maxFileCount(String maxFileCount) {
            this.maxFileCount = maxFileCount;
            return this;
        }

        public FileSourceDTOBuilder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public FileSourceDTOBuilder retry(Boolean retry) {
            this.retry = retry;
            return this;
        }

        public FileSourceDTOBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public FileSourceDTOBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public FileSourceDTOBuilder auditVersion(String auditVersion) {
            this.auditVersion = auditVersion;
            return this;
        }

        public FileSourceDTO build() {
            return new FileSourceDTO(this.pattern, this.blackList, this.timeOffset, this.properties, this.lineEndPattern, this.contentCollectType, this.envList, this.metaFields, this.dataContentStyle, this.dataSeparator, this.cycleUnit, this.maxFileCount, this.timeZone, this.retry, this.startTime, this.endTime, this.auditVersion);
        }

        public String toString() {
            return "FileSourceDTO.FileSourceDTOBuilder(pattern=" + this.pattern + ", blackList=" + this.blackList + ", timeOffset=" + this.timeOffset + ", properties=" + this.properties + ", lineEndPattern=" + this.lineEndPattern + ", contentCollectType=" + this.contentCollectType + ", envList=" + this.envList + ", metaFields=" + this.metaFields + ", dataContentStyle=" + this.dataContentStyle + ", dataSeparator=" + this.dataSeparator + ", cycleUnit=" + this.cycleUnit + ", maxFileCount=" + this.maxFileCount + ", timeZone=" + this.timeZone + ", retry=" + this.retry + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", auditVersion=" + this.auditVersion + ")";
        }
    }
}

