/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.util;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.exceptions.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLSensitiveUrlUtils {
    private static final Logger log = LoggerFactory.getLogger(MySQLSensitiveUrlUtils.class);
    private static final Map<String, String> SENSITIVE_REPLACE_PARAM_MAP = new HashMap<String, String>(){
        {
            this.put("autoDeserialize", "false");
            this.put("allowLoadLocalInfile", "false");
            this.put("allowUrlInLocalInfile", "false");
        }
    };
    private static final Set<String> SENSITIVE_REMOVE_PARAM_MAP = new HashSet<String>(){
        {
            this.add("allowLoadLocalInfileInPath");
        }
    };

    public static String filterSensitive(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        try {
            String resultUrl = url;
            while (resultUrl.contains("%")) {
                resultUrl = URLDecoder.decode(resultUrl, "UTF-8");
            }
            resultUrl = resultUrl.replaceAll("\\s", "");
            for (String key2 : SENSITIVE_REPLACE_PARAM_MAP.keySet()) {
                resultUrl = StringUtils.replaceIgnoreCase((String)resultUrl, (String)(key2 + "=" + "true"), (String)"");
                resultUrl = StringUtils.replaceIgnoreCase((String)resultUrl, (String)(key2 + "=" + "yes"), (String)"");
            }
            if (resultUrl.contains("?")) {
                StringBuilder builder = new StringBuilder();
                builder.append(StringUtils.substringBefore((String)resultUrl, (String)"?"));
                builder.append("?");
                ArrayList<String> paramList = new ArrayList<String>();
                String queryString = StringUtils.substringAfter((String)resultUrl, (String)"?");
                if (queryString.contains("#")) {
                    queryString = StringUtils.substringBefore((String)queryString, (String)"#");
                }
                for (String param : queryString.split("&")) {
                    if (StringUtils.isBlank((CharSequence)param)) continue;
                    String key3 = StringUtils.substringBefore((String)param, (String)"=");
                    String value2 = StringUtils.substringAfter((String)param, (String)"=");
                    if (SENSITIVE_REMOVE_PARAM_MAP.contains(key3) || SENSITIVE_REPLACE_PARAM_MAP.containsKey(key3)) continue;
                    paramList.add(key3 + "=" + value2);
                }
                SENSITIVE_REPLACE_PARAM_MAP.forEach((key, value) -> paramList.add(key + "=" + value));
                String params = StringUtils.join(paramList, (String)"&");
                builder.append(params);
                resultUrl = builder.toString();
            }
            log.info("MySQL original URL {} was replaced to {}", (Object)url, (Object)resultUrl);
            return resultUrl;
        }
        catch (Exception e) {
            throw new BaseException(String.format("Failed to filter MySQL sensitive URL: %s, error: %s", url, e.getMessage()));
        }
    }
}

