/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.audit;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.inlong.manager.common.enums.TimeStaticsDim;

@ApiModel(value="Audit query request")
public class AuditRequest {
    @NotBlank(message="inlongGroupId not be blank")
    @ApiModelProperty(value="inlong group id", required=true)
    private @NotBlank(message="inlongGroupId not be blank") String inlongGroupId;
    @NotBlank(message="inlongStreamId not be blank")
    @ApiModelProperty(value="inlong stream id", required=true)
    private @NotBlank(message="inlongStreamId not be blank") String inlongStreamId;
    @NotEmpty(message="auditIds not be empty")
    @ApiModelProperty(value="audit id list", required=true)
    private @NotEmpty(message="auditIds not be empty") List<String> auditIds;
    @ApiModelProperty(value="query date, format by 'yyyy-MM-dd'", required=true, example="2022-01-01")
    @NotBlank(message="dt not be blank")
    private @NotBlank(message="dt not be blank") String dt;
    @ApiModelProperty(value="time statics dim, default MINUTE", required=true, example="MINUTE")
    private TimeStaticsDim timeStaticsDim = TimeStaticsDim.MINUTE;

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public List<String> getAuditIds() {
        return this.auditIds;
    }

    public String getDt() {
        return this.dt;
    }

    public TimeStaticsDim getTimeStaticsDim() {
        return this.timeStaticsDim;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setAuditIds(List<String> auditIds) {
        this.auditIds = auditIds;
    }

    public void setDt(String dt) {
        this.dt = dt;
    }

    public void setTimeStaticsDim(TimeStaticsDim timeStaticsDim) {
        this.timeStaticsDim = timeStaticsDim;
    }

    public String toString() {
        return "AuditRequest(inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", auditIds=" + this.getAuditIds() + ", dt=" + this.getDt() + ", timeStaticsDim=" + this.getTimeStaticsDim() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditRequest)) {
            return false;
        }
        AuditRequest other = (AuditRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        List<String> this$auditIds = this.getAuditIds();
        List<String> other$auditIds = other.getAuditIds();
        if (this$auditIds == null ? other$auditIds != null : !((Object)this$auditIds).equals(other$auditIds)) {
            return false;
        }
        String this$dt = this.getDt();
        String other$dt = other.getDt();
        if (this$dt == null ? other$dt != null : !this$dt.equals(other$dt)) {
            return false;
        }
        TimeStaticsDim this$timeStaticsDim = this.getTimeStaticsDim();
        TimeStaticsDim other$timeStaticsDim = other.getTimeStaticsDim();
        return !(this$timeStaticsDim == null ? other$timeStaticsDim != null : !this$timeStaticsDim.equals(other$timeStaticsDim));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        List<String> $auditIds = this.getAuditIds();
        result = result * 59 + ($auditIds == null ? 43 : ((Object)$auditIds).hashCode());
        String $dt = this.getDt();
        result = result * 59 + ($dt == null ? 43 : $dt.hashCode());
        TimeStaticsDim $timeStaticsDim = this.getTimeStaticsDim();
        result = result * 59 + ($timeStaticsDim == null ? 43 : $timeStaticsDim.hashCode());
        return result;
    }
}

