/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.pojo.common.PageRequest;

@ApiModel(value="Inlong cluster paging query request")
public class ClusterPageRequest
extends PageRequest {
    @ApiModelProperty(value="Cluster type, including TUBEMQ, PULSAR, DATAPROXY, etc.")
    private String type;
    @ApiModelProperty(value="Cluster type list")
    private List<String> typeList;
    @ApiModelProperty(value="Cluster name")
    private String name;
    @ApiModelProperty(value="Parent cluster ID, used for cluster node")
    private Integer parentId;
    @ApiModelProperty(value="Keywords, name, url, cluster tag, etc.")
    private String keyword;
    @ApiModelProperty(value="Cluster tag")
    private String clusterTag;
    @ApiModelProperty(value="Extend tag")
    private String extTag;
    @ApiModelProperty(value="The inlong cluster tag list")
    private List<String> clusterTagList;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;

    public static ClusterPageRequestBuilder builder() {
        return new ClusterPageRequestBuilder();
    }

    public String getType() {
        return this.type;
    }

    public List<String> getTypeList() {
        return this.typeList;
    }

    public String getName() {
        return this.name;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getExtTag() {
        return this.extTag;
    }

    public List<String> getClusterTagList() {
        return this.clusterTagList;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setExtTag(String extTag) {
        this.extTag = extTag;
    }

    public void setClusterTagList(List<String> clusterTagList) {
        this.clusterTagList = clusterTagList;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public String toString() {
        return "ClusterPageRequest(type=" + this.getType() + ", typeList=" + this.getTypeList() + ", name=" + this.getName() + ", parentId=" + this.getParentId() + ", keyword=" + this.getKeyword() + ", clusterTag=" + this.getClusterTag() + ", extTag=" + this.getExtTag() + ", clusterTagList=" + this.getClusterTagList() + ", status=" + this.getStatus() + ", currentUser=" + this.getCurrentUser() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterPageRequest)) {
            return false;
        }
        ClusterPageRequest other = (ClusterPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$parentId = this.getParentId();
        Integer other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$typeList = this.getTypeList();
        List<String> other$typeList = other.getTypeList();
        if (this$typeList == null ? other$typeList != null : !((Object)this$typeList).equals(other$typeList)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        String this$extTag = this.getExtTag();
        String other$extTag = other.getExtTag();
        if (this$extTag == null ? other$extTag != null : !this$extTag.equals(other$extTag)) {
            return false;
        }
        List<String> this$clusterTagList = this.getClusterTagList();
        List<String> other$clusterTagList = other.getClusterTagList();
        if (this$clusterTagList == null ? other$clusterTagList != null : !((Object)this$clusterTagList).equals(other$clusterTagList)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        return !(this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterPageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $typeList = this.getTypeList();
        result = result * 59 + ($typeList == null ? 43 : ((Object)$typeList).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        String $extTag = this.getExtTag();
        result = result * 59 + ($extTag == null ? 43 : $extTag.hashCode());
        List<String> $clusterTagList = this.getClusterTagList();
        result = result * 59 + ($clusterTagList == null ? 43 : ((Object)$clusterTagList).hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        return result;
    }

    public ClusterPageRequest() {
    }

    public ClusterPageRequest(String type, List<String> typeList, String name, Integer parentId, String keyword, String clusterTag, String extTag, List<String> clusterTagList, Integer status, String currentUser) {
        this.type = type;
        this.typeList = typeList;
        this.name = name;
        this.parentId = parentId;
        this.keyword = keyword;
        this.clusterTag = clusterTag;
        this.extTag = extTag;
        this.clusterTagList = clusterTagList;
        this.status = status;
        this.currentUser = currentUser;
    }

    public static class ClusterPageRequestBuilder {
        private String type;
        private List<String> typeList;
        private String name;
        private Integer parentId;
        private String keyword;
        private String clusterTag;
        private String extTag;
        private List<String> clusterTagList;
        private Integer status;
        private String currentUser;

        ClusterPageRequestBuilder() {
        }

        public ClusterPageRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ClusterPageRequestBuilder typeList(List<String> typeList) {
            this.typeList = typeList;
            return this;
        }

        public ClusterPageRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ClusterPageRequestBuilder parentId(Integer parentId) {
            this.parentId = parentId;
            return this;
        }

        public ClusterPageRequestBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public ClusterPageRequestBuilder clusterTag(String clusterTag) {
            this.clusterTag = clusterTag;
            return this;
        }

        public ClusterPageRequestBuilder extTag(String extTag) {
            this.extTag = extTag;
            return this;
        }

        public ClusterPageRequestBuilder clusterTagList(List<String> clusterTagList) {
            this.clusterTagList = clusterTagList;
            return this;
        }

        public ClusterPageRequestBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public ClusterPageRequestBuilder currentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public ClusterPageRequest build() {
            return new ClusterPageRequest(this.type, this.typeList, this.name, this.parentId, this.keyword, this.clusterTag, this.extTag, this.clusterTagList, this.status, this.currentUser);
        }

        public String toString() {
            return "ClusterPageRequest.ClusterPageRequestBuilder(type=" + this.type + ", typeList=" + this.typeList + ", name=" + this.name + ", parentId=" + this.parentId + ", keyword=" + this.keyword + ", clusterTag=" + this.clusterTag + ", extTag=" + this.extTag + ", clusterTagList=" + this.clusterTagList + ", status=" + this.status + ", currentUser=" + this.currentUser + ")";
        }
    }
}

