/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterRequest;

@JsonTypeDefine(value="PULSAR")
@ApiModel(value="Inlong cluster info for Pulsar")
public class PulsarClusterInfo
extends ClusterInfo {
    @ApiModelProperty(value="Pulsar admin URL, such as: http://127.0.0.1:8080", notes="Pulsar service URL is the 'url' field of the cluster")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar tenant, default is 'public'")
    private String tenant;

    public PulsarClusterInfo() {
        this.setType("PULSAR");
    }

    @Override
    public PulsarClusterRequest genRequest() {
        return (PulsarClusterRequest)CommonBeanUtils.copyProperties((Object)this, PulsarClusterRequest::new);
    }

    private static String $default$tenant() {
        return "public";
    }

    protected PulsarClusterInfo(PulsarClusterInfoBuilder<?, ?> b) {
        super(b);
        this.adminUrl = ((PulsarClusterInfoBuilder)b).adminUrl;
        this.tenant = ((PulsarClusterInfoBuilder)b).tenant$set ? ((PulsarClusterInfoBuilder)b).tenant$value : PulsarClusterInfo.$default$tenant();
    }

    public static PulsarClusterInfoBuilder<?, ?> builder() {
        return new PulsarClusterInfoBuilderImpl();
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Override
    public String toString() {
        return "PulsarClusterInfo(super=" + super.toString() + ", adminUrl=" + this.getAdminUrl() + ", tenant=" + this.getTenant() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarClusterInfo)) {
            return false;
        }
        PulsarClusterInfo other = (PulsarClusterInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarClusterInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    private static final class PulsarClusterInfoBuilderImpl
    extends PulsarClusterInfoBuilder<PulsarClusterInfo, PulsarClusterInfoBuilderImpl> {
        private PulsarClusterInfoBuilderImpl() {
        }

        @Override
        protected PulsarClusterInfoBuilderImpl self() {
            return this;
        }

        @Override
        public PulsarClusterInfo build() {
            return new PulsarClusterInfo(this);
        }
    }

    public static abstract class PulsarClusterInfoBuilder<C extends PulsarClusterInfo, B extends PulsarClusterInfoBuilder<C, B>>
    extends ClusterInfo.ClusterInfoBuilder<C, B> {
        private String adminUrl;
        private boolean tenant$set;
        private String tenant$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return (B)this.self();
        }

        public B tenant(String tenant) {
            this.tenant$value = tenant;
            this.tenant$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PulsarClusterInfo.PulsarClusterInfoBuilder(super=" + super.toString() + ", adminUrl=" + this.adminUrl + ", tenant$value=" + this.tenant$value + ")";
        }
    }
}

