/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.consumption;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.consumption.ConsumptionMqExtBase;

@ApiModel(value="Data consumption info")
public class ConsumptionInfo {
    @ApiModelProperty(value="key id")
    private Integer id;
    @ApiModelProperty(value="consumer group: only support [a-zA-Z0-9_]")
    @NotBlank(message="consumerGroup cannot be null")
    private @NotBlank(message="consumerGroup cannot be null") String consumerGroup;
    @ApiModelProperty(value="consumption in charge")
    @NotBlank(message="inCharges cannot be null")
    private @NotBlank(message="inCharges cannot be null") String inCharges;
    @ApiModelProperty(value="consumption target inlong group id")
    @NotBlank(message="inlong group id cannot be null")
    private @NotBlank(message="inlong group id cannot be null") String inlongGroupId;
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    private String mqType;
    @ApiModelProperty(value="consumption target topic")
    private String topic;
    @ApiModelProperty(value="middleware cluster url")
    private String masterUrl;
    @ApiModelProperty(value="whether to filter consumption, 0: not filter, 1: filter")
    private Integer filterEnabled;
    @ApiModelProperty(value="consumption target inlong stream id")
    private String inlongStreamId;
    @ApiModelProperty(value="status, 10: pending assigned, 11: pending approval, 20: approval rejected, 20: approved")
    private Integer status;
    private String creator;
    private String modifier;
    private Date createTime;
    private Date modifyTime;
    @ApiModelProperty(value="Extended information for MQ")
    private ConsumptionMqExtBase mqExtInfo;
    @ApiModelProperty(value="Version number")
    private Integer version;

    @JsonIgnore
    @AssertTrue(message="when filter enabled, inlong stream id cannot be null")
    public @AssertTrue(message="when filter enabled, inlong stream id cannot be null") boolean isValidateFilter() {
        if (this.filterEnabled == 0) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.inlongStreamId);
    }

    private static Integer $default$filterEnabled() {
        return 0;
    }

    public static ConsumptionInfoBuilder builder() {
        return new ConsumptionInfoBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public Integer getFilterEnabled() {
        return this.filterEnabled;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public ConsumptionMqExtBase getMqExtInfo() {
        return this.mqExtInfo;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    public void setFilterEnabled(Integer filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setMqExtInfo(ConsumptionMqExtBase mqExtInfo) {
        this.mqExtInfo = mqExtInfo;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumptionInfo)) {
            return false;
        }
        ConsumptionInfo other = (ConsumptionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$filterEnabled = this.getFilterEnabled();
        Integer other$filterEnabled = other.getFilterEnabled();
        if (this$filterEnabled == null ? other$filterEnabled != null : !((Object)this$filterEnabled).equals(other$filterEnabled)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$consumerGroup = this.getConsumerGroup();
        String other$consumerGroup = other.getConsumerGroup();
        if (this$consumerGroup == null ? other$consumerGroup != null : !this$consumerGroup.equals(other$consumerGroup)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$masterUrl = this.getMasterUrl();
        String other$masterUrl = other.getMasterUrl();
        if (this$masterUrl == null ? other$masterUrl != null : !this$masterUrl.equals(other$masterUrl)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        ConsumptionMqExtBase this$mqExtInfo = this.getMqExtInfo();
        ConsumptionMqExtBase other$mqExtInfo = other.getMqExtInfo();
        return !(this$mqExtInfo == null ? other$mqExtInfo != null : !((Object)this$mqExtInfo).equals(other$mqExtInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumptionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $filterEnabled = this.getFilterEnabled();
        result = result * 59 + ($filterEnabled == null ? 43 : ((Object)$filterEnabled).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $consumerGroup = this.getConsumerGroup();
        result = result * 59 + ($consumerGroup == null ? 43 : $consumerGroup.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $masterUrl = this.getMasterUrl();
        result = result * 59 + ($masterUrl == null ? 43 : $masterUrl.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        ConsumptionMqExtBase $mqExtInfo = this.getMqExtInfo();
        result = result * 59 + ($mqExtInfo == null ? 43 : ((Object)$mqExtInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ConsumptionInfo(id=" + this.getId() + ", consumerGroup=" + this.getConsumerGroup() + ", inCharges=" + this.getInCharges() + ", inlongGroupId=" + this.getInlongGroupId() + ", mqType=" + this.getMqType() + ", topic=" + this.getTopic() + ", masterUrl=" + this.getMasterUrl() + ", filterEnabled=" + this.getFilterEnabled() + ", inlongStreamId=" + this.getInlongStreamId() + ", status=" + this.getStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", mqExtInfo=" + this.getMqExtInfo() + ", version=" + this.getVersion() + ")";
    }

    public ConsumptionInfo() {
        this.filterEnabled = ConsumptionInfo.$default$filterEnabled();
    }

    public ConsumptionInfo(Integer id, String consumerGroup, String inCharges, String inlongGroupId, String mqType, String topic, String masterUrl, Integer filterEnabled, String inlongStreamId, Integer status, String creator, String modifier, Date createTime, Date modifyTime, ConsumptionMqExtBase mqExtInfo, Integer version) {
        this.id = id;
        this.consumerGroup = consumerGroup;
        this.inCharges = inCharges;
        this.inlongGroupId = inlongGroupId;
        this.mqType = mqType;
        this.topic = topic;
        this.masterUrl = masterUrl;
        this.filterEnabled = filterEnabled;
        this.inlongStreamId = inlongStreamId;
        this.status = status;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.mqExtInfo = mqExtInfo;
        this.version = version;
    }

    public static class ConsumptionInfoBuilder {
        private Integer id;
        private String consumerGroup;
        private String inCharges;
        private String inlongGroupId;
        private String mqType;
        private String topic;
        private String masterUrl;
        private boolean filterEnabled$set;
        private Integer filterEnabled$value;
        private String inlongStreamId;
        private Integer status;
        private String creator;
        private String modifier;
        private Date createTime;
        private Date modifyTime;
        private ConsumptionMqExtBase mqExtInfo;
        private Integer version;

        ConsumptionInfoBuilder() {
        }

        public ConsumptionInfoBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public ConsumptionInfoBuilder consumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
            return this;
        }

        public ConsumptionInfoBuilder inCharges(String inCharges) {
            this.inCharges = inCharges;
            return this;
        }

        public ConsumptionInfoBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public ConsumptionInfoBuilder mqType(String mqType) {
            this.mqType = mqType;
            return this;
        }

        public ConsumptionInfoBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public ConsumptionInfoBuilder masterUrl(String masterUrl) {
            this.masterUrl = masterUrl;
            return this;
        }

        public ConsumptionInfoBuilder filterEnabled(Integer filterEnabled) {
            this.filterEnabled$value = filterEnabled;
            this.filterEnabled$set = true;
            return this;
        }

        public ConsumptionInfoBuilder inlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
            return this;
        }

        public ConsumptionInfoBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public ConsumptionInfoBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public ConsumptionInfoBuilder modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public ConsumptionInfoBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public ConsumptionInfoBuilder modifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }

        public ConsumptionInfoBuilder mqExtInfo(ConsumptionMqExtBase mqExtInfo) {
            this.mqExtInfo = mqExtInfo;
            return this;
        }

        public ConsumptionInfoBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public ConsumptionInfo build() {
            Integer filterEnabled$value = this.filterEnabled$value;
            if (!this.filterEnabled$set) {
                filterEnabled$value = ConsumptionInfo.$default$filterEnabled();
            }
            return new ConsumptionInfo(this.id, this.consumerGroup, this.inCharges, this.inlongGroupId, this.mqType, this.topic, this.masterUrl, filterEnabled$value, this.inlongStreamId, this.status, this.creator, this.modifier, this.createTime, this.modifyTime, this.mqExtInfo, this.version);
        }

        public String toString() {
            return "ConsumptionInfo.ConsumptionInfoBuilder(id=" + this.id + ", consumerGroup=" + this.consumerGroup + ", inCharges=" + this.inCharges + ", inlongGroupId=" + this.inlongGroupId + ", mqType=" + this.mqType + ", topic=" + this.topic + ", masterUrl=" + this.masterUrl + ", filterEnabled$value=" + this.filterEnabled$value + ", inlongStreamId=" + this.inlongStreamId + ", status=" + this.status + ", creator=" + this.creator + ", modifier=" + this.modifier + ", createTime=" + this.createTime + ", modifyTime=" + this.modifyTime + ", mqExtInfo=" + this.mqExtInfo + ", version=" + this.version + ")";
        }
    }
}

