/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.consumption;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.pojo.common.PageRequest;

@ApiModel(value="Data consumption query conditions")
public class ConsumptionQuery
extends PageRequest {
    @ApiModelProperty(value="Consumer Group")
    private String consumerGroup;
    @ApiModelProperty(value="Person in charge of consumption")
    private String inCharges;
    @ApiModelProperty(value="Consumption target inlong group id")
    private String inlongGroupId;
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    private String mqType;
    @ApiModelProperty(value="Consumption target Topic")
    private String topic;
    @ApiModelProperty(value="Whether to filter consumption")
    private Boolean filterEnabled;
    @ApiModelProperty(value="Consumption target stream id")
    private String inlongStreamId;
    @ApiModelProperty(value="Status: Draft: 0, Pending distribution: 10, Pending approval: 11, Approval rejected: 20, Approved: 21")
    private Integer status;
    @ApiModelProperty(value="Consumption status: normal: 0, abnormal: 1, shielded: 2, no: 3")
    private Integer lastConsumptionStatus;
    private String creator;
    private String modifier;
    @ApiModelProperty(value="Current login user")
    private String username;
    @ApiModelProperty(value="Weather current user have admin role", hidden=true)
    private Boolean isAdminRole;
    @ApiModelProperty(value="Fuzzy query keyword, topic, or consumer group")
    private String keyword;

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getTopic() {
        return this.topic;
    }

    public Boolean getFilterEnabled() {
        return this.filterEnabled;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getLastConsumptionStatus() {
        return this.lastConsumptionStatus;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public String getUsername() {
        return this.username;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setFilterEnabled(Boolean filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setLastConsumptionStatus(Integer lastConsumptionStatus) {
        this.lastConsumptionStatus = lastConsumptionStatus;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String toString() {
        return "ConsumptionQuery(consumerGroup=" + this.getConsumerGroup() + ", inCharges=" + this.getInCharges() + ", inlongGroupId=" + this.getInlongGroupId() + ", mqType=" + this.getMqType() + ", topic=" + this.getTopic() + ", filterEnabled=" + this.getFilterEnabled() + ", inlongStreamId=" + this.getInlongStreamId() + ", status=" + this.getStatus() + ", lastConsumptionStatus=" + this.getLastConsumptionStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", username=" + this.getUsername() + ", isAdminRole=" + this.getIsAdminRole() + ", keyword=" + this.getKeyword() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumptionQuery)) {
            return false;
        }
        ConsumptionQuery other = (ConsumptionQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$filterEnabled = this.getFilterEnabled();
        Boolean other$filterEnabled = other.getFilterEnabled();
        if (this$filterEnabled == null ? other$filterEnabled != null : !((Object)this$filterEnabled).equals(other$filterEnabled)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$lastConsumptionStatus = this.getLastConsumptionStatus();
        Integer other$lastConsumptionStatus = other.getLastConsumptionStatus();
        if (this$lastConsumptionStatus == null ? other$lastConsumptionStatus != null : !((Object)this$lastConsumptionStatus).equals(other$lastConsumptionStatus)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$consumerGroup = this.getConsumerGroup();
        String other$consumerGroup = other.getConsumerGroup();
        if (this$consumerGroup == null ? other$consumerGroup != null : !this$consumerGroup.equals(other$consumerGroup)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        return !(this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsumptionQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $filterEnabled = this.getFilterEnabled();
        result = result * 59 + ($filterEnabled == null ? 43 : ((Object)$filterEnabled).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $lastConsumptionStatus = this.getLastConsumptionStatus();
        result = result * 59 + ($lastConsumptionStatus == null ? 43 : ((Object)$lastConsumptionStatus).hashCode());
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $consumerGroup = this.getConsumerGroup();
        result = result * 59 + ($consumerGroup == null ? 43 : $consumerGroup.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        return result;
    }
}

