/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.dlciceberg;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.sink.dlciceberg.DLCIcebergSinkRequest;

public class DLCIcebergSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Catalog URI of the DLCIceberg server")
    private String catalogUri;
    @ApiModelProperty(value="Data warehouse of the DLCIceberg server")
    private String warehouse;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Properties for DLCIceberg")
    private Map<String, Object> properties;

    public static DLCIcebergSinkDTO getFromRequest(DLCIcebergSinkRequest request) {
        return DLCIcebergSinkDTO.builder().catalogUri(request.getCatalogUri()).warehouse(request.getWarehouse()).dbName(request.getDbName()).tableName(request.getTableName()).primaryKey(request.getPrimaryKey()).properties(request.getProperties()).build();
    }

    public static DLCIcebergSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (DLCIcebergSinkDTO)OBJECT_MAPPER.readValue(extParams, DLCIcebergSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static DLCIcebergSinkDTOBuilder builder() {
        return new DLCIcebergSinkDTOBuilder();
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DLCIcebergSinkDTO)) {
            return false;
        }
        DLCIcebergSinkDTO other = (DLCIcebergSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DLCIcebergSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "DLCIcebergSinkDTO(catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public DLCIcebergSinkDTO() {
    }

    public DLCIcebergSinkDTO(String catalogUri, String warehouse, String dbName, String tableName, String primaryKey, Map<String, Object> properties) {
        this.catalogUri = catalogUri;
        this.warehouse = warehouse;
        this.dbName = dbName;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class DLCIcebergSinkDTOBuilder {
        private String catalogUri;
        private String warehouse;
        private String dbName;
        private String tableName;
        private String primaryKey;
        private Map<String, Object> properties;

        DLCIcebergSinkDTOBuilder() {
        }

        public DLCIcebergSinkDTOBuilder catalogUri(String catalogUri) {
            this.catalogUri = catalogUri;
            return this;
        }

        public DLCIcebergSinkDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public DLCIcebergSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public DLCIcebergSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public DLCIcebergSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public DLCIcebergSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public DLCIcebergSinkDTO build() {
            return new DLCIcebergSinkDTO(this.catalogUri, this.warehouse, this.dbName, this.tableName, this.primaryKey, this.properties);
        }

        public String toString() {
            return "DLCIcebergSinkDTO.DLCIcebergSinkDTOBuilder(catalogUri=" + this.catalogUri + ", warehouse=" + this.warehouse + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

