/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.greenplum;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumColumnInfo;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumSinkRequest;
import org.apache.inlong.manager.pojo.sink.greenplum.GreenplumTableInfo;

public class GreenplumSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="JDBC URL of Greenplum server, such as: jdbc:postgresql://host:port/database")
    private String jdbcUrl;
    @ApiModelProperty(value="Username of Greenplum server")
    private String username;
    @ApiModelProperty(value="User password of Greenplum server")
    private String password;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Properties for greenplum")
    private Map<String, Object> properties;

    public static GreenplumSinkDTO getFromRequest(GreenplumSinkRequest request) {
        return GreenplumSinkDTO.builder().jdbcUrl(request.getJdbcUrl()).username(request.getUsername()).password(request.getPassword()).primaryKey(request.getPrimaryKey()).tableName(request.getTableName()).properties(request.getProperties()).build();
    }

    public static GreenplumSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (GreenplumSinkDTO)OBJECT_MAPPER.readValue(extParams, GreenplumSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static GreenplumTableInfo getTableInfo(GreenplumSinkDTO greenplumSink, List<GreenplumColumnInfo> columnList) {
        GreenplumTableInfo tableInfo = new GreenplumTableInfo();
        tableInfo.setTableName(greenplumSink.getTableName());
        tableInfo.setPrimaryKey(greenplumSink.getPrimaryKey());
        tableInfo.setUserName(greenplumSink.getUsername());
        tableInfo.setColumns(columnList);
        return tableInfo;
    }

    public static GreenplumSinkDTOBuilder builder() {
        return new GreenplumSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GreenplumSinkDTO)) {
            return false;
        }
        GreenplumSinkDTO other = (GreenplumSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GreenplumSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "GreenplumSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public GreenplumSinkDTO() {
    }

    public GreenplumSinkDTO(String jdbcUrl, String username, String password, String tableName, String primaryKey, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class GreenplumSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String tableName;
        private String primaryKey;
        private Map<String, Object> properties;

        GreenplumSinkDTOBuilder() {
        }

        public GreenplumSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public GreenplumSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public GreenplumSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public GreenplumSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public GreenplumSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public GreenplumSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public GreenplumSinkDTO build() {
            return new GreenplumSinkDTO(this.jdbcUrl, this.username, this.password, this.tableName, this.primaryKey, this.properties);
        }

        public String toString() {
            return "GreenplumSinkDTO.GreenplumSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

