/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hbase;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public class HBaseColumnFamilyInfo {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Column family name")
    private String cfName;
    @ApiModelProperty(value="Column family ttl")
    private Integer ttl;

    public static HBaseColumnFamilyInfo getFromJson(@NotNull String extParams) {
        if (StringUtils.isEmpty((CharSequence)extParams)) {
            return new HBaseColumnFamilyInfo();
        }
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (HBaseColumnFamilyInfo)OBJECT_MAPPER.readValue(extParams, HBaseColumnFamilyInfo.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static HBaseColumnFamilyInfoBuilder builder() {
        return new HBaseColumnFamilyInfoBuilder();
    }

    public String getCfName() {
        return this.cfName;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setCfName(String cfName) {
        this.cfName = cfName;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HBaseColumnFamilyInfo)) {
            return false;
        }
        HBaseColumnFamilyInfo other = (HBaseColumnFamilyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        String this$cfName = this.getCfName();
        String other$cfName = other.getCfName();
        return !(this$cfName == null ? other$cfName != null : !this$cfName.equals(other$cfName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HBaseColumnFamilyInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        String $cfName = this.getCfName();
        result = result * 59 + ($cfName == null ? 43 : $cfName.hashCode());
        return result;
    }

    public String toString() {
        return "HBaseColumnFamilyInfo(cfName=" + this.getCfName() + ", ttl=" + this.getTtl() + ")";
    }

    public HBaseColumnFamilyInfo() {
    }

    public HBaseColumnFamilyInfo(String cfName, Integer ttl) {
        this.cfName = cfName;
        this.ttl = ttl;
    }

    public static class HBaseColumnFamilyInfoBuilder {
        private String cfName;
        private Integer ttl;

        HBaseColumnFamilyInfoBuilder() {
        }

        public HBaseColumnFamilyInfoBuilder cfName(String cfName) {
            this.cfName = cfName;
            return this;
        }

        public HBaseColumnFamilyInfoBuilder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public HBaseColumnFamilyInfo build() {
            return new HBaseColumnFamilyInfo(this.cfName, this.ttl);
        }

        public String toString() {
            return "HBaseColumnFamilyInfo.HBaseColumnFamilyInfoBuilder(cfName=" + this.cfName + ", ttl=" + this.ttl + ")";
        }
    }
}

