/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.standalone;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortSourceClusterInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSourceClusterInfo.class);
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)"&").trimResults().withKeyValueSeparator("=");
    private static final String KEY_IS_CONSUMABLE = "consumer";
    private static final long serialVersionUID = 1L;
    String name;
    String type;
    String clusterTags;
    String extTag;
    String extParams;
    Map<String, String> extTagMap = new ConcurrentHashMap<String, String>();
    Map<String, String> extParamsMap = new ConcurrentHashMap<String, String>();

    public Map<String, String> getExtParamsMap() {
        if (this.extParamsMap.isEmpty() && this.extParams != null) {
            try {
                Gson gson = new Gson();
                this.extParamsMap = (Map)gson.fromJson(this.extParams, Map.class);
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse cluster ext params", t);
            }
        }
        return this.extParamsMap;
    }

    public Map<String, String> getExtTagMap() {
        if (this.extTagMap.isEmpty() && StringUtils.isNotBlank((CharSequence)this.extTag)) {
            try {
                this.extTagMap = MAP_SPLITTER.split((CharSequence)this.extTag);
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse cluster ext tag params", t);
            }
        }
        return this.extTagMap;
    }

    public boolean isConsumable() {
        String isConsumable = this.getExtTagMap().get(KEY_IS_CONSUMABLE);
        return isConsumable == null || "true".equalsIgnoreCase(isConsumable);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getClusterTags() {
        return this.clusterTags;
    }

    public String getExtTag() {
        return this.extTag;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClusterTags(String clusterTags) {
        this.clusterTags = clusterTags;
    }

    public void setExtTag(String extTag) {
        this.extTag = extTag;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setExtTagMap(Map<String, String> extTagMap) {
        this.extTagMap = extTagMap;
    }

    public void setExtParamsMap(Map<String, String> extParamsMap) {
        this.extParamsMap = extParamsMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortSourceClusterInfo)) {
            return false;
        }
        SortSourceClusterInfo other = (SortSourceClusterInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$clusterTags = this.getClusterTags();
        String other$clusterTags = other.getClusterTags();
        if (this$clusterTags == null ? other$clusterTags != null : !this$clusterTags.equals(other$clusterTags)) {
            return false;
        }
        String this$extTag = this.getExtTag();
        String other$extTag = other.getExtTag();
        if (this$extTag == null ? other$extTag != null : !this$extTag.equals(other$extTag)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        Map<String, String> this$extTagMap = this.getExtTagMap();
        Map<String, String> other$extTagMap = other.getExtTagMap();
        if (this$extTagMap == null ? other$extTagMap != null : !((Object)this$extTagMap).equals(other$extTagMap)) {
            return false;
        }
        Map<String, String> this$extParamsMap = this.getExtParamsMap();
        Map<String, String> other$extParamsMap = other.getExtParamsMap();
        return !(this$extParamsMap == null ? other$extParamsMap != null : !((Object)this$extParamsMap).equals(other$extParamsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortSourceClusterInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $clusterTags = this.getClusterTags();
        result = result * 59 + ($clusterTags == null ? 43 : $clusterTags.hashCode());
        String $extTag = this.getExtTag();
        result = result * 59 + ($extTag == null ? 43 : $extTag.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        Map<String, String> $extTagMap = this.getExtTagMap();
        result = result * 59 + ($extTagMap == null ? 43 : ((Object)$extTagMap).hashCode());
        Map<String, String> $extParamsMap = this.getExtParamsMap();
        result = result * 59 + ($extParamsMap == null ? 43 : ((Object)$extParamsMap).hashCode());
        return result;
    }

    public String toString() {
        return "SortSourceClusterInfo(name=" + this.getName() + ", type=" + this.getType() + ", clusterTags=" + this.getClusterTags() + ", extTag=" + this.getExtTag() + ", extParams=" + this.getExtParams() + ", extTagMap=" + this.getExtTagMap() + ", extParamsMap=" + this.getExtParamsMap() + ")";
    }
}

