/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.standalone;

import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortSourceGroupInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSourceGroupInfo.class);
    private static final String KEY_BACKUP_CLUSTER_TAG = "backup_cluster_tag";
    private static final String KEY_BACKUP_TOPIC = "backup_topic";
    private static final long serialVersionUID = 1L;
    String groupId;
    String clusterTag;
    String topic;
    String extParams;
    String mqType;
    Map<String, String> extParamsMap = new ConcurrentHashMap<String, String>();

    public Map<String, String> getExtParamsMap() {
        if (this.extParamsMap.isEmpty() && StringUtils.isNotBlank((CharSequence)this.extParams)) {
            try {
                Gson gson = new Gson();
                this.extParamsMap = (Map)gson.fromJson(this.extParams, Map.class);
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse group ext params", t);
            }
        }
        return this.extParamsMap;
    }

    public String getBackupClusterTag() {
        return this.getExtParamsMap().get(KEY_BACKUP_CLUSTER_TAG);
    }

    public String getBackupTopic() {
        return this.getExtParamsMap().get(KEY_BACKUP_TOPIC);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public String getMqType() {
        return this.mqType;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setExtParamsMap(Map<String, String> extParamsMap) {
        this.extParamsMap = extParamsMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortSourceGroupInfo)) {
            return false;
        }
        SortSourceGroupInfo other = (SortSourceGroupInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        Map<String, String> this$extParamsMap = this.getExtParamsMap();
        Map<String, String> other$extParamsMap = other.getExtParamsMap();
        return !(this$extParamsMap == null ? other$extParamsMap != null : !((Object)this$extParamsMap).equals(other$extParamsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortSourceGroupInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        Map<String, String> $extParamsMap = this.getExtParamsMap();
        result = result * 59 + ($extParamsMap == null ? 43 : ((Object)$extParamsMap).hashCode());
        return result;
    }

    public String toString() {
        return "SortSourceGroupInfo(groupId=" + this.getGroupId() + ", clusterTag=" + this.getClusterTag() + ", topic=" + this.getTopic() + ", extParams=" + this.getExtParams() + ", mqType=" + this.getMqType() + ", extParamsMap=" + this.getExtParamsMap() + ")";
    }
}

