/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.standalone;

import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortSourceStreamInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSourceStreamInfo.class);
    String sortClusterName;
    String sortTaskName;
    String groupId;
    String extParams;
    Map<String, String> extParamsMap;

    public Map<String, String> getExtParamsMap() {
        if (this.extParamsMap != null) {
            return this.extParamsMap;
        }
        if (StringUtils.isNotBlank((CharSequence)this.extParams)) {
            try {
                Gson gson = new Gson();
                this.extParamsMap = (Map)gson.fromJson(this.extParams, Map.class);
            }
            catch (Throwable t) {
                LOGGER.error("fail to parse source stream ext params", t);
                this.extParamsMap = new ConcurrentHashMap<String, String>();
            }
        }
        return this.extParamsMap;
    }

    public String getSortClusterName() {
        return this.sortClusterName;
    }

    public String getSortTaskName() {
        return this.sortTaskName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public void setSortClusterName(String sortClusterName) {
        this.sortClusterName = sortClusterName;
    }

    public void setSortTaskName(String sortTaskName) {
        this.sortTaskName = sortTaskName;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setExtParamsMap(Map<String, String> extParamsMap) {
        this.extParamsMap = extParamsMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortSourceStreamInfo)) {
            return false;
        }
        SortSourceStreamInfo other = (SortSourceStreamInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sortClusterName = this.getSortClusterName();
        String other$sortClusterName = other.getSortClusterName();
        if (this$sortClusterName == null ? other$sortClusterName != null : !this$sortClusterName.equals(other$sortClusterName)) {
            return false;
        }
        String this$sortTaskName = this.getSortTaskName();
        String other$sortTaskName = other.getSortTaskName();
        if (this$sortTaskName == null ? other$sortTaskName != null : !this$sortTaskName.equals(other$sortTaskName)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        Map<String, String> this$extParamsMap = this.getExtParamsMap();
        Map<String, String> other$extParamsMap = other.getExtParamsMap();
        return !(this$extParamsMap == null ? other$extParamsMap != null : !((Object)this$extParamsMap).equals(other$extParamsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortSourceStreamInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sortClusterName = this.getSortClusterName();
        result = result * 59 + ($sortClusterName == null ? 43 : $sortClusterName.hashCode());
        String $sortTaskName = this.getSortTaskName();
        result = result * 59 + ($sortTaskName == null ? 43 : $sortTaskName.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        Map<String, String> $extParamsMap = this.getExtParamsMap();
        result = result * 59 + ($extParamsMap == null ? 43 : ((Object)$extParamsMap).hashCode());
        return result;
    }

    public String toString() {
        return "SortSourceStreamInfo(sortClusterName=" + this.getSortClusterName() + ", sortTaskName=" + this.getSortTaskName() + ", groupId=" + this.getGroupId() + ", extParams=" + this.getExtParams() + ", extParamsMap=" + this.getExtParamsMap() + ")";
    }
}

