/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.pojo.fieldformat.ArrayFormat;
import org.apache.inlong.manager.pojo.fieldformat.DecimalFormat;
import org.apache.inlong.manager.pojo.fieldformat.MapFormat;
import org.apache.inlong.manager.pojo.fieldformat.StructFormat;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sort.util.FieldFormatUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.sort.formats.common.ArrayFormatInfo;
import org.apache.inlong.sort.formats.common.BooleanFormatInfo;
import org.apache.inlong.sort.formats.common.ByteFormatInfo;
import org.apache.inlong.sort.formats.common.ByteTypeInfo;
import org.apache.inlong.sort.formats.common.DateFormatInfo;
import org.apache.inlong.sort.formats.common.DecimalFormatInfo;
import org.apache.inlong.sort.formats.common.DoubleFormatInfo;
import org.apache.inlong.sort.formats.common.FloatFormatInfo;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.IntFormatInfo;
import org.apache.inlong.sort.formats.common.LocalZonedTimestampFormatInfo;
import org.apache.inlong.sort.formats.common.LongFormatInfo;
import org.apache.inlong.sort.formats.common.MapFormatInfo;
import org.apache.inlong.sort.formats.common.RowFormatInfo;
import org.apache.inlong.sort.formats.common.ShortFormatInfo;
import org.apache.inlong.sort.formats.common.StringFormatInfo;
import org.apache.inlong.sort.formats.common.TimeFormatInfo;
import org.apache.inlong.sort.formats.common.TimestampFormatInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.MetaFieldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldInfoUtils.class);

    public static FieldInfo parseSinkFieldInfo(SinkField sinkField, String nodeId) {
        boolean isMetaField = sinkField.getIsMetaField() == 1;
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(sinkField.getFieldName(), sinkField.getFieldType(), isMetaField, sinkField.getMetaFieldName(), sinkField.getFieldFormat());
        fieldInfo.setNodeId(nodeId);
        return fieldInfo;
    }

    public static FieldInfo parseStreamFieldInfo(StreamField streamField, String nodeId) {
        boolean isMetaField = streamField.getIsMetaField() == 1;
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(streamField.getFieldName(), streamField.getFieldType(), isMetaField, streamField.getMetaFieldName(), streamField.getFieldFormat());
        fieldInfo.setNodeId(nodeId);
        return fieldInfo;
    }

    public static FieldInfo parseStreamField(StreamField streamField) {
        boolean isMetaField = streamField.getIsMetaField() == 1;
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(streamField.getFieldName(), streamField.getFieldType(), isMetaField, streamField.getMetaFieldName(), streamField.getFieldFormat());
        fieldInfo.setNodeId(streamField.getOriginNodeName());
        return fieldInfo;
    }

    private static FieldInfo getFieldInfo(String fieldName, String fieldType, boolean isMetaField, String metaFieldName, String format) {
        if (isMetaField) {
            return new MetaFieldInfo(fieldName, MetaField.forName((String)metaFieldName));
        }
        return new FieldInfo(fieldName, FieldInfoUtils.convertFieldFormat(fieldType, format));
    }

    public static FormatInfo convertFieldFormat(String type) {
        return FieldInfoUtils.convertFieldFormat(type, null);
    }

    public static FormatInfo convertFieldFormat(String type, String format) {
        ArrayFormatInfo formatInfo;
        FieldType fieldType = FieldType.forName((String)type);
        switch (fieldType) {
            case BOOLEAN: {
                formatInfo = new BooleanFormatInfo();
                break;
            }
            case INT8: 
            case TINYINT: 
            case BYTE: {
                formatInfo = new ByteFormatInfo();
                break;
            }
            case INT16: 
            case SMALLINT: 
            case SHORT: {
                formatInfo = new ShortFormatInfo();
                break;
            }
            case INT32: 
            case INT: {
                formatInfo = new IntFormatInfo();
                break;
            }
            case INT64: 
            case BIGINT: 
            case LONG: {
                formatInfo = new LongFormatInfo();
                break;
            }
            case FLOAT32: 
            case FLOAT: {
                formatInfo = new FloatFormatInfo();
                break;
            }
            case FLOAT64: 
            case DOUBLE: {
                formatInfo = new DoubleFormatInfo();
                break;
            }
            case DECIMAL: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    DecimalFormat decimalFormat = FieldFormatUtils.parseDecimalFormat(format);
                    formatInfo = new DecimalFormatInfo(decimalFormat.getPrecision(), decimalFormat.getScale());
                    break;
                }
                formatInfo = new DecimalFormatInfo();
                break;
            }
            case DATE: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new DateFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format));
                    break;
                }
                formatInfo = new DateFormatInfo();
                break;
            }
            case DATETIME: 
            case TIME: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimeFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format));
                    break;
                }
                formatInfo = new TimeFormatInfo();
                break;
            }
            case TIMESTAMP: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimestampFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format));
                    break;
                }
                formatInfo = new TimestampFormatInfo();
                break;
            }
            case LOCAL_ZONE_TIMESTAMP: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new LocalZonedTimestampFormatInfo(FieldInfoUtils.convertTimestampOrDataFormat(format), 2);
                    break;
                }
                formatInfo = new LocalZonedTimestampFormatInfo();
                break;
            }
            case BINARY: 
            case FIXED: {
                formatInfo = new ArrayFormatInfo(ByteTypeInfo::new);
                break;
            }
            case ARRAY: {
                formatInfo = FieldInfoUtils.createArrayFormatInfo(format);
                break;
            }
            case MAP: {
                formatInfo = FieldInfoUtils.createMapFormatInfo(format);
                break;
            }
            case STRUCT: {
                formatInfo = FieldInfoUtils.createRowFormatInfo(format);
                break;
            }
            default: {
                formatInfo = new StringFormatInfo();
            }
        }
        return formatInfo;
    }

    private static ArrayFormatInfo createArrayFormatInfo(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Unsupported array type without format");
        }
        ArrayFormat arrayFormat = FieldFormatUtils.parseArrayFormat(format);
        FormatInfo elementFormatInfo = FieldInfoUtils.convertFieldFormat(arrayFormat.getElementType().name(), arrayFormat.getElementFormat());
        return new ArrayFormatInfo(elementFormatInfo);
    }

    private static MapFormatInfo createMapFormatInfo(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Unsupported map type without format");
        }
        MapFormat mapFormat = FieldFormatUtils.parseMapFormat(format);
        FormatInfo keyFormatInfo = FieldInfoUtils.convertFieldFormat(mapFormat.getKeyType().name(), mapFormat.getKeyFormat());
        FormatInfo valueFormatInfo = FieldInfoUtils.convertFieldFormat(mapFormat.getValueType().name(), mapFormat.getValueFormat());
        return new MapFormatInfo(keyFormatInfo, valueFormatInfo);
    }

    private static RowFormatInfo createRowFormatInfo(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            throw new IllegalArgumentException("Unsupported struct type without format");
        }
        StructFormat structFormat = FieldFormatUtils.parseStructFormat(format);
        ArrayList fieldNames = Lists.newArrayList();
        ArrayList formatInfos = Lists.newArrayList();
        for (StructFormat.Element element : structFormat.getElements()) {
            fieldNames.add(element.getFieldName());
            formatInfos.add(FieldInfoUtils.convertFieldFormat(element.getFieldType().name(), element.getFieldFormat()));
        }
        return new RowFormatInfo(fieldNames.toArray(new String[0]), formatInfos.toArray(new FormatInfo[0]));
    }

    private static String convertTimestampOrDataFormat(String format) {
        String sortFormat = format;
        switch (format) {
            case "MICROSECONDS": {
                sortFormat = "MICROS";
                break;
            }
            case "MILLISECONDS": {
                sortFormat = "MILLIS";
                break;
            }
            case "SECONDS": {
                sortFormat = "SECONDS";
                break;
            }
        }
        return sortFormat;
    }
}

