/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Stream source request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="sourceType")
public class SourceRequest {
    @NotNull(groups={UpdateValidation.class})
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @NotBlank(message="inlongGroupId cannot be blank")
    @ApiModelProperty(value="Inlong group id")
    private @NotBlank(message="inlongGroupId cannot be blank") String inlongGroupId;
    @NotBlank(message="inlongStreamId cannot be blank")
    @ApiModelProperty(value="Inlong stream id")
    private @NotBlank(message="inlongStreamId cannot be blank") String inlongStreamId;
    @NotBlank(message="sourceType cannot be blank")
    @ApiModelProperty(value="Source type, including: FILE, KAFKA, etc.")
    private @NotBlank(message="sourceType cannot be blank") String sourceType;
    @NotBlank(message="sourceName cannot be blank")
    @Length(min=1, max=100, message="sourceName length must be between 1 and 100")
    @Pattern(regexp="^[a-z0-9_-]{1,100}$", message="sourceName only supports lowercase letters, numbers, '-', or '_'")
    @ApiModelProperty(value="Source name, unique in one stream")
    private @NotBlank(message="sourceName cannot be blank") @Length(min=1, max=100, message="sourceName length must be between 1 and 100") @Pattern(regexp="^[a-z0-9_-]{1,100}$", message="sourceName only supports lowercase letters, numbers, '-', or '_'") String sourceName;
    @ApiModelProperty(value="Ip of the agent running the task")
    private String agentIp;
    @ApiModelProperty(value="Mac uuid of the agent running the task")
    private String uuid;
    @ApiModelProperty(value="Inlong cluster name")
    private String inlongClusterName;
    @ApiModelProperty(value="Data node name")
    private String dataNodeName;
    @ApiModelProperty(value="Serialization type, support: csv, json, canal, avro, etc")
    private String serializationType;
    @ApiModelProperty(value="Snapshot of the source task")
    private String snapshot;
    @ApiModelProperty(value="Version")
    private Integer version;
    @ApiModelProperty(value="Field list, only support when inlong group in light weight mode")
    private List<StreamField> fieldList;
    @ApiModelProperty(value="Other properties if needed")
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getAgentIp() {
        return this.agentIp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getInlongClusterName() {
        return this.inlongClusterName;
    }

    public String getDataNodeName() {
        return this.dataNodeName;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public Integer getVersion() {
        return this.version;
    }

    public List<StreamField> getFieldList() {
        return this.fieldList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setAgentIp(String agentIp) {
        this.agentIp = agentIp;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setInlongClusterName(String inlongClusterName) {
        this.inlongClusterName = inlongClusterName;
    }

    public void setDataNodeName(String dataNodeName) {
        this.dataNodeName = dataNodeName;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setFieldList(List<StreamField> fieldList) {
        this.fieldList = fieldList;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceRequest)) {
            return false;
        }
        SourceRequest other = (SourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        String this$agentIp = this.getAgentIp();
        String other$agentIp = other.getAgentIp();
        if (this$agentIp == null ? other$agentIp != null : !this$agentIp.equals(other$agentIp)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$inlongClusterName = this.getInlongClusterName();
        String other$inlongClusterName = other.getInlongClusterName();
        if (this$inlongClusterName == null ? other$inlongClusterName != null : !this$inlongClusterName.equals(other$inlongClusterName)) {
            return false;
        }
        String this$dataNodeName = this.getDataNodeName();
        String other$dataNodeName = other.getDataNodeName();
        if (this$dataNodeName == null ? other$dataNodeName != null : !this$dataNodeName.equals(other$dataNodeName)) {
            return false;
        }
        String this$serializationType = this.getSerializationType();
        String other$serializationType = other.getSerializationType();
        if (this$serializationType == null ? other$serializationType != null : !this$serializationType.equals(other$serializationType)) {
            return false;
        }
        String this$snapshot = this.getSnapshot();
        String other$snapshot = other.getSnapshot();
        if (this$snapshot == null ? other$snapshot != null : !this$snapshot.equals(other$snapshot)) {
            return false;
        }
        List<StreamField> this$fieldList = this.getFieldList();
        List<StreamField> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        String $agentIp = this.getAgentIp();
        result = result * 59 + ($agentIp == null ? 43 : $agentIp.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $inlongClusterName = this.getInlongClusterName();
        result = result * 59 + ($inlongClusterName == null ? 43 : $inlongClusterName.hashCode());
        String $dataNodeName = this.getDataNodeName();
        result = result * 59 + ($dataNodeName == null ? 43 : $dataNodeName.hashCode());
        String $serializationType = this.getSerializationType();
        result = result * 59 + ($serializationType == null ? 43 : $serializationType.hashCode());
        String $snapshot = this.getSnapshot();
        result = result * 59 + ($snapshot == null ? 43 : $snapshot.hashCode());
        List<StreamField> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "SourceRequest(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", sourceType=" + this.getSourceType() + ", sourceName=" + this.getSourceName() + ", agentIp=" + this.getAgentIp() + ", uuid=" + this.getUuid() + ", inlongClusterName=" + this.getInlongClusterName() + ", dataNodeName=" + this.getDataNodeName() + ", serializationType=" + this.getSerializationType() + ", snapshot=" + this.getSnapshot() + ", version=" + this.getVersion() + ", fieldList=" + this.getFieldList() + ", properties=" + this.getProperties() + ")";
    }
}

