/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.autopush;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.autopush.AutoPushSourceRequest;

@ApiModel(value="Auto push source info")
@JsonTypeDefine(value="AUTO_PUSH")
public class AutoPushSource
extends StreamSource {
    @ApiModelProperty(value="DataProxy group name, used when the user enables local configuration")
    private String dataProxyGroup;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator, stored as ASCII code")
    private String dataSeparator;
    @ApiModelProperty(value="Data field escape symbol, stored as ASCII code")
    private String dataEscapeChar;

    public AutoPushSource() {
        this.setSourceType("AUTO_PUSH");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, AutoPushSourceRequest::new);
    }

    protected AutoPushSource(AutoPushSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.dataProxyGroup = ((AutoPushSourceBuilder)b).dataProxyGroup;
        this.dataEncoding = ((AutoPushSourceBuilder)b).dataEncoding;
        this.dataSeparator = ((AutoPushSourceBuilder)b).dataSeparator;
        this.dataEscapeChar = ((AutoPushSourceBuilder)b).dataEscapeChar;
    }

    public static AutoPushSourceBuilder<?, ?> builder() {
        return new AutoPushSourceBuilderImpl();
    }

    public String getDataProxyGroup() {
        return this.dataProxyGroup;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public void setDataProxyGroup(String dataProxyGroup) {
        this.dataProxyGroup = dataProxyGroup;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    public AutoPushSource(String dataProxyGroup, String dataEncoding, String dataSeparator, String dataEscapeChar) {
        this.dataProxyGroup = dataProxyGroup;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.dataEscapeChar = dataEscapeChar;
    }

    @Override
    public String toString() {
        return "AutoPushSource(super=" + super.toString() + ", dataProxyGroup=" + this.getDataProxyGroup() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoPushSource)) {
            return false;
        }
        AutoPushSource other = (AutoPushSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dataProxyGroup = this.getDataProxyGroup();
        String other$dataProxyGroup = other.getDataProxyGroup();
        if (this$dataProxyGroup == null ? other$dataProxyGroup != null : !this$dataProxyGroup.equals(other$dataProxyGroup)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        return !(this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AutoPushSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dataProxyGroup = this.getDataProxyGroup();
        result = result * 59 + ($dataProxyGroup == null ? 43 : $dataProxyGroup.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        return result;
    }

    private static final class AutoPushSourceBuilderImpl
    extends AutoPushSourceBuilder<AutoPushSource, AutoPushSourceBuilderImpl> {
        private AutoPushSourceBuilderImpl() {
        }

        @Override
        protected AutoPushSourceBuilderImpl self() {
            return this;
        }

        @Override
        public AutoPushSource build() {
            return new AutoPushSource(this);
        }
    }

    public static abstract class AutoPushSourceBuilder<C extends AutoPushSource, B extends AutoPushSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String dataProxyGroup;
        private String dataEncoding;
        private String dataSeparator;
        private String dataEscapeChar;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B dataProxyGroup(String dataProxyGroup) {
            this.dataProxyGroup = dataProxyGroup;
            return (B)this.self();
        }

        public B dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return (B)this.self();
        }

        public B dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return (B)this.self();
        }

        public B dataEscapeChar(String dataEscapeChar) {
            this.dataEscapeChar = dataEscapeChar;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AutoPushSource.AutoPushSourceBuilder(super=" + super.toString() + ", dataProxyGroup=" + this.dataProxyGroup + ", dataEncoding=" + this.dataEncoding + ", dataSeparator=" + this.dataSeparator + ", dataEscapeChar=" + this.dataEscapeChar + ")";
        }
    }
}

