/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.autopush;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import org.apache.inlong.manager.common.enums.DataSeparator;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;

@ApiModel(value="Auto push source request")
@JsonTypeDefine(value="AUTO_PUSH")
public class AutoPushSourceRequest
extends SourceRequest {
    @ApiModelProperty(value="DataProxy group name, used when the user enables local configuration")
    private String dataProxyGroup;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding = StandardCharsets.UTF_8.toString();
    @ApiModelProperty(value="Data separator, stored as ASCII code")
    private String dataSeparator = DataSeparator.VERTICAL_BAR.getAsciiCode().toString();
    @ApiModelProperty(value="Data field escape symbol, stored as ASCII code")
    private String dataEscapeChar;

    public AutoPushSourceRequest() {
        this.setSourceType("AUTO_PUSH");
    }

    public String getDataProxyGroup() {
        return this.dataProxyGroup;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getDataEscapeChar() {
        return this.dataEscapeChar;
    }

    public void setDataProxyGroup(String dataProxyGroup) {
        this.dataProxyGroup = dataProxyGroup;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setDataEscapeChar(String dataEscapeChar) {
        this.dataEscapeChar = dataEscapeChar;
    }

    @Override
    public String toString() {
        return "AutoPushSourceRequest(super=" + super.toString() + ", dataProxyGroup=" + this.getDataProxyGroup() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", dataEscapeChar=" + this.getDataEscapeChar() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoPushSourceRequest)) {
            return false;
        }
        AutoPushSourceRequest other = (AutoPushSourceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dataProxyGroup = this.getDataProxyGroup();
        String other$dataProxyGroup = other.getDataProxyGroup();
        if (this$dataProxyGroup == null ? other$dataProxyGroup != null : !this$dataProxyGroup.equals(other$dataProxyGroup)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$dataEscapeChar = this.getDataEscapeChar();
        String other$dataEscapeChar = other.getDataEscapeChar();
        return !(this$dataEscapeChar == null ? other$dataEscapeChar != null : !this$dataEscapeChar.equals(other$dataEscapeChar));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AutoPushSourceRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dataProxyGroup = this.getDataProxyGroup();
        result = result * 59 + ($dataProxyGroup == null ? 43 : $dataProxyGroup.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $dataEscapeChar = this.getDataEscapeChar();
        result = result * 59 + ($dataEscapeChar == null ? 43 : $dataEscapeChar.hashCode());
        return result;
    }
}

