/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.file;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.source.file.FileSourceRequest;

public class FileSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt")
    private String pattern;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;
    @ApiModelProperty(value="Properties for File")
    private Map<String, Object> properties;
    @ApiModelProperty(value="Line end regex pattern, for example: &end&")
    private String lineEndPattern;
    @ApiModelProperty(value="Type of file content, for example: FULL, INCREMENT")
    private String contentCollectType;
    @ApiModelProperty(value="File needs to collect environment information, for example: kubernetes")
    private String envList;
    @ApiModelProperty(value="Metadata of data, for example: [{data:field1,field2},{kubernetes:namespace,labels,name,uuid}] and so on")
    private List<Map<String, String>> metaFields;
    @ApiModelProperty(value=" Type of data result for column separator         CSV format, set this parameter to a custom separator: , | :          Json format, set this parameter to json ")
    private String dataContentStyle;
    @ApiModelProperty(value="Column separator of data source ")
    private String dataSeparator;
    @ApiModelProperty(value="Metadata filters by label, special parameters for K8S")
    private Map<String, String> filterMetaByLabels;

    public static FileSourceDTO getFromRequest(@NotNull FileSourceRequest fileSourceRequest) {
        return FileSourceDTO.builder().pattern(fileSourceRequest.getPattern()).lineEndPattern(fileSourceRequest.getLineEndPattern()).contentCollectType(fileSourceRequest.getContentCollectType()).envList(fileSourceRequest.getEnvList()).dataContentStyle(fileSourceRequest.getDataContentStyle()).filterMetaByLabels(fileSourceRequest.getFilterMetaByLabels()).metaFields(fileSourceRequest.getMetaFields()).timeOffset(fileSourceRequest.getTimeOffset()).properties(fileSourceRequest.getProperties()).build();
    }

    public static FileSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (FileSourceDTO)OBJECT_MAPPER.readValue(extParams, FileSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static FileSourceDTOBuilder builder() {
        return new FileSourceDTOBuilder();
    }

    public FileSourceDTO(String pattern, String timeOffset, Map<String, Object> properties, String lineEndPattern, String contentCollectType, String envList, List<Map<String, String>> metaFields, String dataContentStyle, String dataSeparator, Map<String, String> filterMetaByLabels) {
        this.pattern = pattern;
        this.timeOffset = timeOffset;
        this.properties = properties;
        this.lineEndPattern = lineEndPattern;
        this.contentCollectType = contentCollectType;
        this.envList = envList;
        this.metaFields = metaFields;
        this.dataContentStyle = dataContentStyle;
        this.dataSeparator = dataSeparator;
        this.filterMetaByLabels = filterMetaByLabels;
    }

    public FileSourceDTO() {
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getLineEndPattern() {
        return this.lineEndPattern;
    }

    public String getContentCollectType() {
        return this.contentCollectType;
    }

    public String getEnvList() {
        return this.envList;
    }

    public List<Map<String, String>> getMetaFields() {
        return this.metaFields;
    }

    public String getDataContentStyle() {
        return this.dataContentStyle;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public Map<String, String> getFilterMetaByLabels() {
        return this.filterMetaByLabels;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setLineEndPattern(String lineEndPattern) {
        this.lineEndPattern = lineEndPattern;
    }

    public void setContentCollectType(String contentCollectType) {
        this.contentCollectType = contentCollectType;
    }

    public void setEnvList(String envList) {
        this.envList = envList;
    }

    public void setMetaFields(List<Map<String, String>> metaFields) {
        this.metaFields = metaFields;
    }

    public void setDataContentStyle(String dataContentStyle) {
        this.dataContentStyle = dataContentStyle;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setFilterMetaByLabels(Map<String, String> filterMetaByLabels) {
        this.filterMetaByLabels = filterMetaByLabels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSourceDTO)) {
            return false;
        }
        FileSourceDTO other = (FileSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        if (this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$lineEndPattern = this.getLineEndPattern();
        String other$lineEndPattern = other.getLineEndPattern();
        if (this$lineEndPattern == null ? other$lineEndPattern != null : !this$lineEndPattern.equals(other$lineEndPattern)) {
            return false;
        }
        String this$contentCollectType = this.getContentCollectType();
        String other$contentCollectType = other.getContentCollectType();
        if (this$contentCollectType == null ? other$contentCollectType != null : !this$contentCollectType.equals(other$contentCollectType)) {
            return false;
        }
        String this$envList = this.getEnvList();
        String other$envList = other.getEnvList();
        if (this$envList == null ? other$envList != null : !this$envList.equals(other$envList)) {
            return false;
        }
        List<Map<String, String>> this$metaFields = this.getMetaFields();
        List<Map<String, String>> other$metaFields = other.getMetaFields();
        if (this$metaFields == null ? other$metaFields != null : !((Object)this$metaFields).equals(other$metaFields)) {
            return false;
        }
        String this$dataContentStyle = this.getDataContentStyle();
        String other$dataContentStyle = other.getDataContentStyle();
        if (this$dataContentStyle == null ? other$dataContentStyle != null : !this$dataContentStyle.equals(other$dataContentStyle)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        Map<String, String> this$filterMetaByLabels = this.getFilterMetaByLabels();
        Map<String, String> other$filterMetaByLabels = other.getFilterMetaByLabels();
        return !(this$filterMetaByLabels == null ? other$filterMetaByLabels != null : !((Object)this$filterMetaByLabels).equals(other$filterMetaByLabels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $lineEndPattern = this.getLineEndPattern();
        result = result * 59 + ($lineEndPattern == null ? 43 : $lineEndPattern.hashCode());
        String $contentCollectType = this.getContentCollectType();
        result = result * 59 + ($contentCollectType == null ? 43 : $contentCollectType.hashCode());
        String $envList = this.getEnvList();
        result = result * 59 + ($envList == null ? 43 : $envList.hashCode());
        List<Map<String, String>> $metaFields = this.getMetaFields();
        result = result * 59 + ($metaFields == null ? 43 : ((Object)$metaFields).hashCode());
        String $dataContentStyle = this.getDataContentStyle();
        result = result * 59 + ($dataContentStyle == null ? 43 : $dataContentStyle.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        Map<String, String> $filterMetaByLabels = this.getFilterMetaByLabels();
        result = result * 59 + ($filterMetaByLabels == null ? 43 : ((Object)$filterMetaByLabels).hashCode());
        return result;
    }

    public String toString() {
        return "FileSourceDTO(pattern=" + this.getPattern() + ", timeOffset=" + this.getTimeOffset() + ", properties=" + this.getProperties() + ", lineEndPattern=" + this.getLineEndPattern() + ", contentCollectType=" + this.getContentCollectType() + ", envList=" + this.getEnvList() + ", metaFields=" + this.getMetaFields() + ", dataContentStyle=" + this.getDataContentStyle() + ", dataSeparator=" + this.getDataSeparator() + ", filterMetaByLabels=" + this.getFilterMetaByLabels() + ")";
    }

    public static class FileSourceDTOBuilder {
        private String pattern;
        private String timeOffset;
        private Map<String, Object> properties;
        private String lineEndPattern;
        private String contentCollectType;
        private String envList;
        private List<Map<String, String>> metaFields;
        private String dataContentStyle;
        private String dataSeparator;
        private Map<String, String> filterMetaByLabels;

        FileSourceDTOBuilder() {
        }

        public FileSourceDTOBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public FileSourceDTOBuilder timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public FileSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public FileSourceDTOBuilder lineEndPattern(String lineEndPattern) {
            this.lineEndPattern = lineEndPattern;
            return this;
        }

        public FileSourceDTOBuilder contentCollectType(String contentCollectType) {
            this.contentCollectType = contentCollectType;
            return this;
        }

        public FileSourceDTOBuilder envList(String envList) {
            this.envList = envList;
            return this;
        }

        public FileSourceDTOBuilder metaFields(List<Map<String, String>> metaFields) {
            this.metaFields = metaFields;
            return this;
        }

        public FileSourceDTOBuilder dataContentStyle(String dataContentStyle) {
            this.dataContentStyle = dataContentStyle;
            return this;
        }

        public FileSourceDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public FileSourceDTOBuilder filterMetaByLabels(Map<String, String> filterMetaByLabels) {
            this.filterMetaByLabels = filterMetaByLabels;
            return this;
        }

        public FileSourceDTO build() {
            return new FileSourceDTO(this.pattern, this.timeOffset, this.properties, this.lineEndPattern, this.contentCollectType, this.envList, this.metaFields, this.dataContentStyle, this.dataSeparator, this.filterMetaByLabels);
        }

        public String toString() {
            return "FileSourceDTO.FileSourceDTOBuilder(pattern=" + this.pattern + ", timeOffset=" + this.timeOffset + ", properties=" + this.properties + ", lineEndPattern=" + this.lineEndPattern + ", contentCollectType=" + this.contentCollectType + ", envList=" + this.envList + ", metaFields=" + this.metaFields + ", dataContentStyle=" + this.dataContentStyle + ", dataSeparator=" + this.dataSeparator + ", filterMetaByLabels=" + this.filterMetaByLabels + ")";
        }
    }
}

