/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.postgresql;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.source.postgresql.PostgreSQLSourceRequest;

public class PostgreSQLSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Username of the PostgreSQL server")
    private String username;
    @ApiModelProperty(value="Password of the PostgreSQL server")
    private String password;
    @ApiModelProperty(value="Hostname of the PostgreSQL server")
    private String hostname;
    @ApiModelProperty(value="Port of the PostgreSQL server")
    private Integer port;
    @ApiModelProperty(value="Database name")
    private String database;
    @ApiModelProperty(value="Schema name")
    private String schema;
    @ApiModelProperty(value="Decoding plugin name")
    private String decodingPluginName;
    @ApiModelProperty(value="List of table name")
    private List<String> tableNameList;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;
    @ApiModelProperty(value="Properties for PostgreSQL")
    private Map<String, Object> properties;

    public static PostgreSQLSourceDTO getFromRequest(PostgreSQLSourceRequest request) {
        return PostgreSQLSourceDTO.builder().username(request.getUsername()).password(request.getPassword()).hostname(request.getHostname()).port(request.getPort()).schema(request.getSchema()).database(request.getDatabase()).tableNameList(request.getTableNameList()).primaryKey(request.getPrimaryKey()).decodingPluginName(request.getDecodingPluginName()).properties(request.getProperties()).build();
    }

    public static PostgreSQLSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (PostgreSQLSourceDTO)OBJECT_MAPPER.readValue(extParams, PostgreSQLSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static PostgreSQLSourceDTOBuilder builder() {
        return new PostgreSQLSourceDTOBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDecodingPluginName() {
        return this.decodingPluginName;
    }

    public List<String> getTableNameList() {
        return this.tableNameList;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setDecodingPluginName(String decodingPluginName) {
        this.decodingPluginName = decodingPluginName;
    }

    public void setTableNameList(List<String> tableNameList) {
        this.tableNameList = tableNameList;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSQLSourceDTO)) {
            return false;
        }
        PostgreSQLSourceDTO other = (PostgreSQLSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$decodingPluginName = this.getDecodingPluginName();
        String other$decodingPluginName = other.getDecodingPluginName();
        if (this$decodingPluginName == null ? other$decodingPluginName != null : !this$decodingPluginName.equals(other$decodingPluginName)) {
            return false;
        }
        List<String> this$tableNameList = this.getTableNameList();
        List<String> other$tableNameList = other.getTableNameList();
        if (this$tableNameList == null ? other$tableNameList != null : !((Object)this$tableNameList).equals(other$tableNameList)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostgreSQLSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $decodingPluginName = this.getDecodingPluginName();
        result = result * 59 + ($decodingPluginName == null ? 43 : $decodingPluginName.hashCode());
        List<String> $tableNameList = this.getTableNameList();
        result = result * 59 + ($tableNameList == null ? 43 : ((Object)$tableNameList).hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "PostgreSQLSourceDTO(username=" + this.getUsername() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", decodingPluginName=" + this.getDecodingPluginName() + ", tableNameList=" + this.getTableNameList() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public PostgreSQLSourceDTO() {
    }

    public PostgreSQLSourceDTO(String username, String password, String hostname, Integer port, String database, String schema, String decodingPluginName, List<String> tableNameList, String primaryKey, Map<String, Object> properties) {
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.schema = schema;
        this.decodingPluginName = decodingPluginName;
        this.tableNameList = tableNameList;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class PostgreSQLSourceDTOBuilder {
        private String username;
        private String password;
        private String hostname;
        private Integer port;
        private String database;
        private String schema;
        private String decodingPluginName;
        private List<String> tableNameList;
        private String primaryKey;
        private Map<String, Object> properties;

        PostgreSQLSourceDTOBuilder() {
        }

        public PostgreSQLSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public PostgreSQLSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PostgreSQLSourceDTOBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public PostgreSQLSourceDTOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public PostgreSQLSourceDTOBuilder database(String database) {
            this.database = database;
            return this;
        }

        public PostgreSQLSourceDTOBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public PostgreSQLSourceDTOBuilder decodingPluginName(String decodingPluginName) {
            this.decodingPluginName = decodingPluginName;
            return this;
        }

        public PostgreSQLSourceDTOBuilder tableNameList(List<String> tableNameList) {
            this.tableNameList = tableNameList;
            return this;
        }

        public PostgreSQLSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public PostgreSQLSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public PostgreSQLSourceDTO build() {
            return new PostgreSQLSourceDTO(this.username, this.password, this.hostname, this.port, this.database, this.schema, this.decodingPluginName, this.tableNameList, this.primaryKey, this.properties);
        }

        public String toString() {
            return "PostgreSQLSourceDTO.PostgreSQLSourceDTOBuilder(username=" + this.username + ", password=" + this.password + ", hostname=" + this.hostname + ", port=" + this.port + ", database=" + this.database + ", schema=" + this.schema + ", decodingPluginName=" + this.decodingPluginName + ", tableNameList=" + this.tableNameList + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

