/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterRequest;

@ApiModel(value="Pulsar cluster info")
public class PulsarClusterDTO {
    @ApiModelProperty(value="Pulsar admin URL, such as: http://127.0.0.1:8080", notes="Pulsar service URL is the 'url' field of the cluster")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar tenant, default is 'public'")
    private String tenant;

    public static PulsarClusterDTO getFromRequest(PulsarClusterRequest request) {
        return PulsarClusterDTO.builder().adminUrl(request.getAdminUrl()).tenant(request.getTenant()).build();
    }

    public static PulsarClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (PulsarClusterDTO)JsonUtils.parseObject((String)extParams, PulsarClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    private static String $default$tenant() {
        return "public";
    }

    public static PulsarClusterDTOBuilder builder() {
        return new PulsarClusterDTOBuilder();
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarClusterDTO)) {
            return false;
        }
        PulsarClusterDTO other = (PulsarClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    public String toString() {
        return "PulsarClusterDTO(adminUrl=" + this.getAdminUrl() + ", tenant=" + this.getTenant() + ")";
    }

    public PulsarClusterDTO() {
        this.tenant = PulsarClusterDTO.$default$tenant();
    }

    public PulsarClusterDTO(String adminUrl, String tenant) {
        this.adminUrl = adminUrl;
        this.tenant = tenant;
    }

    public static class PulsarClusterDTOBuilder {
        private String adminUrl;
        private boolean tenant$set;
        private String tenant$value;

        PulsarClusterDTOBuilder() {
        }

        public PulsarClusterDTOBuilder adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return this;
        }

        public PulsarClusterDTOBuilder tenant(String tenant) {
            this.tenant$value = tenant;
            this.tenant$set = true;
            return this;
        }

        public PulsarClusterDTO build() {
            String tenant$value = this.tenant$value;
            if (!this.tenant$set) {
                tenant$value = PulsarClusterDTO.$default$tenant();
            }
            return new PulsarClusterDTO(this.adminUrl, tenant$value);
        }

        public String toString() {
            return "PulsarClusterDTO.PulsarClusterDTOBuilder(adminUrl=" + this.adminUrl + ", tenant$value=" + this.tenant$value + ")";
        }
    }
}

