/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.tubemq;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;

@ApiModel(value="TubeMQ cluster info")
public class TubeClusterDTO {
    @NotBlank(message="masterWebUrl cannot be blank")
    @ApiModelProperty(value="Master Web URL http://120.0.0.1:8080", notes="TubeMQ master RPC URL is the 'url' field of the cluster")
    private @NotBlank(message="masterWebUrl cannot be blank") String masterWebUrl;

    public static TubeClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (TubeClusterDTO)JsonUtils.parseObject((String)extParams, TubeClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static TubeClusterDTOBuilder builder() {
        return new TubeClusterDTOBuilder();
    }

    public String getMasterWebUrl() {
        return this.masterWebUrl;
    }

    public void setMasterWebUrl(String masterWebUrl) {
        this.masterWebUrl = masterWebUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeClusterDTO)) {
            return false;
        }
        TubeClusterDTO other = (TubeClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$masterWebUrl = this.getMasterWebUrl();
        String other$masterWebUrl = other.getMasterWebUrl();
        return !(this$masterWebUrl == null ? other$masterWebUrl != null : !this$masterWebUrl.equals(other$masterWebUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TubeClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $masterWebUrl = this.getMasterWebUrl();
        result = result * 59 + ($masterWebUrl == null ? 43 : $masterWebUrl.hashCode());
        return result;
    }

    public String toString() {
        return "TubeClusterDTO(masterWebUrl=" + this.getMasterWebUrl() + ")";
    }

    public TubeClusterDTO() {
    }

    public TubeClusterDTO(String masterWebUrl) {
        this.masterWebUrl = masterWebUrl;
    }

    public static class TubeClusterDTOBuilder {
        private String masterWebUrl;

        TubeClusterDTOBuilder() {
        }

        public TubeClusterDTOBuilder masterWebUrl(String masterWebUrl) {
            this.masterWebUrl = masterWebUrl;
            return this;
        }

        public TubeClusterDTO build() {
            return new TubeClusterDTO(this.masterWebUrl);
        }

        public String toString() {
            return "TubeClusterDTO.TubeClusterDTOBuilder(masterWebUrl=" + this.masterWebUrl + ")";
        }
    }
}

