/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.consume;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import org.apache.inlong.manager.pojo.consume.BaseInlongConsume;
import org.apache.inlong.manager.pojo.consume.InlongConsumeRequest;

@ApiModel(value="Base inlong consume info")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="mqType")
public abstract class InlongConsumeInfo
extends BaseInlongConsume {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Consumer group, only support [a-zA-Z0-9_]")
    private String consumerGroup;
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    private String mqType;
    @ApiModelProperty(value="The target topic of this consume")
    private String topic;
    @ApiModelProperty(value="The target inlong group id of this consume")
    private String inlongGroupId;
    @ApiModelProperty(value="Whether to filter consumption, 0-not filter, 1-filter")
    private Integer filterEnabled = 0;
    @ApiModelProperty(value="The target inlong stream id of this consume, needed if the filterEnabled=1")
    private String inlongStreamId;
    @ApiModelProperty(value="Cluster URL of message queue")
    private String clusterUrl;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private String inCharges;
    @ApiModelProperty(value="Consume status")
    private Integer status;
    @ApiModelProperty(value="Previous status")
    private Integer previousStatus;
    @ApiModelProperty(value="Name of creator")
    private String creator;
    @ApiModelProperty(value="Name of modifier")
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public abstract InlongConsumeRequest genRequest();

    public Integer getId() {
        return this.id;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public Integer getFilterEnabled() {
        return this.filterEnabled;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getPreviousStatus() {
        return this.previousStatus;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setFilterEnabled(Integer filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setClusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "InlongConsumeInfo(id=" + this.getId() + ", consumerGroup=" + this.getConsumerGroup() + ", mqType=" + this.getMqType() + ", topic=" + this.getTopic() + ", inlongGroupId=" + this.getInlongGroupId() + ", filterEnabled=" + this.getFilterEnabled() + ", inlongStreamId=" + this.getInlongStreamId() + ", clusterUrl=" + this.getClusterUrl() + ", inCharges=" + this.getInCharges() + ", status=" + this.getStatus() + ", previousStatus=" + this.getPreviousStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongConsumeInfo)) {
            return false;
        }
        InlongConsumeInfo other = (InlongConsumeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$filterEnabled = this.getFilterEnabled();
        Integer other$filterEnabled = other.getFilterEnabled();
        if (this$filterEnabled == null ? other$filterEnabled != null : !((Object)this$filterEnabled).equals(other$filterEnabled)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$previousStatus = this.getPreviousStatus();
        Integer other$previousStatus = other.getPreviousStatus();
        if (this$previousStatus == null ? other$previousStatus != null : !((Object)this$previousStatus).equals(other$previousStatus)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$consumerGroup = this.getConsumerGroup();
        String other$consumerGroup = other.getConsumerGroup();
        if (this$consumerGroup == null ? other$consumerGroup != null : !this$consumerGroup.equals(other$consumerGroup)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$clusterUrl = this.getClusterUrl();
        String other$clusterUrl = other.getClusterUrl();
        if (this$clusterUrl == null ? other$clusterUrl != null : !this$clusterUrl.equals(other$clusterUrl)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongConsumeInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $filterEnabled = this.getFilterEnabled();
        result = result * 59 + ($filterEnabled == null ? 43 : ((Object)$filterEnabled).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $previousStatus = this.getPreviousStatus();
        result = result * 59 + ($previousStatus == null ? 43 : ((Object)$previousStatus).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $consumerGroup = this.getConsumerGroup();
        result = result * 59 + ($consumerGroup == null ? 43 : $consumerGroup.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $clusterUrl = this.getClusterUrl();
        result = result * 59 + ($clusterUrl == null ? 43 : $clusterUrl.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        return result;
    }

    public InlongConsumeInfo() {
    }

    public InlongConsumeInfo(Integer id, String consumerGroup, String mqType, String topic, String inlongGroupId, Integer filterEnabled, String inlongStreamId, String clusterUrl, String inCharges, Integer status, Integer previousStatus, String creator, String modifier, Date createTime, Date modifyTime, Integer version) {
        this.id = id;
        this.consumerGroup = consumerGroup;
        this.mqType = mqType;
        this.topic = topic;
        this.inlongGroupId = inlongGroupId;
        this.filterEnabled = filterEnabled;
        this.inlongStreamId = inlongStreamId;
        this.clusterUrl = clusterUrl;
        this.inCharges = inCharges;
        this.status = status;
        this.previousStatus = previousStatus;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.version = version;
    }
}

