/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.consume;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.pojo.common.PageRequest;

@ApiModel(value="Inlong consume query request")
public class InlongConsumePageRequest
extends PageRequest {
    @ApiModelProperty(value="Keyword, can be consumer group")
    private String keyword;
    @ApiModelProperty(value="Consumer group name")
    private String consumerGroup;
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    private String mqType;
    @ApiModelProperty(value="The target topic of inlong consume")
    private String topic;
    @ApiModelProperty(value="The target inlongGroupId of inlong consume")
    private String inlongGroupId;
    @ApiModelProperty(value="Consume status")
    private Integer status;
    @ApiModelProperty(value="Consume status list")
    private List<Integer> statusList;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;
    @ApiModelProperty(value="Whether the current user is in the administrator role", hidden=true)
    private Boolean isAdminRole;

    public static InlongConsumePageRequestBuilder builder() {
        return new InlongConsumePageRequestBuilder();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<Integer> getStatusList() {
        return this.statusList;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setStatusList(List<Integer> statusList) {
        this.statusList = statusList;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public String toString() {
        return "InlongConsumePageRequest(keyword=" + this.getKeyword() + ", consumerGroup=" + this.getConsumerGroup() + ", mqType=" + this.getMqType() + ", topic=" + this.getTopic() + ", inlongGroupId=" + this.getInlongGroupId() + ", status=" + this.getStatus() + ", statusList=" + this.getStatusList() + ", currentUser=" + this.getCurrentUser() + ", isAdminRole=" + this.getIsAdminRole() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongConsumePageRequest)) {
            return false;
        }
        InlongConsumePageRequest other = (InlongConsumePageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$consumerGroup = this.getConsumerGroup();
        String other$consumerGroup = other.getConsumerGroup();
        if (this$consumerGroup == null ? other$consumerGroup != null : !this$consumerGroup.equals(other$consumerGroup)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        List<Integer> this$statusList = this.getStatusList();
        List<Integer> other$statusList = other.getStatusList();
        if (this$statusList == null ? other$statusList != null : !((Object)this$statusList).equals(other$statusList)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        return !(this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongConsumePageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $consumerGroup = this.getConsumerGroup();
        result = result * 59 + ($consumerGroup == null ? 43 : $consumerGroup.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        List<Integer> $statusList = this.getStatusList();
        result = result * 59 + ($statusList == null ? 43 : ((Object)$statusList).hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        return result;
    }

    public InlongConsumePageRequest() {
    }

    public InlongConsumePageRequest(String keyword, String consumerGroup, String mqType, String topic, String inlongGroupId, Integer status, List<Integer> statusList, String currentUser, Boolean isAdminRole) {
        this.keyword = keyword;
        this.consumerGroup = consumerGroup;
        this.mqType = mqType;
        this.topic = topic;
        this.inlongGroupId = inlongGroupId;
        this.status = status;
        this.statusList = statusList;
        this.currentUser = currentUser;
        this.isAdminRole = isAdminRole;
    }

    public static class InlongConsumePageRequestBuilder {
        private String keyword;
        private String consumerGroup;
        private String mqType;
        private String topic;
        private String inlongGroupId;
        private Integer status;
        private List<Integer> statusList;
        private String currentUser;
        private Boolean isAdminRole;

        InlongConsumePageRequestBuilder() {
        }

        public InlongConsumePageRequestBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public InlongConsumePageRequestBuilder consumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
            return this;
        }

        public InlongConsumePageRequestBuilder mqType(String mqType) {
            this.mqType = mqType;
            return this;
        }

        public InlongConsumePageRequestBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public InlongConsumePageRequestBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public InlongConsumePageRequestBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public InlongConsumePageRequestBuilder statusList(List<Integer> statusList) {
            this.statusList = statusList;
            return this;
        }

        public InlongConsumePageRequestBuilder currentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public InlongConsumePageRequestBuilder isAdminRole(Boolean isAdminRole) {
            this.isAdminRole = isAdminRole;
            return this;
        }

        public InlongConsumePageRequest build() {
            return new InlongConsumePageRequest(this.keyword, this.consumerGroup, this.mqType, this.topic, this.inlongGroupId, this.status, this.statusList, this.currentUser, this.isAdminRole);
        }

        public String toString() {
            return "InlongConsumePageRequest.InlongConsumePageRequestBuilder(keyword=" + this.keyword + ", consumerGroup=" + this.consumerGroup + ", mqType=" + this.mqType + ", topic=" + this.topic + ", inlongGroupId=" + this.inlongGroupId + ", status=" + this.status + ", statusList=" + this.statusList + ", currentUser=" + this.currentUser + ", isAdminRole=" + this.isAdminRole + ")";
        }
    }
}

