/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.pojo.group.BaseInlongGroup;
import org.apache.inlong.manager.pojo.group.InlongGroupExtInfo;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Inlong group create request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="mqType")
public abstract class InlongGroupRequest
extends BaseInlongGroup {
    @NotBlank(message="inlongGroupId cannot be blank")
    @ApiModelProperty(value="Inlong group id", required=true)
    @Length(min=4, max=100, message="inlongGroupId length must be between 4 and 100")
    @Pattern(regexp="^[a-z0-9_-]{4,100}$", message="inlongGroupId only supports lowercase letters, numbers, '-', or '_'")
    private @NotBlank(message="inlongGroupId cannot be blank") @Length(min=4, max=100, message="inlongGroupId length must be between 4 and 100") @Pattern(regexp="^[a-z0-9_-]{4,100}$", message="inlongGroupId only supports lowercase letters, numbers, '-', or '_'") String inlongGroupId;
    @ApiModelProperty(value="Inlong group name", required=true)
    private String name;
    @ApiModelProperty(value="Inlong group description")
    private String description;
    @Deprecated
    @ApiModelProperty(value="MQ type, replaced by mqType")
    private String middlewareType;
    @NotBlank(message="mqType cannot be blank")
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    private @NotBlank(message="mqType cannot be blank") String mqType;
    @ApiModelProperty(value="MQ resource", notes="in inlong group, TubeMQ corresponds to Topic, Pulsar corresponds to Namespace")
    private String mqResource;
    @ApiModelProperty(value="TubeMQ master URL")
    private String tubeMaster;
    @ApiModelProperty(value="Whether to enable zookeeper? 0: disable, 1: enable")
    private Integer enableZookeeper = 0;
    @ApiModelProperty(value="Whether to enable create resource? 0: disable, 1: enable")
    private Integer enableCreateResource = 1;
    @ApiModelProperty(value="Whether to use lightweight mode, 0: no, 1: yes")
    private Integer lightweight = 0;
    @ApiModelProperty(value="Inlong cluster tag, which links to inlong_cluster table")
    private String inlongClusterTag;
    @ApiModelProperty(value="Number of access items per day, unit: 10,000 items per day")
    private Integer dailyRecords;
    @ApiModelProperty(value="Access size per day, unit: GB per day")
    private Integer dailyStorage;
    @ApiModelProperty(value="peak access per second, unit: bars per second")
    private Integer peakRecords;
    @ApiModelProperty(value="The maximum length of a single piece of data, unit: Byte")
    private Integer maxLength;
    @NotBlank(message="inCharges cannot be blank")
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private @NotBlank(message="inCharges cannot be blank") String inCharges;
    @ApiModelProperty(value="Name of followers, separated by commas")
    private String followers;
    @ApiModelProperty(value="Inlong group Extension properties")
    private List<InlongGroupExtInfo> extList;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String getMiddlewareType() {
        return this.middlewareType;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getMqResource() {
        return this.mqResource;
    }

    public String getTubeMaster() {
        return this.tubeMaster;
    }

    public Integer getEnableZookeeper() {
        return this.enableZookeeper;
    }

    public Integer getEnableCreateResource() {
        return this.enableCreateResource;
    }

    public Integer getLightweight() {
        return this.lightweight;
    }

    public String getInlongClusterTag() {
        return this.inlongClusterTag;
    }

    public Integer getDailyRecords() {
        return this.dailyRecords;
    }

    public Integer getDailyStorage() {
        return this.dailyStorage;
    }

    public Integer getPeakRecords() {
        return this.peakRecords;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getFollowers() {
        return this.followers;
    }

    public List<InlongGroupExtInfo> getExtList() {
        return this.extList;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public void setMiddlewareType(String middlewareType) {
        this.middlewareType = middlewareType;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setMqResource(String mqResource) {
        this.mqResource = mqResource;
    }

    public void setTubeMaster(String tubeMaster) {
        this.tubeMaster = tubeMaster;
    }

    public void setEnableZookeeper(Integer enableZookeeper) {
        this.enableZookeeper = enableZookeeper;
    }

    public void setEnableCreateResource(Integer enableCreateResource) {
        this.enableCreateResource = enableCreateResource;
    }

    public void setLightweight(Integer lightweight) {
        this.lightweight = lightweight;
    }

    public void setInlongClusterTag(String inlongClusterTag) {
        this.inlongClusterTag = inlongClusterTag;
    }

    public void setDailyRecords(Integer dailyRecords) {
        this.dailyRecords = dailyRecords;
    }

    public void setDailyStorage(Integer dailyStorage) {
        this.dailyStorage = dailyStorage;
    }

    public void setPeakRecords(Integer peakRecords) {
        this.peakRecords = peakRecords;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setFollowers(String followers) {
        this.followers = followers;
    }

    public void setExtList(List<InlongGroupExtInfo> extList) {
        this.extList = extList;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "InlongGroupRequest(inlongGroupId=" + this.getInlongGroupId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", middlewareType=" + this.getMiddlewareType() + ", mqType=" + this.getMqType() + ", mqResource=" + this.getMqResource() + ", tubeMaster=" + this.getTubeMaster() + ", enableZookeeper=" + this.getEnableZookeeper() + ", enableCreateResource=" + this.getEnableCreateResource() + ", lightweight=" + this.getLightweight() + ", inlongClusterTag=" + this.getInlongClusterTag() + ", dailyRecords=" + this.getDailyRecords() + ", dailyStorage=" + this.getDailyStorage() + ", peakRecords=" + this.getPeakRecords() + ", maxLength=" + this.getMaxLength() + ", inCharges=" + this.getInCharges() + ", followers=" + this.getFollowers() + ", extList=" + this.getExtList() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupRequest)) {
            return false;
        }
        InlongGroupRequest other = (InlongGroupRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$enableZookeeper = this.getEnableZookeeper();
        Integer other$enableZookeeper = other.getEnableZookeeper();
        if (this$enableZookeeper == null ? other$enableZookeeper != null : !((Object)this$enableZookeeper).equals(other$enableZookeeper)) {
            return false;
        }
        Integer this$enableCreateResource = this.getEnableCreateResource();
        Integer other$enableCreateResource = other.getEnableCreateResource();
        if (this$enableCreateResource == null ? other$enableCreateResource != null : !((Object)this$enableCreateResource).equals(other$enableCreateResource)) {
            return false;
        }
        Integer this$lightweight = this.getLightweight();
        Integer other$lightweight = other.getLightweight();
        if (this$lightweight == null ? other$lightweight != null : !((Object)this$lightweight).equals(other$lightweight)) {
            return false;
        }
        Integer this$dailyRecords = this.getDailyRecords();
        Integer other$dailyRecords = other.getDailyRecords();
        if (this$dailyRecords == null ? other$dailyRecords != null : !((Object)this$dailyRecords).equals(other$dailyRecords)) {
            return false;
        }
        Integer this$dailyStorage = this.getDailyStorage();
        Integer other$dailyStorage = other.getDailyStorage();
        if (this$dailyStorage == null ? other$dailyStorage != null : !((Object)this$dailyStorage).equals(other$dailyStorage)) {
            return false;
        }
        Integer this$peakRecords = this.getPeakRecords();
        Integer other$peakRecords = other.getPeakRecords();
        if (this$peakRecords == null ? other$peakRecords != null : !((Object)this$peakRecords).equals(other$peakRecords)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$middlewareType = this.getMiddlewareType();
        String other$middlewareType = other.getMiddlewareType();
        if (this$middlewareType == null ? other$middlewareType != null : !this$middlewareType.equals(other$middlewareType)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$mqResource = this.getMqResource();
        String other$mqResource = other.getMqResource();
        if (this$mqResource == null ? other$mqResource != null : !this$mqResource.equals(other$mqResource)) {
            return false;
        }
        String this$tubeMaster = this.getTubeMaster();
        String other$tubeMaster = other.getTubeMaster();
        if (this$tubeMaster == null ? other$tubeMaster != null : !this$tubeMaster.equals(other$tubeMaster)) {
            return false;
        }
        String this$inlongClusterTag = this.getInlongClusterTag();
        String other$inlongClusterTag = other.getInlongClusterTag();
        if (this$inlongClusterTag == null ? other$inlongClusterTag != null : !this$inlongClusterTag.equals(other$inlongClusterTag)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$followers = this.getFollowers();
        String other$followers = other.getFollowers();
        if (this$followers == null ? other$followers != null : !this$followers.equals(other$followers)) {
            return false;
        }
        List<InlongGroupExtInfo> this$extList = this.getExtList();
        List<InlongGroupExtInfo> other$extList = other.getExtList();
        return !(this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $enableZookeeper = this.getEnableZookeeper();
        result = result * 59 + ($enableZookeeper == null ? 43 : ((Object)$enableZookeeper).hashCode());
        Integer $enableCreateResource = this.getEnableCreateResource();
        result = result * 59 + ($enableCreateResource == null ? 43 : ((Object)$enableCreateResource).hashCode());
        Integer $lightweight = this.getLightweight();
        result = result * 59 + ($lightweight == null ? 43 : ((Object)$lightweight).hashCode());
        Integer $dailyRecords = this.getDailyRecords();
        result = result * 59 + ($dailyRecords == null ? 43 : ((Object)$dailyRecords).hashCode());
        Integer $dailyStorage = this.getDailyStorage();
        result = result * 59 + ($dailyStorage == null ? 43 : ((Object)$dailyStorage).hashCode());
        Integer $peakRecords = this.getPeakRecords();
        result = result * 59 + ($peakRecords == null ? 43 : ((Object)$peakRecords).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $middlewareType = this.getMiddlewareType();
        result = result * 59 + ($middlewareType == null ? 43 : $middlewareType.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $mqResource = this.getMqResource();
        result = result * 59 + ($mqResource == null ? 43 : $mqResource.hashCode());
        String $tubeMaster = this.getTubeMaster();
        result = result * 59 + ($tubeMaster == null ? 43 : $tubeMaster.hashCode());
        String $inlongClusterTag = this.getInlongClusterTag();
        result = result * 59 + ($inlongClusterTag == null ? 43 : $inlongClusterTag.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $followers = this.getFollowers();
        result = result * 59 + ($followers == null ? 43 : $followers.hashCode());
        List<InlongGroupExtInfo> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        return result;
    }

    public InlongGroupRequest() {
    }

    public InlongGroupRequest(String inlongGroupId, String name, String description, String middlewareType, String mqType, String mqResource, String tubeMaster, Integer enableZookeeper, Integer enableCreateResource, Integer lightweight, String inlongClusterTag, Integer dailyRecords, Integer dailyStorage, Integer peakRecords, Integer maxLength, String inCharges, String followers, List<InlongGroupExtInfo> extList, Integer version) {
        this.inlongGroupId = inlongGroupId;
        this.name = name;
        this.description = description;
        this.middlewareType = middlewareType;
        this.mqType = mqType;
        this.mqResource = mqResource;
        this.tubeMaster = tubeMaster;
        this.enableZookeeper = enableZookeeper;
        this.enableCreateResource = enableCreateResource;
        this.lightweight = lightweight;
        this.inlongClusterTag = inlongClusterTag;
        this.dailyRecords = dailyRecords;
        this.dailyStorage = dailyStorage;
        this.peakRecords = peakRecords;
        this.maxLength = maxLength;
        this.inCharges = inCharges;
        this.followers = followers;
        this.extList = extList;
        this.version = version;
    }
}

