/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group.kafka;

import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.group.BaseInlongGroup;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaRequest;

@ApiModel(value="Inlong group info for Kafka")
public class InlongKafkaDTO
extends BaseInlongGroup {
    private Integer numPartitions;
    private Short replicationFactor = 1;

    public static InlongKafkaDTO getFromRequest(InlongKafkaRequest request) {
        return (InlongKafkaDTO)CommonBeanUtils.copyProperties((Object)request, InlongKafkaDTO::new, (boolean)true);
    }

    public static InlongKafkaDTO getFromJson(@NotNull String extParams) {
        try {
            return (InlongKafkaDTO)JsonUtils.parseObject((String)extParams, InlongKafkaDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static InlongKafkaDTOBuilder builder() {
        return new InlongKafkaDTOBuilder();
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public Short getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    public void setReplicationFactor(Short replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongKafkaDTO)) {
            return false;
        }
        InlongKafkaDTO other = (InlongKafkaDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$numPartitions = this.getNumPartitions();
        Integer other$numPartitions = other.getNumPartitions();
        if (this$numPartitions == null ? other$numPartitions != null : !((Object)this$numPartitions).equals(other$numPartitions)) {
            return false;
        }
        Short this$replicationFactor = this.getReplicationFactor();
        Short other$replicationFactor = other.getReplicationFactor();
        return !(this$replicationFactor == null ? other$replicationFactor != null : !((Object)this$replicationFactor).equals(other$replicationFactor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongKafkaDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $numPartitions = this.getNumPartitions();
        result = result * 59 + ($numPartitions == null ? 43 : ((Object)$numPartitions).hashCode());
        Short $replicationFactor = this.getReplicationFactor();
        result = result * 59 + ($replicationFactor == null ? 43 : ((Object)$replicationFactor).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "InlongKafkaDTO(numPartitions=" + this.getNumPartitions() + ", replicationFactor=" + this.getReplicationFactor() + ")";
    }

    public InlongKafkaDTO() {
    }

    public InlongKafkaDTO(Integer numPartitions, Short replicationFactor) {
        this.numPartitions = numPartitions;
        this.replicationFactor = replicationFactor;
    }

    public static class InlongKafkaDTOBuilder {
        private Integer numPartitions;
        private Short replicationFactor;

        InlongKafkaDTOBuilder() {
        }

        public InlongKafkaDTOBuilder numPartitions(Integer numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        public InlongKafkaDTOBuilder replicationFactor(Short replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public InlongKafkaDTO build() {
            return new InlongKafkaDTO(this.numPartitions, this.replicationFactor);
        }

        public String toString() {
            return "InlongKafkaDTO.InlongKafkaDTOBuilder(numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ")";
        }
    }
}

