/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;

@ApiModel(value="Inlong group request for Pulsar")
@JsonTypeDefine(value="PULSAR")
public class InlongPulsarRequest
extends InlongGroupRequest {
    @ApiModelProperty(value="Queue model, parallel: multiple partitions, high throughput, out-of-order messages;serial: single partition, low throughput, and orderly messages")
    private String queueModule = "PARALLEL";
    @ApiModelProperty(value="Number of partitions of Topic, 1-20")
    private Integer partitionNum = 3;
    @ApiModelProperty(value="Ledger's number of writable nodes")
    private Integer ensemble = 3;
    @ApiModelProperty(value="Ledger's number of copies")
    private Integer writeQuorum = 3;
    @ApiModelProperty(value="Number of responses requested")
    private Integer ackQuorum = 2;
    @ApiModelProperty(value="Message time-to-live duration")
    private Integer ttl = 24;
    @ApiModelProperty(value="The unit of message's time-to-live duration")
    private String ttlUnit = "hours";
    @ApiModelProperty(value="Message storage time")
    private Integer retentionTime = 72;
    @ApiModelProperty(value="The unit of the message storage time")
    private String retentionTimeUnit = "hours";
    @ApiModelProperty(value="Message size")
    private Integer retentionSize = -1;
    @ApiModelProperty(value="The unit of message size")
    private String retentionSizeUnit = "MB";

    public InlongPulsarRequest() {
        this.setMqType("PULSAR");
    }

    public String getQueueModule() {
        return this.queueModule;
    }

    public Integer getPartitionNum() {
        return this.partitionNum;
    }

    public Integer getEnsemble() {
        return this.ensemble;
    }

    public Integer getWriteQuorum() {
        return this.writeQuorum;
    }

    public Integer getAckQuorum() {
        return this.ackQuorum;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public String getTtlUnit() {
        return this.ttlUnit;
    }

    public Integer getRetentionTime() {
        return this.retentionTime;
    }

    public String getRetentionTimeUnit() {
        return this.retentionTimeUnit;
    }

    public Integer getRetentionSize() {
        return this.retentionSize;
    }

    public String getRetentionSizeUnit() {
        return this.retentionSizeUnit;
    }

    public void setQueueModule(String queueModule) {
        this.queueModule = queueModule;
    }

    public void setPartitionNum(Integer partitionNum) {
        this.partitionNum = partitionNum;
    }

    public void setEnsemble(Integer ensemble) {
        this.ensemble = ensemble;
    }

    public void setWriteQuorum(Integer writeQuorum) {
        this.writeQuorum = writeQuorum;
    }

    public void setAckQuorum(Integer ackQuorum) {
        this.ackQuorum = ackQuorum;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setTtlUnit(String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public void setRetentionTime(Integer retentionTime) {
        this.retentionTime = retentionTime;
    }

    public void setRetentionTimeUnit(String retentionTimeUnit) {
        this.retentionTimeUnit = retentionTimeUnit;
    }

    public void setRetentionSize(Integer retentionSize) {
        this.retentionSize = retentionSize;
    }

    public void setRetentionSizeUnit(String retentionSizeUnit) {
        this.retentionSizeUnit = retentionSizeUnit;
    }

    @Override
    public String toString() {
        return "InlongPulsarRequest(super=" + super.toString() + ", queueModule=" + this.getQueueModule() + ", partitionNum=" + this.getPartitionNum() + ", ensemble=" + this.getEnsemble() + ", writeQuorum=" + this.getWriteQuorum() + ", ackQuorum=" + this.getAckQuorum() + ", ttl=" + this.getTtl() + ", ttlUnit=" + this.getTtlUnit() + ", retentionTime=" + this.getRetentionTime() + ", retentionTimeUnit=" + this.getRetentionTimeUnit() + ", retentionSize=" + this.getRetentionSize() + ", retentionSizeUnit=" + this.getRetentionSizeUnit() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongPulsarRequest)) {
            return false;
        }
        InlongPulsarRequest other = (InlongPulsarRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitionNum = this.getPartitionNum();
        Integer other$partitionNum = other.getPartitionNum();
        if (this$partitionNum == null ? other$partitionNum != null : !((Object)this$partitionNum).equals(other$partitionNum)) {
            return false;
        }
        Integer this$ensemble = this.getEnsemble();
        Integer other$ensemble = other.getEnsemble();
        if (this$ensemble == null ? other$ensemble != null : !((Object)this$ensemble).equals(other$ensemble)) {
            return false;
        }
        Integer this$writeQuorum = this.getWriteQuorum();
        Integer other$writeQuorum = other.getWriteQuorum();
        if (this$writeQuorum == null ? other$writeQuorum != null : !((Object)this$writeQuorum).equals(other$writeQuorum)) {
            return false;
        }
        Integer this$ackQuorum = this.getAckQuorum();
        Integer other$ackQuorum = other.getAckQuorum();
        if (this$ackQuorum == null ? other$ackQuorum != null : !((Object)this$ackQuorum).equals(other$ackQuorum)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Integer this$retentionTime = this.getRetentionTime();
        Integer other$retentionTime = other.getRetentionTime();
        if (this$retentionTime == null ? other$retentionTime != null : !((Object)this$retentionTime).equals(other$retentionTime)) {
            return false;
        }
        Integer this$retentionSize = this.getRetentionSize();
        Integer other$retentionSize = other.getRetentionSize();
        if (this$retentionSize == null ? other$retentionSize != null : !((Object)this$retentionSize).equals(other$retentionSize)) {
            return false;
        }
        String this$queueModule = this.getQueueModule();
        String other$queueModule = other.getQueueModule();
        if (this$queueModule == null ? other$queueModule != null : !this$queueModule.equals(other$queueModule)) {
            return false;
        }
        String this$ttlUnit = this.getTtlUnit();
        String other$ttlUnit = other.getTtlUnit();
        if (this$ttlUnit == null ? other$ttlUnit != null : !this$ttlUnit.equals(other$ttlUnit)) {
            return false;
        }
        String this$retentionTimeUnit = this.getRetentionTimeUnit();
        String other$retentionTimeUnit = other.getRetentionTimeUnit();
        if (this$retentionTimeUnit == null ? other$retentionTimeUnit != null : !this$retentionTimeUnit.equals(other$retentionTimeUnit)) {
            return false;
        }
        String this$retentionSizeUnit = this.getRetentionSizeUnit();
        String other$retentionSizeUnit = other.getRetentionSizeUnit();
        return !(this$retentionSizeUnit == null ? other$retentionSizeUnit != null : !this$retentionSizeUnit.equals(other$retentionSizeUnit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongPulsarRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitionNum = this.getPartitionNum();
        result = result * 59 + ($partitionNum == null ? 43 : ((Object)$partitionNum).hashCode());
        Integer $ensemble = this.getEnsemble();
        result = result * 59 + ($ensemble == null ? 43 : ((Object)$ensemble).hashCode());
        Integer $writeQuorum = this.getWriteQuorum();
        result = result * 59 + ($writeQuorum == null ? 43 : ((Object)$writeQuorum).hashCode());
        Integer $ackQuorum = this.getAckQuorum();
        result = result * 59 + ($ackQuorum == null ? 43 : ((Object)$ackQuorum).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Integer $retentionTime = this.getRetentionTime();
        result = result * 59 + ($retentionTime == null ? 43 : ((Object)$retentionTime).hashCode());
        Integer $retentionSize = this.getRetentionSize();
        result = result * 59 + ($retentionSize == null ? 43 : ((Object)$retentionSize).hashCode());
        String $queueModule = this.getQueueModule();
        result = result * 59 + ($queueModule == null ? 43 : $queueModule.hashCode());
        String $ttlUnit = this.getTtlUnit();
        result = result * 59 + ($ttlUnit == null ? 43 : $ttlUnit.hashCode());
        String $retentionTimeUnit = this.getRetentionTimeUnit();
        result = result * 59 + ($retentionTimeUnit == null ? 43 : $retentionTimeUnit.hashCode());
        String $retentionSizeUnit = this.getRetentionSizeUnit();
        result = result * 59 + ($retentionSizeUnit == null ? 43 : $retentionSizeUnit.hashCode());
        return result;
    }
}

