/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.validation.UpdateValidation;

@ApiModel(value="Data node request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="type")
public abstract class DataNodeRequest {
    @NotNull(groups={UpdateValidation.class})
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @NotBlank(message="node name cannot be blank")
    @ApiModelProperty(value="Data node name")
    private @NotBlank(message="node name cannot be blank") String name;
    @NotBlank(message="node type cannot be blank")
    @ApiModelProperty(value="Data node type, including MYSQL, HIVE, KAFKA, ES, etc.")
    private @NotBlank(message="node type cannot be blank") String type;
    @ApiModelProperty(value="Data node URL")
    private String url;
    @ApiModelProperty(value="Data node username")
    private String username;
    @ApiModelProperty(value="Data node token if needed")
    private String token;
    @ApiModelProperty(value="Extended params")
    private String extParams;
    @ApiModelProperty(value="Description of the data node")
    private String description;
    @NotBlank(message="inCharges cannot be blank")
    @ApiModelProperty(value="Name of responsible person, separated by commas", required=true)
    private @NotBlank(message="inCharges cannot be blank") String inCharges;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataNodeRequest)) {
            return false;
        }
        DataNodeRequest other = (DataNodeRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        return !(this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataNodeRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        return result;
    }

    public String toString() {
        return "DataNodeRequest(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", token=" + this.getToken() + ", extParams=" + this.getExtParams() + ", description=" + this.getDescription() + ", inCharges=" + this.getInCharges() + ", version=" + this.getVersion() + ")";
    }

    public DataNodeRequest() {
    }

    public DataNodeRequest(Integer id, String name, String type, String url, String username, String token, String extParams, String description, String inCharges, Integer version) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.url = url;
        this.username = username;
        this.token = token;
        this.extParams = extParams;
        this.description = description;
        this.inCharges = inCharges;
        this.version = version;
    }
}

