/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.hive;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.hive.HiveDataNodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Hive data node info")
public class HiveDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveDataNodeDTO.class);
    @ApiModelProperty(value="Version for Hive, such as: 3.2.1")
    private String hiveVersion;
    @ApiModelProperty(value="Config directory of Hive on HDFS, needed by sort in light mode, must include hive-site.xml")
    private String hiveConfDir;
    @ApiModelProperty(value="HDFS default FS, such as: hdfs://127.0.0.1:9000")
    private String hdfsPath;
    @ApiModelProperty(value="Hive warehouse path, such as: /user/hive/warehouse/")
    private String warehouse;
    @ApiModelProperty(value="User and group information for writing data to HDFS")
    private String hdfsUgi;

    public static HiveDataNodeDTO getFromRequest(HiveDataNodeRequest request) throws Exception {
        return HiveDataNodeDTO.builder().hiveVersion(request.getHiveVersion()).hiveConfDir(request.getHiveConfDir()).hdfsPath(request.getHdfsPath()).warehouse(request.getWarehouse()).hdfsUgi(request.getHdfsUgi()).build();
    }

    public static HiveDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (HiveDataNodeDTO)JsonUtils.parseObject((String)extParams, HiveDataNodeDTO.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract additional parameters for hive data node: ", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT.getMessage());
        }
    }

    public static HiveDataNodeDTOBuilder builder() {
        return new HiveDataNodeDTOBuilder();
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    public String getHdfsPath() {
        return this.hdfsPath;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getHdfsUgi() {
        return this.hdfsUgi;
    }

    public void setHiveVersion(String hiveVersion) {
        this.hiveVersion = hiveVersion;
    }

    public void setHiveConfDir(String hiveConfDir) {
        this.hiveConfDir = hiveConfDir;
    }

    public void setHdfsPath(String hdfsPath) {
        this.hdfsPath = hdfsPath;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setHdfsUgi(String hdfsUgi) {
        this.hdfsUgi = hdfsUgi;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveDataNodeDTO)) {
            return false;
        }
        HiveDataNodeDTO other = (HiveDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hiveVersion = this.getHiveVersion();
        String other$hiveVersion = other.getHiveVersion();
        if (this$hiveVersion == null ? other$hiveVersion != null : !this$hiveVersion.equals(other$hiveVersion)) {
            return false;
        }
        String this$hiveConfDir = this.getHiveConfDir();
        String other$hiveConfDir = other.getHiveConfDir();
        if (this$hiveConfDir == null ? other$hiveConfDir != null : !this$hiveConfDir.equals(other$hiveConfDir)) {
            return false;
        }
        String this$hdfsPath = this.getHdfsPath();
        String other$hdfsPath = other.getHdfsPath();
        if (this$hdfsPath == null ? other$hdfsPath != null : !this$hdfsPath.equals(other$hdfsPath)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$hdfsUgi = this.getHdfsUgi();
        String other$hdfsUgi = other.getHdfsUgi();
        return !(this$hdfsUgi == null ? other$hdfsUgi != null : !this$hdfsUgi.equals(other$hdfsUgi));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HiveDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hiveVersion = this.getHiveVersion();
        result = result * 59 + ($hiveVersion == null ? 43 : $hiveVersion.hashCode());
        String $hiveConfDir = this.getHiveConfDir();
        result = result * 59 + ($hiveConfDir == null ? 43 : $hiveConfDir.hashCode());
        String $hdfsPath = this.getHdfsPath();
        result = result * 59 + ($hdfsPath == null ? 43 : $hdfsPath.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $hdfsUgi = this.getHdfsUgi();
        result = result * 59 + ($hdfsUgi == null ? 43 : $hdfsUgi.hashCode());
        return result;
    }

    public String toString() {
        return "HiveDataNodeDTO(hiveVersion=" + this.getHiveVersion() + ", hiveConfDir=" + this.getHiveConfDir() + ", hdfsPath=" + this.getHdfsPath() + ", warehouse=" + this.getWarehouse() + ", hdfsUgi=" + this.getHdfsUgi() + ")";
    }

    public HiveDataNodeDTO() {
    }

    public HiveDataNodeDTO(String hiveVersion, String hiveConfDir, String hdfsPath, String warehouse, String hdfsUgi) {
        this.hiveVersion = hiveVersion;
        this.hiveConfDir = hiveConfDir;
        this.hdfsPath = hdfsPath;
        this.warehouse = warehouse;
        this.hdfsUgi = hdfsUgi;
    }

    public static class HiveDataNodeDTOBuilder {
        private String hiveVersion;
        private String hiveConfDir;
        private String hdfsPath;
        private String warehouse;
        private String hdfsUgi;

        HiveDataNodeDTOBuilder() {
        }

        public HiveDataNodeDTOBuilder hiveVersion(String hiveVersion) {
            this.hiveVersion = hiveVersion;
            return this;
        }

        public HiveDataNodeDTOBuilder hiveConfDir(String hiveConfDir) {
            this.hiveConfDir = hiveConfDir;
            return this;
        }

        public HiveDataNodeDTOBuilder hdfsPath(String hdfsPath) {
            this.hdfsPath = hdfsPath;
            return this;
        }

        public HiveDataNodeDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public HiveDataNodeDTOBuilder hdfsUgi(String hdfsUgi) {
            this.hdfsUgi = hdfsUgi;
            return this;
        }

        public HiveDataNodeDTO build() {
            return new HiveDataNodeDTO(this.hiveVersion, this.hiveConfDir, this.hdfsPath, this.warehouse, this.hdfsUgi);
        }

        public String toString() {
            return "HiveDataNodeDTO.HiveDataNodeDTOBuilder(hiveVersion=" + this.hiveVersion + ", hiveConfDir=" + this.hiveConfDir + ", hdfsPath=" + this.hdfsPath + ", warehouse=" + this.warehouse + ", hdfsUgi=" + this.hdfsUgi + ")";
        }
    }
}

