/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.manager.pojo.stream.StreamPipeline;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.deduplication.DeDuplicationDefinition;
import org.apache.inlong.manager.pojo.transform.encrypt.EncryptDefinition;
import org.apache.inlong.manager.pojo.transform.filter.FilterDefinition;
import org.apache.inlong.manager.pojo.transform.joiner.JoinerDefinition;
import org.apache.inlong.manager.pojo.transform.replacer.StringReplacerDefinition;
import org.apache.inlong.manager.pojo.transform.splitter.SplitterDefinition;

public class StreamParseUtils {
    public static final String LEFT_NODE = "leftNode";
    public static final String RIGHT_NODE = "rightNode";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String SOURCE_NAME = "sourceName";
    public static final String SINK_TYPE = "sinkType";
    public static final String SINK_NAME = "sinkName";
    public static final String TRANSFORM_TYPE = "transformType";
    public static final String TRANSFORM_NAME = "transformName";
    private static final Gson GSON = new Gson();

    public static TransformDefinition parseTransformDefinition(String transformDefinition, TransformType transformType) {
        switch (transformType) {
            case FILTER: {
                return (TransformDefinition)GSON.fromJson(transformDefinition, FilterDefinition.class);
            }
            case JOINER: {
                return StreamParseUtils.parseJoinerDefinition(transformDefinition);
            }
            case SPLITTER: {
                return (TransformDefinition)GSON.fromJson(transformDefinition, SplitterDefinition.class);
            }
            case DE_DUPLICATION: {
                return (TransformDefinition)GSON.fromJson(transformDefinition, DeDuplicationDefinition.class);
            }
            case STRING_REPLACER: {
                return (TransformDefinition)GSON.fromJson(transformDefinition, StringReplacerDefinition.class);
            }
            case ENCRYPT: {
                return (TransformDefinition)GSON.fromJson(transformDefinition, EncryptDefinition.class);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported transformType for %s", transformType));
    }

    public static JoinerDefinition parseJoinerDefinition(String transformDefinition) {
        JoinerDefinition joinerDefinition = (JoinerDefinition)GSON.fromJson(transformDefinition, JoinerDefinition.class);
        JsonObject joinerJson = (JsonObject)GSON.fromJson(transformDefinition, JsonObject.class);
        JsonObject leftNode = joinerJson.getAsJsonObject(LEFT_NODE);
        StreamNode leftStreamNode = StreamParseUtils.parseNode(leftNode);
        joinerDefinition.setLeftNode(leftStreamNode);
        JsonObject rightNode = joinerJson.getAsJsonObject(RIGHT_NODE);
        StreamNode rightStreamNode = StreamParseUtils.parseNode(rightNode);
        joinerDefinition.setRightNode(rightStreamNode);
        return joinerDefinition;
    }

    private static StreamNode parseNode(JsonObject jsonObject) {
        if (jsonObject.has(SOURCE_TYPE)) {
            String sourceName = jsonObject.get(SOURCE_NAME).getAsString();
            StreamSource source = new StreamSource(){};
            source.setSourceName(sourceName);
            return source;
        }
        if (jsonObject.has(SINK_TYPE)) {
            String sinkName = jsonObject.get(SINK_NAME).getAsString();
            StreamSink sink = new StreamSink(){};
            sink.setSinkName(sinkName);
            return sink;
        }
        String transformName = jsonObject.get(TRANSFORM_NAME).getAsString();
        StreamTransform transform = new StreamTransform(){

            @Override
            public String getTransformName() {
                return super.getTransformName();
            }
        };
        transform.setTransformName(transformName);
        return transform;
    }

    public static StreamPipeline parseStreamPipeline(String tempView, String inlongStreamId) {
        Preconditions.checkNotEmpty((String)tempView, (String)String.format(" should not be null for streamId=%s", inlongStreamId));
        return (StreamPipeline)GSON.fromJson(tempView, StreamPipeline.class);
    }
}

