/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.SubSourceDTO;
import org.apache.inlong.manager.pojo.stream.StreamNode;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="sourceType")
@ApiModel(value="Stream source info")
public abstract class StreamSource
extends StreamNode {
    @ApiModelProperty(value="Source id")
    private Integer id;
    @ApiModelProperty(value="Inlong group id")
    private String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    private String inlongStreamId;
    @ApiModelProperty(value="Source type, including: FILE, KAFKA, etc.")
    private String sourceType;
    @ApiModelProperty(value="Source name, unique in one stream")
    private String sourceName;
    @ApiModelProperty(value="Ip of the agent running the task")
    private String agentIp;
    @ApiModelProperty(value="Mac uuid of the agent running the task")
    private String uuid;
    @ApiModelProperty(value="Inlong cluster name")
    private String inlongClusterName;
    @ApiModelProperty(value="Data node name")
    private String dataNodeName;
    @ApiModelProperty(value="Data Serialization, support: csv, json, canal, avro, etc")
    private String serializationType;
    @ApiModelProperty(value="Snapshot of this source task")
    private String snapshot;
    @ApiModelProperty(value="Version")
    private Integer version;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Previous status")
    private Integer previousStatus;
    @ApiModelProperty(value="Creator")
    private String creator;
    @ApiModelProperty(value="Modifier")
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(value="Properties for source")
    private Map<String, Object> properties;
    @ApiModelProperty(value="Null if not a sub source")
    private Integer templateId;
    @ApiModelProperty(value="Sub source information of existing agents")
    private List<SubSourceDTO> subSourceList;

    public SourceRequest genSourceRequest() {
        return null;
    }

    private static Map<String, Object> $default$properties() {
        return new LinkedHashMap<String, Object>();
    }

    protected StreamSource(StreamSourceBuilder<?, ?> b) {
        super(b);
        this.id = ((StreamSourceBuilder)b).id;
        this.inlongGroupId = ((StreamSourceBuilder)b).inlongGroupId;
        this.inlongStreamId = ((StreamSourceBuilder)b).inlongStreamId;
        this.sourceType = ((StreamSourceBuilder)b).sourceType;
        this.sourceName = ((StreamSourceBuilder)b).sourceName;
        this.agentIp = ((StreamSourceBuilder)b).agentIp;
        this.uuid = ((StreamSourceBuilder)b).uuid;
        this.inlongClusterName = ((StreamSourceBuilder)b).inlongClusterName;
        this.dataNodeName = ((StreamSourceBuilder)b).dataNodeName;
        this.serializationType = ((StreamSourceBuilder)b).serializationType;
        this.snapshot = ((StreamSourceBuilder)b).snapshot;
        this.version = ((StreamSourceBuilder)b).version;
        this.status = ((StreamSourceBuilder)b).status;
        this.previousStatus = ((StreamSourceBuilder)b).previousStatus;
        this.creator = ((StreamSourceBuilder)b).creator;
        this.modifier = ((StreamSourceBuilder)b).modifier;
        this.createTime = ((StreamSourceBuilder)b).createTime;
        this.modifyTime = ((StreamSourceBuilder)b).modifyTime;
        this.properties = ((StreamSourceBuilder)b).properties$set ? ((StreamSourceBuilder)b).properties$value : StreamSource.$default$properties();
        this.templateId = ((StreamSourceBuilder)b).templateId;
        this.subSourceList = ((StreamSourceBuilder)b).subSourceList;
    }

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getAgentIp() {
        return this.agentIp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getInlongClusterName() {
        return this.inlongClusterName;
    }

    public String getDataNodeName() {
        return this.dataNodeName;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getPreviousStatus() {
        return this.previousStatus;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public List<SubSourceDTO> getSubSourceList() {
        return this.subSourceList;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setAgentIp(String agentIp) {
        this.agentIp = agentIp;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setInlongClusterName(String inlongClusterName) {
        this.inlongClusterName = inlongClusterName;
    }

    public void setDataNodeName(String dataNodeName) {
        this.dataNodeName = dataNodeName;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public void setSubSourceList(List<SubSourceDTO> subSourceList) {
        this.subSourceList = subSourceList;
    }

    @Override
    public String toString() {
        return "StreamSource(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", sourceType=" + this.getSourceType() + ", sourceName=" + this.getSourceName() + ", agentIp=" + this.getAgentIp() + ", uuid=" + this.getUuid() + ", inlongClusterName=" + this.getInlongClusterName() + ", dataNodeName=" + this.getDataNodeName() + ", serializationType=" + this.getSerializationType() + ", snapshot=" + this.getSnapshot() + ", version=" + this.getVersion() + ", status=" + this.getStatus() + ", previousStatus=" + this.getPreviousStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", properties=" + this.getProperties() + ", templateId=" + this.getTemplateId() + ", subSourceList=" + this.getSubSourceList() + ")";
    }

    public StreamSource() {
        this.properties = StreamSource.$default$properties();
    }

    public StreamSource(Integer id, String inlongGroupId, String inlongStreamId, String sourceType, String sourceName, String agentIp, String uuid, String inlongClusterName, String dataNodeName, String serializationType, String snapshot, Integer version, Integer status, Integer previousStatus, String creator, String modifier, Date createTime, Date modifyTime, Map<String, Object> properties, Integer templateId, List<SubSourceDTO> subSourceList) {
        this.id = id;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.sourceType = sourceType;
        this.sourceName = sourceName;
        this.agentIp = agentIp;
        this.uuid = uuid;
        this.inlongClusterName = inlongClusterName;
        this.dataNodeName = dataNodeName;
        this.serializationType = serializationType;
        this.snapshot = snapshot;
        this.version = version;
        this.status = status;
        this.previousStatus = previousStatus;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.properties = properties;
        this.templateId = templateId;
        this.subSourceList = subSourceList;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamSource)) {
            return false;
        }
        StreamSource other = (StreamSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$previousStatus = this.getPreviousStatus();
        Integer other$previousStatus = other.getPreviousStatus();
        if (this$previousStatus == null ? other$previousStatus != null : !((Object)this$previousStatus).equals(other$previousStatus)) {
            return false;
        }
        Integer this$templateId = this.getTemplateId();
        Integer other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !((Object)this$templateId).equals(other$templateId)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        String this$agentIp = this.getAgentIp();
        String other$agentIp = other.getAgentIp();
        if (this$agentIp == null ? other$agentIp != null : !this$agentIp.equals(other$agentIp)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$inlongClusterName = this.getInlongClusterName();
        String other$inlongClusterName = other.getInlongClusterName();
        if (this$inlongClusterName == null ? other$inlongClusterName != null : !this$inlongClusterName.equals(other$inlongClusterName)) {
            return false;
        }
        String this$dataNodeName = this.getDataNodeName();
        String other$dataNodeName = other.getDataNodeName();
        if (this$dataNodeName == null ? other$dataNodeName != null : !this$dataNodeName.equals(other$dataNodeName)) {
            return false;
        }
        String this$serializationType = this.getSerializationType();
        String other$serializationType = other.getSerializationType();
        if (this$serializationType == null ? other$serializationType != null : !this$serializationType.equals(other$serializationType)) {
            return false;
        }
        String this$snapshot = this.getSnapshot();
        String other$snapshot = other.getSnapshot();
        if (this$snapshot == null ? other$snapshot != null : !this$snapshot.equals(other$snapshot)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<SubSourceDTO> this$subSourceList = this.getSubSourceList();
        List<SubSourceDTO> other$subSourceList = other.getSubSourceList();
        return !(this$subSourceList == null ? other$subSourceList != null : !((Object)this$subSourceList).equals(other$subSourceList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StreamSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $previousStatus = this.getPreviousStatus();
        result = result * 59 + ($previousStatus == null ? 43 : ((Object)$previousStatus).hashCode());
        Integer $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : ((Object)$templateId).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        String $agentIp = this.getAgentIp();
        result = result * 59 + ($agentIp == null ? 43 : $agentIp.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $inlongClusterName = this.getInlongClusterName();
        result = result * 59 + ($inlongClusterName == null ? 43 : $inlongClusterName.hashCode());
        String $dataNodeName = this.getDataNodeName();
        result = result * 59 + ($dataNodeName == null ? 43 : $dataNodeName.hashCode());
        String $serializationType = this.getSerializationType();
        result = result * 59 + ($serializationType == null ? 43 : $serializationType.hashCode());
        String $snapshot = this.getSnapshot();
        result = result * 59 + ($snapshot == null ? 43 : $snapshot.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<SubSourceDTO> $subSourceList = this.getSubSourceList();
        result = result * 59 + ($subSourceList == null ? 43 : ((Object)$subSourceList).hashCode());
        return result;
    }

    public static abstract class StreamSourceBuilder<C extends StreamSource, B extends StreamSourceBuilder<C, B>>
    extends StreamNode.StreamNodeBuilder<C, B> {
        private Integer id;
        private String inlongGroupId;
        private String inlongStreamId;
        private String sourceType;
        private String sourceName;
        private String agentIp;
        private String uuid;
        private String inlongClusterName;
        private String dataNodeName;
        private String serializationType;
        private String snapshot;
        private Integer version;
        private Integer status;
        private Integer previousStatus;
        private String creator;
        private String modifier;
        private Date createTime;
        private Date modifyTime;
        private boolean properties$set;
        private Map<String, Object> properties$value;
        private Integer templateId;
        private List<SubSourceDTO> subSourceList;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B id(Integer id) {
            this.id = id;
            return (B)this.self();
        }

        public B inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return (B)this.self();
        }

        public B inlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
            return (B)this.self();
        }

        public B sourceType(String sourceType) {
            this.sourceType = sourceType;
            return (B)this.self();
        }

        public B sourceName(String sourceName) {
            this.sourceName = sourceName;
            return (B)this.self();
        }

        public B agentIp(String agentIp) {
            this.agentIp = agentIp;
            return (B)this.self();
        }

        public B uuid(String uuid) {
            this.uuid = uuid;
            return (B)this.self();
        }

        public B inlongClusterName(String inlongClusterName) {
            this.inlongClusterName = inlongClusterName;
            return (B)this.self();
        }

        public B dataNodeName(String dataNodeName) {
            this.dataNodeName = dataNodeName;
            return (B)this.self();
        }

        public B serializationType(String serializationType) {
            this.serializationType = serializationType;
            return (B)this.self();
        }

        public B snapshot(String snapshot) {
            this.snapshot = snapshot;
            return (B)this.self();
        }

        public B version(Integer version) {
            this.version = version;
            return (B)this.self();
        }

        public B status(Integer status) {
            this.status = status;
            return (B)this.self();
        }

        public B previousStatus(Integer previousStatus) {
            this.previousStatus = previousStatus;
            return (B)this.self();
        }

        public B creator(String creator) {
            this.creator = creator;
            return (B)this.self();
        }

        public B modifier(String modifier) {
            this.modifier = modifier;
            return (B)this.self();
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public B createTime(Date createTime) {
            this.createTime = createTime;
            return (B)this.self();
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public B modifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
            return (B)this.self();
        }

        public B properties(Map<String, Object> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return (B)this.self();
        }

        public B templateId(Integer templateId) {
            this.templateId = templateId;
            return (B)this.self();
        }

        public B subSourceList(List<SubSourceDTO> subSourceList) {
            this.subSourceList = subSourceList;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StreamSource.StreamSourceBuilder(super=" + super.toString() + ", id=" + this.id + ", inlongGroupId=" + this.inlongGroupId + ", inlongStreamId=" + this.inlongStreamId + ", sourceType=" + this.sourceType + ", sourceName=" + this.sourceName + ", agentIp=" + this.agentIp + ", uuid=" + this.uuid + ", inlongClusterName=" + this.inlongClusterName + ", dataNodeName=" + this.dataNodeName + ", serializationType=" + this.serializationType + ", snapshot=" + this.snapshot + ", version=" + this.version + ", status=" + this.status + ", previousStatus=" + this.previousStatus + ", creator=" + this.creator + ", modifier=" + this.modifier + ", createTime=" + this.createTime + ", modifyTime=" + this.modifyTime + ", properties$value=" + this.properties$value + ", templateId=" + this.templateId + ", subSourceList=" + this.subSourceList + ")";
        }
    }
}

