/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.redis;

import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.source.redis.RedisSourceRequest;

public class RedisSourceDTO {
    @ApiModelProperty(value="Username of the redis server")
    private String username;
    @ApiModelProperty(value="Password of the redis server")
    private String password;
    @ApiModelProperty(value="Hostname of the redis server")
    private String hostname;
    @ApiModelProperty(value="Port of the redis server")
    private Integer port;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Redis command, supports: hget, get, zscore, zrevrank")
    private String redisCommand;
    @ApiModelProperty(value="Redis deploy mode, supports: standalone, cluster, sentinel")
    private String redisMode;
    @ApiModelProperty(value="Cluster node infos only used for redis cluster deploy mode")
    private String clusterNodes;
    @ApiModelProperty(value="Master name only used for redis sentinel deploy mode")
    private String masterName;
    @ApiModelProperty(value="Sentinels info only used for redis sentinel deploy mode")
    private String sentinelsInfo;
    @ApiModelProperty(value="Additional key only used for hash/Sorted-set data type")
    private String additionalKey;
    @ApiModelProperty(value="Database number connect to redis for redis standalone/sentinel deploy modes")
    private Integer database;
    @ApiModelProperty(value="Timeout value of connect to redis")
    private Integer timeout;
    @ApiModelProperty(value="Timeout value of read data from redis")
    private Integer soTimeout;
    @ApiModelProperty(value="Max connection number to redis")
    private Integer maxTotal;
    @ApiModelProperty(value="Max free connection number")
    private Integer maxIdle;
    @ApiModelProperty(value="Min free connection number")
    private Integer minIdle;
    @ApiModelProperty(value="Lookup cache max rows")
    private Long lookupCacheMaxRows;
    @ApiModelProperty(value="Lookup cache ttl")
    private Long lookupCacheTtl;
    @ApiModelProperty(value="Lookup max retry times")
    private Integer lookupMaxRetries;
    @ApiModelProperty(value="Lookup Async")
    private Boolean lookupAsync;
    @ApiModelProperty(value="Properties for redis")
    private Map<String, Object> properties;

    public static RedisSourceDTO getFromRequest(RedisSourceRequest request) {
        return RedisSourceDTO.builder().username(request.getUsername()).password(request.getPassword()).hostname(request.getHostname()).port(request.getPort()).primaryKey(request.getPrimaryKey()).redisCommand(request.getRedisCommand()).redisMode(request.getRedisMode()).clusterNodes(request.getClusterNodes()).masterName(request.getMasterName()).sentinelsInfo(request.getSentinelsInfo()).additionalKey(request.getAdditionalKey()).database(request.getDatabase()).timeout(request.getTimeout()).soTimeout(request.getSoTimeout()).maxTotal(request.getMaxTotal()).maxIdle(request.getMaxIdle()).minIdle(request.getMinIdle()).lookupCacheMaxRows(request.getLookupCacheMaxRows()).lookupCacheTtl(request.getLookupCacheTtl()).lookupMaxRetries(request.getLookupMaxRetries()).lookupAsync(request.getLookupAsync()).properties(request.getProperties()).build();
    }

    public static RedisSourceDTO getFromJson(@NotNull String extParams) {
        try {
            return (RedisSourceDTO)JsonUtils.parseObject((String)extParams, RedisSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static RedisSourceDTOBuilder builder() {
        return new RedisSourceDTOBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getRedisCommand() {
        return this.redisCommand;
    }

    public String getRedisMode() {
        return this.redisMode;
    }

    public String getClusterNodes() {
        return this.clusterNodes;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getSentinelsInfo() {
        return this.sentinelsInfo;
    }

    public String getAdditionalKey() {
        return this.additionalKey;
    }

    public Integer getDatabase() {
        return this.database;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    public Integer getMaxIdle() {
        return this.maxIdle;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public Long getLookupCacheMaxRows() {
        return this.lookupCacheMaxRows;
    }

    public Long getLookupCacheTtl() {
        return this.lookupCacheTtl;
    }

    public Integer getLookupMaxRetries() {
        return this.lookupMaxRetries;
    }

    public Boolean getLookupAsync() {
        return this.lookupAsync;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setRedisCommand(String redisCommand) {
        this.redisCommand = redisCommand;
    }

    public void setRedisMode(String redisMode) {
        this.redisMode = redisMode;
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setSentinelsInfo(String sentinelsInfo) {
        this.sentinelsInfo = sentinelsInfo;
    }

    public void setAdditionalKey(String additionalKey) {
        this.additionalKey = additionalKey;
    }

    public void setDatabase(Integer database) {
        this.database = database;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setLookupCacheMaxRows(Long lookupCacheMaxRows) {
        this.lookupCacheMaxRows = lookupCacheMaxRows;
    }

    public void setLookupCacheTtl(Long lookupCacheTtl) {
        this.lookupCacheTtl = lookupCacheTtl;
    }

    public void setLookupMaxRetries(Integer lookupMaxRetries) {
        this.lookupMaxRetries = lookupMaxRetries;
    }

    public void setLookupAsync(Boolean lookupAsync) {
        this.lookupAsync = lookupAsync;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisSourceDTO)) {
            return false;
        }
        RedisSourceDTO other = (RedisSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$database = this.getDatabase();
        Integer other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Integer this$soTimeout = this.getSoTimeout();
        Integer other$soTimeout = other.getSoTimeout();
        if (this$soTimeout == null ? other$soTimeout != null : !((Object)this$soTimeout).equals(other$soTimeout)) {
            return false;
        }
        Integer this$maxTotal = this.getMaxTotal();
        Integer other$maxTotal = other.getMaxTotal();
        if (this$maxTotal == null ? other$maxTotal != null : !((Object)this$maxTotal).equals(other$maxTotal)) {
            return false;
        }
        Integer this$maxIdle = this.getMaxIdle();
        Integer other$maxIdle = other.getMaxIdle();
        if (this$maxIdle == null ? other$maxIdle != null : !((Object)this$maxIdle).equals(other$maxIdle)) {
            return false;
        }
        Integer this$minIdle = this.getMinIdle();
        Integer other$minIdle = other.getMinIdle();
        if (this$minIdle == null ? other$minIdle != null : !((Object)this$minIdle).equals(other$minIdle)) {
            return false;
        }
        Long this$lookupCacheMaxRows = this.getLookupCacheMaxRows();
        Long other$lookupCacheMaxRows = other.getLookupCacheMaxRows();
        if (this$lookupCacheMaxRows == null ? other$lookupCacheMaxRows != null : !((Object)this$lookupCacheMaxRows).equals(other$lookupCacheMaxRows)) {
            return false;
        }
        Long this$lookupCacheTtl = this.getLookupCacheTtl();
        Long other$lookupCacheTtl = other.getLookupCacheTtl();
        if (this$lookupCacheTtl == null ? other$lookupCacheTtl != null : !((Object)this$lookupCacheTtl).equals(other$lookupCacheTtl)) {
            return false;
        }
        Integer this$lookupMaxRetries = this.getLookupMaxRetries();
        Integer other$lookupMaxRetries = other.getLookupMaxRetries();
        if (this$lookupMaxRetries == null ? other$lookupMaxRetries != null : !((Object)this$lookupMaxRetries).equals(other$lookupMaxRetries)) {
            return false;
        }
        Boolean this$lookupAsync = this.getLookupAsync();
        Boolean other$lookupAsync = other.getLookupAsync();
        if (this$lookupAsync == null ? other$lookupAsync != null : !((Object)this$lookupAsync).equals(other$lookupAsync)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$redisCommand = this.getRedisCommand();
        String other$redisCommand = other.getRedisCommand();
        if (this$redisCommand == null ? other$redisCommand != null : !this$redisCommand.equals(other$redisCommand)) {
            return false;
        }
        String this$redisMode = this.getRedisMode();
        String other$redisMode = other.getRedisMode();
        if (this$redisMode == null ? other$redisMode != null : !this$redisMode.equals(other$redisMode)) {
            return false;
        }
        String this$clusterNodes = this.getClusterNodes();
        String other$clusterNodes = other.getClusterNodes();
        if (this$clusterNodes == null ? other$clusterNodes != null : !this$clusterNodes.equals(other$clusterNodes)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        String this$sentinelsInfo = this.getSentinelsInfo();
        String other$sentinelsInfo = other.getSentinelsInfo();
        if (this$sentinelsInfo == null ? other$sentinelsInfo != null : !this$sentinelsInfo.equals(other$sentinelsInfo)) {
            return false;
        }
        String this$additionalKey = this.getAdditionalKey();
        String other$additionalKey = other.getAdditionalKey();
        if (this$additionalKey == null ? other$additionalKey != null : !this$additionalKey.equals(other$additionalKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Integer $soTimeout = this.getSoTimeout();
        result = result * 59 + ($soTimeout == null ? 43 : ((Object)$soTimeout).hashCode());
        Integer $maxTotal = this.getMaxTotal();
        result = result * 59 + ($maxTotal == null ? 43 : ((Object)$maxTotal).hashCode());
        Integer $maxIdle = this.getMaxIdle();
        result = result * 59 + ($maxIdle == null ? 43 : ((Object)$maxIdle).hashCode());
        Integer $minIdle = this.getMinIdle();
        result = result * 59 + ($minIdle == null ? 43 : ((Object)$minIdle).hashCode());
        Long $lookupCacheMaxRows = this.getLookupCacheMaxRows();
        result = result * 59 + ($lookupCacheMaxRows == null ? 43 : ((Object)$lookupCacheMaxRows).hashCode());
        Long $lookupCacheTtl = this.getLookupCacheTtl();
        result = result * 59 + ($lookupCacheTtl == null ? 43 : ((Object)$lookupCacheTtl).hashCode());
        Integer $lookupMaxRetries = this.getLookupMaxRetries();
        result = result * 59 + ($lookupMaxRetries == null ? 43 : ((Object)$lookupMaxRetries).hashCode());
        Boolean $lookupAsync = this.getLookupAsync();
        result = result * 59 + ($lookupAsync == null ? 43 : ((Object)$lookupAsync).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $redisCommand = this.getRedisCommand();
        result = result * 59 + ($redisCommand == null ? 43 : $redisCommand.hashCode());
        String $redisMode = this.getRedisMode();
        result = result * 59 + ($redisMode == null ? 43 : $redisMode.hashCode());
        String $clusterNodes = this.getClusterNodes();
        result = result * 59 + ($clusterNodes == null ? 43 : $clusterNodes.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        String $sentinelsInfo = this.getSentinelsInfo();
        result = result * 59 + ($sentinelsInfo == null ? 43 : $sentinelsInfo.hashCode());
        String $additionalKey = this.getAdditionalKey();
        result = result * 59 + ($additionalKey == null ? 43 : $additionalKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "RedisSourceDTO(username=" + this.getUsername() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", primaryKey=" + this.getPrimaryKey() + ", redisCommand=" + this.getRedisCommand() + ", redisMode=" + this.getRedisMode() + ", clusterNodes=" + this.getClusterNodes() + ", masterName=" + this.getMasterName() + ", sentinelsInfo=" + this.getSentinelsInfo() + ", additionalKey=" + this.getAdditionalKey() + ", database=" + this.getDatabase() + ", timeout=" + this.getTimeout() + ", soTimeout=" + this.getSoTimeout() + ", maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", lookupCacheMaxRows=" + this.getLookupCacheMaxRows() + ", lookupCacheTtl=" + this.getLookupCacheTtl() + ", lookupMaxRetries=" + this.getLookupMaxRetries() + ", lookupAsync=" + this.getLookupAsync() + ", properties=" + this.getProperties() + ")";
    }

    public RedisSourceDTO() {
    }

    public RedisSourceDTO(String username, String password, String hostname, Integer port, String primaryKey, String redisCommand, String redisMode, String clusterNodes, String masterName, String sentinelsInfo, String additionalKey, Integer database, Integer timeout, Integer soTimeout, Integer maxTotal, Integer maxIdle, Integer minIdle, Long lookupCacheMaxRows, Long lookupCacheTtl, Integer lookupMaxRetries, Boolean lookupAsync, Map<String, Object> properties) {
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.primaryKey = primaryKey;
        this.redisCommand = redisCommand;
        this.redisMode = redisMode;
        this.clusterNodes = clusterNodes;
        this.masterName = masterName;
        this.sentinelsInfo = sentinelsInfo;
        this.additionalKey = additionalKey;
        this.database = database;
        this.timeout = timeout;
        this.soTimeout = soTimeout;
        this.maxTotal = maxTotal;
        this.maxIdle = maxIdle;
        this.minIdle = minIdle;
        this.lookupCacheMaxRows = lookupCacheMaxRows;
        this.lookupCacheTtl = lookupCacheTtl;
        this.lookupMaxRetries = lookupMaxRetries;
        this.lookupAsync = lookupAsync;
        this.properties = properties;
    }

    public static class RedisSourceDTOBuilder {
        private String username;
        private String password;
        private String hostname;
        private Integer port;
        private String primaryKey;
        private String redisCommand;
        private String redisMode;
        private String clusterNodes;
        private String masterName;
        private String sentinelsInfo;
        private String additionalKey;
        private Integer database;
        private Integer timeout;
        private Integer soTimeout;
        private Integer maxTotal;
        private Integer maxIdle;
        private Integer minIdle;
        private Long lookupCacheMaxRows;
        private Long lookupCacheTtl;
        private Integer lookupMaxRetries;
        private Boolean lookupAsync;
        private Map<String, Object> properties;

        RedisSourceDTOBuilder() {
        }

        public RedisSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public RedisSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RedisSourceDTOBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public RedisSourceDTOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public RedisSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public RedisSourceDTOBuilder redisCommand(String redisCommand) {
            this.redisCommand = redisCommand;
            return this;
        }

        public RedisSourceDTOBuilder redisMode(String redisMode) {
            this.redisMode = redisMode;
            return this;
        }

        public RedisSourceDTOBuilder clusterNodes(String clusterNodes) {
            this.clusterNodes = clusterNodes;
            return this;
        }

        public RedisSourceDTOBuilder masterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public RedisSourceDTOBuilder sentinelsInfo(String sentinelsInfo) {
            this.sentinelsInfo = sentinelsInfo;
            return this;
        }

        public RedisSourceDTOBuilder additionalKey(String additionalKey) {
            this.additionalKey = additionalKey;
            return this;
        }

        public RedisSourceDTOBuilder database(Integer database) {
            this.database = database;
            return this;
        }

        public RedisSourceDTOBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public RedisSourceDTOBuilder soTimeout(Integer soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public RedisSourceDTOBuilder maxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public RedisSourceDTOBuilder maxIdle(Integer maxIdle) {
            this.maxIdle = maxIdle;
            return this;
        }

        public RedisSourceDTOBuilder minIdle(Integer minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public RedisSourceDTOBuilder lookupCacheMaxRows(Long lookupCacheMaxRows) {
            this.lookupCacheMaxRows = lookupCacheMaxRows;
            return this;
        }

        public RedisSourceDTOBuilder lookupCacheTtl(Long lookupCacheTtl) {
            this.lookupCacheTtl = lookupCacheTtl;
            return this;
        }

        public RedisSourceDTOBuilder lookupMaxRetries(Integer lookupMaxRetries) {
            this.lookupMaxRetries = lookupMaxRetries;
            return this;
        }

        public RedisSourceDTOBuilder lookupAsync(Boolean lookupAsync) {
            this.lookupAsync = lookupAsync;
            return this;
        }

        public RedisSourceDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public RedisSourceDTO build() {
            return new RedisSourceDTO(this.username, this.password, this.hostname, this.port, this.primaryKey, this.redisCommand, this.redisMode, this.clusterNodes, this.masterName, this.sentinelsInfo, this.additionalKey, this.database, this.timeout, this.soTimeout, this.maxTotal, this.maxIdle, this.minIdle, this.lookupCacheMaxRows, this.lookupCacheTtl, this.lookupMaxRetries, this.lookupAsync, this.properties);
        }

        public String toString() {
            return "RedisSourceDTO.RedisSourceDTOBuilder(username=" + this.username + ", password=" + this.password + ", hostname=" + this.hostname + ", port=" + this.port + ", primaryKey=" + this.primaryKey + ", redisCommand=" + this.redisCommand + ", redisMode=" + this.redisMode + ", clusterNodes=" + this.clusterNodes + ", masterName=" + this.masterName + ", sentinelsInfo=" + this.sentinelsInfo + ", additionalKey=" + this.additionalKey + ", database=" + this.database + ", timeout=" + this.timeout + ", soTimeout=" + this.soTimeout + ", maxTotal=" + this.maxTotal + ", maxIdle=" + this.maxIdle + ", minIdle=" + this.minIdle + ", lookupCacheMaxRows=" + this.lookupCacheMaxRows + ", lookupCacheTtl=" + this.lookupCacheTtl + ", lookupMaxRetries=" + this.lookupMaxRetries + ", lookupAsync=" + this.lookupAsync + ", properties=" + this.properties + ")";
        }
    }
}

