/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.stream.StreamNodeRelation;

public class StreamPipeline {
    private List<StreamNodeRelation> pipeline;

    public StreamPipeline() {
        this(Lists.newArrayList());
    }

    public StreamPipeline(List<StreamNodeRelation> pipeline) {
        Preconditions.checkNotNull(pipeline, (String)"Pipeline should not be null");
        this.pipeline = pipeline;
    }

    public void addRelation(StreamNodeRelation relation) {
        this.pipeline.add(relation);
    }

    public Pair<Boolean, Pair<String, String>> hasCircle() {
        HashMap priorityMap = Maps.newHashMap();
        for (StreamNodeRelation relation : this.pipeline) {
            Set<String> inputNodes = relation.getInputNodes();
            Set<String> outputNodes = relation.getOutputNodes();
            for (String inputNode : inputNodes) {
                for (String outputNode : outputNodes) {
                    priorityMap.computeIfAbsent(inputNode, key -> Sets.newHashSet()).add(outputNode);
                    if (CollectionUtils.isEmpty((Collection)((Collection)priorityMap.get(outputNode)))) continue;
                    Set priorityNodesOfOutput = (Set)priorityMap.get(outputNode);
                    if (priorityNodesOfOutput.contains(inputNode)) {
                        return Pair.of((Object)true, (Object)Pair.of((Object)inputNode, (Object)outputNode));
                    }
                    if (!this.isReach(priorityMap, priorityNodesOfOutput, inputNode)) continue;
                    return Pair.of((Object)true, (Object)Pair.of((Object)inputNode, (Object)outputNode));
                }
            }
        }
        return Pair.of((Object)false, null);
    }

    private boolean isReach(Map<String, Set<String>> paths, Set<String> inputs, String output) {
        LinkedList<String> queue = new LinkedList<String>(inputs);
        HashSet<String> preNodes = new HashSet<String>(inputs);
        while (!queue.isEmpty()) {
            String node = (String)queue.remove();
            if (paths.get(node) == null) continue;
            Set<String> postNodes = paths.get(node);
            if (postNodes.contains(output)) {
                return true;
            }
            for (String postNode : postNodes) {
                if (preNodes.contains(postNode)) continue;
                preNodes.add(postNode);
                queue.add(postNode);
            }
        }
        return false;
    }

    public List<StreamNodeRelation> getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(List<StreamNodeRelation> pipeline) {
        this.pipeline = pipeline;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamPipeline)) {
            return false;
        }
        StreamPipeline other = (StreamPipeline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<StreamNodeRelation> this$pipeline = this.getPipeline();
        List<StreamNodeRelation> other$pipeline = other.getPipeline();
        return !(this$pipeline == null ? other$pipeline != null : !((Object)this$pipeline).equals(other$pipeline));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamPipeline;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StreamNodeRelation> $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : ((Object)$pipeline).hashCode());
        return result;
    }

    public String toString() {
        return "StreamPipeline(pipeline=" + this.getPipeline() + ")";
    }
}

