/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.transform;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Stream transform request")
public class TransformRequest {
    @NotNull(groups={UpdateValidation.class})
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @NotBlank(message="inlongGroupId cannot be blank")
    @ApiModelProperty(value="Inlong group id")
    private @NotBlank(message="inlongGroupId cannot be blank") String inlongGroupId;
    @NotBlank(message="inlongStreamId cannot be blank")
    @ApiModelProperty(value="Inlong stream id")
    private @NotBlank(message="inlongStreamId cannot be blank") String inlongStreamId;
    @NotBlank(message="transformName cannot be blank")
    @Length(min=1, max=100, message="transformName length must be between 1 and 100")
    @Pattern(regexp="^[a-z0-9_-]{1,100}$", message="transformName only supports lowercase letters, numbers, '-', or '_'")
    @ApiModelProperty(value="Transform name, unique in one stream")
    private @NotBlank(message="transformName cannot be blank") @Length(min=1, max=100, message="transformName length must be between 1 and 100") @Pattern(regexp="^[a-z0-9_-]{1,100}$", message="transformName only supports lowercase letters, numbers, '-', or '_'") String transformName;
    @NotBlank(message="transformType cannot be blank")
    @ApiModelProperty(value="Transform type, including: splitter, filter, joiner, etc.")
    private @NotBlank(message="transformType cannot be blank") String transformType;
    @NotBlank(message="preNodeNames cannot be blank")
    @ApiModelProperty(value="Pre node names of transform in this stream, join by ','")
    private @NotBlank(message="preNodeNames cannot be blank") String preNodeNames;
    @NotBlank(message="postNodeNames cannot be blank")
    @ApiModelProperty(value="Post node names of transform in this stream, join by ','")
    private @NotBlank(message="postNodeNames cannot be blank") String postNodeNames;
    @NotBlank(message="transformDefinition cannot be blank")
    @ApiModelProperty(value="Transform definition in json type")
    private @NotBlank(message="transformDefinition cannot be blank") String transformDefinition;
    @ApiModelProperty(value="Version of transform")
    private Integer version;
    @ApiModelProperty(value="Field list")
    private List<StreamField> fieldList;

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getTransformName() {
        return this.transformName;
    }

    public String getTransformType() {
        return this.transformType;
    }

    public String getPreNodeNames() {
        return this.preNodeNames;
    }

    public String getPostNodeNames() {
        return this.postNodeNames;
    }

    public String getTransformDefinition() {
        return this.transformDefinition;
    }

    public Integer getVersion() {
        return this.version;
    }

    public List<StreamField> getFieldList() {
        return this.fieldList;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public void setTransformType(String transformType) {
        this.transformType = transformType;
    }

    public void setPreNodeNames(String preNodeNames) {
        this.preNodeNames = preNodeNames;
    }

    public void setPostNodeNames(String postNodeNames) {
        this.postNodeNames = postNodeNames;
    }

    public void setTransformDefinition(String transformDefinition) {
        this.transformDefinition = transformDefinition;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setFieldList(List<StreamField> fieldList) {
        this.fieldList = fieldList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformRequest)) {
            return false;
        }
        TransformRequest other = (TransformRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$transformName = this.getTransformName();
        String other$transformName = other.getTransformName();
        if (this$transformName == null ? other$transformName != null : !this$transformName.equals(other$transformName)) {
            return false;
        }
        String this$transformType = this.getTransformType();
        String other$transformType = other.getTransformType();
        if (this$transformType == null ? other$transformType != null : !this$transformType.equals(other$transformType)) {
            return false;
        }
        String this$preNodeNames = this.getPreNodeNames();
        String other$preNodeNames = other.getPreNodeNames();
        if (this$preNodeNames == null ? other$preNodeNames != null : !this$preNodeNames.equals(other$preNodeNames)) {
            return false;
        }
        String this$postNodeNames = this.getPostNodeNames();
        String other$postNodeNames = other.getPostNodeNames();
        if (this$postNodeNames == null ? other$postNodeNames != null : !this$postNodeNames.equals(other$postNodeNames)) {
            return false;
        }
        String this$transformDefinition = this.getTransformDefinition();
        String other$transformDefinition = other.getTransformDefinition();
        if (this$transformDefinition == null ? other$transformDefinition != null : !this$transformDefinition.equals(other$transformDefinition)) {
            return false;
        }
        List<StreamField> this$fieldList = this.getFieldList();
        List<StreamField> other$fieldList = other.getFieldList();
        return !(this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransformRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $transformName = this.getTransformName();
        result = result * 59 + ($transformName == null ? 43 : $transformName.hashCode());
        String $transformType = this.getTransformType();
        result = result * 59 + ($transformType == null ? 43 : $transformType.hashCode());
        String $preNodeNames = this.getPreNodeNames();
        result = result * 59 + ($preNodeNames == null ? 43 : $preNodeNames.hashCode());
        String $postNodeNames = this.getPostNodeNames();
        result = result * 59 + ($postNodeNames == null ? 43 : $postNodeNames.hashCode());
        String $transformDefinition = this.getTransformDefinition();
        result = result * 59 + ($transformDefinition == null ? 43 : $transformDefinition.hashCode());
        List<StreamField> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        return result;
    }

    public String toString() {
        return "TransformRequest(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", transformName=" + this.getTransformName() + ", transformType=" + this.getTransformType() + ", preNodeNames=" + this.getPreNodeNames() + ", postNodeNames=" + this.getPostNodeNames() + ", transformDefinition=" + this.getTransformDefinition() + ", version=" + this.getVersion() + ", fieldList=" + this.getFieldList() + ")";
    }
}

