/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterRequest;

@ApiModel(value="Pulsar cluster info")
public class PulsarClusterDTO {
    @ApiModelProperty(value="Pulsar admin URL, such as: http://127.0.0.1:8080")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar service URL, is the 'url' field of the cluster")
    private String serviceUrl;
    @ApiModelProperty(value="Pulsar tenant, default is 'public'")
    private String tenant;
    private String messageQueueHandler;

    public static PulsarClusterDTO getFromRequest(PulsarClusterRequest request) {
        return PulsarClusterDTO.builder().adminUrl(request.getAdminUrl()).serviceUrl(request.getUrl()).tenant(request.getTenant()).build();
    }

    public static PulsarClusterDTO getFromJson(@NotNull String extParams) {
        try {
            return (PulsarClusterDTO)JsonUtils.parseObject((String)extParams, PulsarClusterDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    private static String $default$messageQueueHandler() {
        return "org.apache.inlong.dataproxy.sink.mq.pulsar.PulsarHandler";
    }

    public static PulsarClusterDTOBuilder builder() {
        return new PulsarClusterDTOBuilder();
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getMessageQueueHandler() {
        return this.messageQueueHandler;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setMessageQueueHandler(String messageQueueHandler) {
        this.messageQueueHandler = messageQueueHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarClusterDTO)) {
            return false;
        }
        PulsarClusterDTO other = (PulsarClusterDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$messageQueueHandler = this.getMessageQueueHandler();
        String other$messageQueueHandler = other.getMessageQueueHandler();
        return !(this$messageQueueHandler == null ? other$messageQueueHandler != null : !this$messageQueueHandler.equals(other$messageQueueHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarClusterDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $messageQueueHandler = this.getMessageQueueHandler();
        result = result * 59 + ($messageQueueHandler == null ? 43 : $messageQueueHandler.hashCode());
        return result;
    }

    public String toString() {
        return "PulsarClusterDTO(adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", tenant=" + this.getTenant() + ", messageQueueHandler=" + this.getMessageQueueHandler() + ")";
    }

    public PulsarClusterDTO() {
        this.messageQueueHandler = PulsarClusterDTO.$default$messageQueueHandler();
    }

    public PulsarClusterDTO(String adminUrl, String serviceUrl, String tenant, String messageQueueHandler) {
        this.adminUrl = adminUrl;
        this.serviceUrl = serviceUrl;
        this.tenant = tenant;
        this.messageQueueHandler = messageQueueHandler;
    }

    public static class PulsarClusterDTOBuilder {
        private String adminUrl;
        private String serviceUrl;
        private String tenant;
        private boolean messageQueueHandler$set;
        private String messageQueueHandler$value;

        PulsarClusterDTOBuilder() {
        }

        public PulsarClusterDTOBuilder adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return this;
        }

        public PulsarClusterDTOBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public PulsarClusterDTOBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public PulsarClusterDTOBuilder messageQueueHandler(String messageQueueHandler) {
            this.messageQueueHandler$value = messageQueueHandler;
            this.messageQueueHandler$set = true;
            return this;
        }

        public PulsarClusterDTO build() {
            String messageQueueHandler$value = this.messageQueueHandler$value;
            if (!this.messageQueueHandler$set) {
                messageQueueHandler$value = PulsarClusterDTO.$default$messageQueueHandler();
            }
            return new PulsarClusterDTO(this.adminUrl, this.serviceUrl, this.tenant, messageQueueHandler$value);
        }

        public String toString() {
            return "PulsarClusterDTO.PulsarClusterDTOBuilder(adminUrl=" + this.adminUrl + ", serviceUrl=" + this.serviceUrl + ", tenant=" + this.tenant + ", messageQueueHandler$value=" + this.messageQueueHandler$value + ")";
        }
    }
}

