/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.iceberg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="Iceberg data node info")
public class IcebergDataNodeDTO {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergDataNodeDTO.class);
    @ApiModelProperty(value="Catalog type, like: HIVE, HADOOP, default is HIVE")
    private String catalogType;
    @ApiModelProperty(value="Iceberg data warehouse dir")
    private String warehouse;

    public static IcebergDataNodeDTO getFromRequest(IcebergDataNodeRequest request) throws Exception {
        return IcebergDataNodeDTO.builder().catalogType(request.getCatalogType()).warehouse(request.getWarehouse()).build();
    }

    public static IcebergDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (IcebergDataNodeDTO)JsonUtils.parseObject((String)extParams, IcebergDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for Iceberg node: %s", e.getMessage()));
        }
    }

    private static String $default$catalogType() {
        return "HIVE";
    }

    public static IcebergDataNodeDTOBuilder builder() {
        return new IcebergDataNodeDTOBuilder();
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergDataNodeDTO)) {
            return false;
        }
        IcebergDataNodeDTO other = (IcebergDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        return !(this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IcebergDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        return result;
    }

    public String toString() {
        return "IcebergDataNodeDTO(catalogType=" + this.getCatalogType() + ", warehouse=" + this.getWarehouse() + ")";
    }

    public IcebergDataNodeDTO() {
        this.catalogType = IcebergDataNodeDTO.$default$catalogType();
    }

    public IcebergDataNodeDTO(String catalogType, String warehouse) {
        this.catalogType = catalogType;
        this.warehouse = warehouse;
    }

    public static class IcebergDataNodeDTOBuilder {
        private boolean catalogType$set;
        private String catalogType$value;
        private String warehouse;

        IcebergDataNodeDTOBuilder() {
        }

        public IcebergDataNodeDTOBuilder catalogType(String catalogType) {
            this.catalogType$value = catalogType;
            this.catalogType$set = true;
            return this;
        }

        public IcebergDataNodeDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public IcebergDataNodeDTO build() {
            String catalogType$value = this.catalogType$value;
            if (!this.catalogType$set) {
                catalogType$value = IcebergDataNodeDTO.$default$catalogType();
            }
            return new IcebergDataNodeDTO(catalogType$value, this.warehouse);
        }

        public String toString() {
            return "IcebergDataNodeDTO.IcebergDataNodeDTOBuilder(catalogType$value=" + this.catalogType$value + ", warehouse=" + this.warehouse + ")";
        }
    }
}

