/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.auth.DefaultAuthentication;
import org.apache.inlong.manager.common.enums.DataFormat;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.stream.StreamNode;

@ApiModel(value="Stream sink info")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="sinkType")
public abstract class StreamSink
extends StreamNode {
    @ApiModelProperty(value="Sink id")
    private Integer id;
    @ApiModelProperty(value="Inlong group id")
    private String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    private String inlongStreamId;
    @ApiModelProperty(value="Sink type, including: HIVE, ICEBERG, etc.")
    private String sinkType;
    @ApiModelProperty(value="Sink name, unique in one stream.")
    private String sinkName;
    @ApiModelProperty(value="Sink description")
    private String description;
    @ApiModelProperty(value="Inlong cluster name")
    private String inlongClusterName;
    @ApiModelProperty(value="Data node name")
    private String dataNodeName;
    @ApiModelProperty(value="Sort task name")
    private String sortTaskName;
    @ApiModelProperty(value="Sort consumer group")
    private String sortConsumerGroup;
    @ApiModelProperty(value="Whether to enable create sink resource? 0: disable, 1: enable. Default is 1", notes="Such as enable or disable to create Hive table")
    private Integer enableCreateResource;
    @ApiModelProperty(value="Backend operation log")
    private String operateLog;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Previous status")
    private Integer previousStatus;
    @ApiModelProperty(value="Creator")
    private String creator;
    @ApiModelProperty(value="Modifier")
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(value="Sink field list")
    private List<SinkField> sinkFieldList;
    @ApiModelProperty(value="Properties for sink")
    private Map<String, Object> properties;
    @JsonIgnore
    @ApiModelProperty(value="Data format type for stream sink")
    private DataFormat dataFormat;
    @JsonIgnore
    @ApiModelProperty(value="Authentication info if needed")
    private DefaultAuthentication authentication;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public SinkRequest genSinkRequest() {
        return null;
    }

    private static Integer $default$enableCreateResource() {
        return 1;
    }

    private static List<SinkField> $default$sinkFieldList() {
        return Lists.newArrayList();
    }

    private static Map<String, Object> $default$properties() {
        return Maps.newHashMap();
    }

    private static DataFormat $default$dataFormat() {
        return DataFormat.NONE;
    }

    protected StreamSink(StreamSinkBuilder<?, ?> b) {
        super(b);
        this.id = ((StreamSinkBuilder)b).id;
        this.inlongGroupId = ((StreamSinkBuilder)b).inlongGroupId;
        this.inlongStreamId = ((StreamSinkBuilder)b).inlongStreamId;
        this.sinkType = ((StreamSinkBuilder)b).sinkType;
        this.sinkName = ((StreamSinkBuilder)b).sinkName;
        this.description = ((StreamSinkBuilder)b).description;
        this.inlongClusterName = ((StreamSinkBuilder)b).inlongClusterName;
        this.dataNodeName = ((StreamSinkBuilder)b).dataNodeName;
        this.sortTaskName = ((StreamSinkBuilder)b).sortTaskName;
        this.sortConsumerGroup = ((StreamSinkBuilder)b).sortConsumerGroup;
        this.enableCreateResource = ((StreamSinkBuilder)b).enableCreateResource$set ? ((StreamSinkBuilder)b).enableCreateResource$value : StreamSink.$default$enableCreateResource();
        this.operateLog = ((StreamSinkBuilder)b).operateLog;
        this.status = ((StreamSinkBuilder)b).status;
        this.previousStatus = ((StreamSinkBuilder)b).previousStatus;
        this.creator = ((StreamSinkBuilder)b).creator;
        this.modifier = ((StreamSinkBuilder)b).modifier;
        this.createTime = ((StreamSinkBuilder)b).createTime;
        this.modifyTime = ((StreamSinkBuilder)b).modifyTime;
        this.sinkFieldList = ((StreamSinkBuilder)b).sinkFieldList$set ? ((StreamSinkBuilder)b).sinkFieldList$value : StreamSink.$default$sinkFieldList();
        this.properties = ((StreamSinkBuilder)b).properties$set ? ((StreamSinkBuilder)b).properties$value : StreamSink.$default$properties();
        this.dataFormat = ((StreamSinkBuilder)b).dataFormat$set ? ((StreamSinkBuilder)b).dataFormat$value : StreamSink.$default$dataFormat();
        this.authentication = ((StreamSinkBuilder)b).authentication;
        this.version = ((StreamSinkBuilder)b).version;
    }

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getSinkType() {
        return this.sinkType;
    }

    public String getSinkName() {
        return this.sinkName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInlongClusterName() {
        return this.inlongClusterName;
    }

    public String getDataNodeName() {
        return this.dataNodeName;
    }

    public String getSortTaskName() {
        return this.sortTaskName;
    }

    public String getSortConsumerGroup() {
        return this.sortConsumerGroup;
    }

    public Integer getEnableCreateResource() {
        return this.enableCreateResource;
    }

    public String getOperateLog() {
        return this.operateLog;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getPreviousStatus() {
        return this.previousStatus;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public List<SinkField> getSinkFieldList() {
        return this.sinkFieldList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public DefaultAuthentication getAuthentication() {
        return this.authentication;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setSinkType(String sinkType) {
        this.sinkType = sinkType;
    }

    public void setSinkName(String sinkName) {
        this.sinkName = sinkName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInlongClusterName(String inlongClusterName) {
        this.inlongClusterName = inlongClusterName;
    }

    public void setDataNodeName(String dataNodeName) {
        this.dataNodeName = dataNodeName;
    }

    public void setSortTaskName(String sortTaskName) {
        this.sortTaskName = sortTaskName;
    }

    public void setSortConsumerGroup(String sortConsumerGroup) {
        this.sortConsumerGroup = sortConsumerGroup;
    }

    public void setEnableCreateResource(Integer enableCreateResource) {
        this.enableCreateResource = enableCreateResource;
    }

    public void setOperateLog(String operateLog) {
        this.operateLog = operateLog;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setSinkFieldList(List<SinkField> sinkFieldList) {
        this.sinkFieldList = sinkFieldList;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @JsonIgnore
    public void setAuthentication(DefaultAuthentication authentication) {
        this.authentication = authentication;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public StreamSink() {
        this.enableCreateResource = StreamSink.$default$enableCreateResource();
        this.sinkFieldList = StreamSink.$default$sinkFieldList();
        this.properties = StreamSink.$default$properties();
        this.dataFormat = StreamSink.$default$dataFormat();
    }

    public StreamSink(Integer id, String inlongGroupId, String inlongStreamId, String sinkType, String sinkName, String description, String inlongClusterName, String dataNodeName, String sortTaskName, String sortConsumerGroup, Integer enableCreateResource, String operateLog, Integer status, Integer previousStatus, String creator, String modifier, Date createTime, Date modifyTime, List<SinkField> sinkFieldList, Map<String, Object> properties, DataFormat dataFormat, DefaultAuthentication authentication, Integer version) {
        this.id = id;
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.sinkType = sinkType;
        this.sinkName = sinkName;
        this.description = description;
        this.inlongClusterName = inlongClusterName;
        this.dataNodeName = dataNodeName;
        this.sortTaskName = sortTaskName;
        this.sortConsumerGroup = sortConsumerGroup;
        this.enableCreateResource = enableCreateResource;
        this.operateLog = operateLog;
        this.status = status;
        this.previousStatus = previousStatus;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.sinkFieldList = sinkFieldList;
        this.properties = properties;
        this.dataFormat = dataFormat;
        this.authentication = authentication;
        this.version = version;
    }

    @Override
    public String toString() {
        return "StreamSink(super=" + super.toString() + ", id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", sinkType=" + this.getSinkType() + ", sinkName=" + this.getSinkName() + ", description=" + this.getDescription() + ", inlongClusterName=" + this.getInlongClusterName() + ", dataNodeName=" + this.getDataNodeName() + ", sortTaskName=" + this.getSortTaskName() + ", sortConsumerGroup=" + this.getSortConsumerGroup() + ", enableCreateResource=" + this.getEnableCreateResource() + ", operateLog=" + this.getOperateLog() + ", status=" + this.getStatus() + ", previousStatus=" + this.getPreviousStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", sinkFieldList=" + this.getSinkFieldList() + ", properties=" + this.getProperties() + ", dataFormat=" + this.getDataFormat() + ", authentication=" + this.getAuthentication() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamSink)) {
            return false;
        }
        StreamSink other = (StreamSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$enableCreateResource = this.getEnableCreateResource();
        Integer other$enableCreateResource = other.getEnableCreateResource();
        if (this$enableCreateResource == null ? other$enableCreateResource != null : !((Object)this$enableCreateResource).equals(other$enableCreateResource)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$previousStatus = this.getPreviousStatus();
        Integer other$previousStatus = other.getPreviousStatus();
        if (this$previousStatus == null ? other$previousStatus != null : !((Object)this$previousStatus).equals(other$previousStatus)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$sinkType = this.getSinkType();
        String other$sinkType = other.getSinkType();
        if (this$sinkType == null ? other$sinkType != null : !this$sinkType.equals(other$sinkType)) {
            return false;
        }
        String this$sinkName = this.getSinkName();
        String other$sinkName = other.getSinkName();
        if (this$sinkName == null ? other$sinkName != null : !this$sinkName.equals(other$sinkName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$inlongClusterName = this.getInlongClusterName();
        String other$inlongClusterName = other.getInlongClusterName();
        if (this$inlongClusterName == null ? other$inlongClusterName != null : !this$inlongClusterName.equals(other$inlongClusterName)) {
            return false;
        }
        String this$dataNodeName = this.getDataNodeName();
        String other$dataNodeName = other.getDataNodeName();
        if (this$dataNodeName == null ? other$dataNodeName != null : !this$dataNodeName.equals(other$dataNodeName)) {
            return false;
        }
        String this$sortTaskName = this.getSortTaskName();
        String other$sortTaskName = other.getSortTaskName();
        if (this$sortTaskName == null ? other$sortTaskName != null : !this$sortTaskName.equals(other$sortTaskName)) {
            return false;
        }
        String this$sortConsumerGroup = this.getSortConsumerGroup();
        String other$sortConsumerGroup = other.getSortConsumerGroup();
        if (this$sortConsumerGroup == null ? other$sortConsumerGroup != null : !this$sortConsumerGroup.equals(other$sortConsumerGroup)) {
            return false;
        }
        String this$operateLog = this.getOperateLog();
        String other$operateLog = other.getOperateLog();
        if (this$operateLog == null ? other$operateLog != null : !this$operateLog.equals(other$operateLog)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        List<SinkField> this$sinkFieldList = this.getSinkFieldList();
        List<SinkField> other$sinkFieldList = other.getSinkFieldList();
        if (this$sinkFieldList == null ? other$sinkFieldList != null : !((Object)this$sinkFieldList).equals(other$sinkFieldList)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        DataFormat this$dataFormat = this.getDataFormat();
        DataFormat other$dataFormat = other.getDataFormat();
        if (this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat)) {
            return false;
        }
        DefaultAuthentication this$authentication = this.getAuthentication();
        DefaultAuthentication other$authentication = other.getAuthentication();
        return !(this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StreamSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $enableCreateResource = this.getEnableCreateResource();
        result = result * 59 + ($enableCreateResource == null ? 43 : ((Object)$enableCreateResource).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $previousStatus = this.getPreviousStatus();
        result = result * 59 + ($previousStatus == null ? 43 : ((Object)$previousStatus).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $sinkType = this.getSinkType();
        result = result * 59 + ($sinkType == null ? 43 : $sinkType.hashCode());
        String $sinkName = this.getSinkName();
        result = result * 59 + ($sinkName == null ? 43 : $sinkName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $inlongClusterName = this.getInlongClusterName();
        result = result * 59 + ($inlongClusterName == null ? 43 : $inlongClusterName.hashCode());
        String $dataNodeName = this.getDataNodeName();
        result = result * 59 + ($dataNodeName == null ? 43 : $dataNodeName.hashCode());
        String $sortTaskName = this.getSortTaskName();
        result = result * 59 + ($sortTaskName == null ? 43 : $sortTaskName.hashCode());
        String $sortConsumerGroup = this.getSortConsumerGroup();
        result = result * 59 + ($sortConsumerGroup == null ? 43 : $sortConsumerGroup.hashCode());
        String $operateLog = this.getOperateLog();
        result = result * 59 + ($operateLog == null ? 43 : $operateLog.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        List<SinkField> $sinkFieldList = this.getSinkFieldList();
        result = result * 59 + ($sinkFieldList == null ? 43 : ((Object)$sinkFieldList).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        DataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        DefaultAuthentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        return result;
    }

    public static abstract class StreamSinkBuilder<C extends StreamSink, B extends StreamSinkBuilder<C, B>>
    extends StreamNode.StreamNodeBuilder<C, B> {
        private Integer id;
        private String inlongGroupId;
        private String inlongStreamId;
        private String sinkType;
        private String sinkName;
        private String description;
        private String inlongClusterName;
        private String dataNodeName;
        private String sortTaskName;
        private String sortConsumerGroup;
        private boolean enableCreateResource$set;
        private Integer enableCreateResource$value;
        private String operateLog;
        private Integer status;
        private Integer previousStatus;
        private String creator;
        private String modifier;
        private Date createTime;
        private Date modifyTime;
        private boolean sinkFieldList$set;
        private List<SinkField> sinkFieldList$value;
        private boolean properties$set;
        private Map<String, Object> properties$value;
        private boolean dataFormat$set;
        private DataFormat dataFormat$value;
        private DefaultAuthentication authentication;
        private Integer version;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B id(Integer id) {
            this.id = id;
            return (B)this.self();
        }

        public B inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return (B)this.self();
        }

        public B inlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
            return (B)this.self();
        }

        public B sinkType(String sinkType) {
            this.sinkType = sinkType;
            return (B)this.self();
        }

        public B sinkName(String sinkName) {
            this.sinkName = sinkName;
            return (B)this.self();
        }

        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        public B inlongClusterName(String inlongClusterName) {
            this.inlongClusterName = inlongClusterName;
            return (B)this.self();
        }

        public B dataNodeName(String dataNodeName) {
            this.dataNodeName = dataNodeName;
            return (B)this.self();
        }

        public B sortTaskName(String sortTaskName) {
            this.sortTaskName = sortTaskName;
            return (B)this.self();
        }

        public B sortConsumerGroup(String sortConsumerGroup) {
            this.sortConsumerGroup = sortConsumerGroup;
            return (B)this.self();
        }

        public B enableCreateResource(Integer enableCreateResource) {
            this.enableCreateResource$value = enableCreateResource;
            this.enableCreateResource$set = true;
            return (B)this.self();
        }

        public B operateLog(String operateLog) {
            this.operateLog = operateLog;
            return (B)this.self();
        }

        public B status(Integer status) {
            this.status = status;
            return (B)this.self();
        }

        public B previousStatus(Integer previousStatus) {
            this.previousStatus = previousStatus;
            return (B)this.self();
        }

        public B creator(String creator) {
            this.creator = creator;
            return (B)this.self();
        }

        public B modifier(String modifier) {
            this.modifier = modifier;
            return (B)this.self();
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public B createTime(Date createTime) {
            this.createTime = createTime;
            return (B)this.self();
        }

        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public B modifyTime(Date modifyTime) {
            this.modifyTime = modifyTime;
            return (B)this.self();
        }

        public B sinkFieldList(List<SinkField> sinkFieldList) {
            this.sinkFieldList$value = sinkFieldList;
            this.sinkFieldList$set = true;
            return (B)this.self();
        }

        public B properties(Map<String, Object> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B dataFormat(DataFormat dataFormat) {
            this.dataFormat$value = dataFormat;
            this.dataFormat$set = true;
            return (B)this.self();
        }

        @JsonIgnore
        public B authentication(DefaultAuthentication authentication) {
            this.authentication = authentication;
            return (B)this.self();
        }

        public B version(Integer version) {
            this.version = version;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StreamSink.StreamSinkBuilder(super=" + super.toString() + ", id=" + this.id + ", inlongGroupId=" + this.inlongGroupId + ", inlongStreamId=" + this.inlongStreamId + ", sinkType=" + this.sinkType + ", sinkName=" + this.sinkName + ", description=" + this.description + ", inlongClusterName=" + this.inlongClusterName + ", dataNodeName=" + this.dataNodeName + ", sortTaskName=" + this.sortTaskName + ", sortConsumerGroup=" + this.sortConsumerGroup + ", enableCreateResource$value=" + this.enableCreateResource$value + ", operateLog=" + this.operateLog + ", status=" + this.status + ", previousStatus=" + this.previousStatus + ", creator=" + this.creator + ", modifier=" + this.modifier + ", createTime=" + this.createTime + ", modifyTime=" + this.modifyTime + ", sinkFieldList$value=" + this.sinkFieldList$value + ", properties$value=" + this.properties$value + ", dataFormat$value=" + this.dataFormat$value + ", authentication=" + this.authentication + ", version=" + this.version + ")";
        }
    }
}

