/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hbase;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.hbase.HBaseColumnFamilyInfo;
import org.apache.inlong.manager.pojo.sink.hbase.HBaseSinkRequest;
import org.apache.inlong.manager.pojo.sink.hbase.HBaseTableInfo;

public class HBaseSinkDTO {
    @ApiModelProperty(value="Target namespace")
    private String namespace;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Row key")
    private String rowKey;
    @ApiModelProperty(value="ZooKeeper quorum")
    private String zkQuorum;
    @ApiModelProperty(value="ZooKeeper node parent")
    private String zkNodeParent;
    @ApiModelProperty(value="Sink buffer flush maxsize")
    private String bufferFlushMaxSize;
    @ApiModelProperty(value="Sink buffer flush max rows")
    private String bufferFlushMaxRows;
    @ApiModelProperty(value="Sink buffer flush interval")
    private String bufferFlushInterval;
    @ApiModelProperty(value="Properties for hbase")
    private Map<String, Object> properties;

    public static HBaseSinkDTO getFromRequest(HBaseSinkRequest request) {
        return HBaseSinkDTO.builder().tableName(request.getTableName()).namespace(request.getNamespace()).rowKey(request.getRowKey()).zkQuorum(request.getZkQuorum()).bufferFlushMaxSize(request.getBufferFlushMaxSize()).zkNodeParent(request.getZkNodeParent()).bufferFlushMaxRows(request.getBufferFlushMaxRows()).bufferFlushInterval(request.getBufferFlushInterval()).properties(request.getProperties()).build();
    }

    public static HBaseSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (HBaseSinkDTO)JsonUtils.parseObject((String)extParams, HBaseSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static HBaseTableInfo getHbaseTableInfo(HBaseSinkDTO hbaseInfo, List<HBaseColumnFamilyInfo> columnFamilies) {
        HBaseTableInfo info = new HBaseTableInfo();
        info.setNamespace(hbaseInfo.getNamespace());
        info.setTableName(hbaseInfo.getTableName());
        info.setTblProperties(hbaseInfo.getProperties());
        info.setColumnFamilies(columnFamilies);
        return info;
    }

    public static HBaseSinkDTOBuilder builder() {
        return new HBaseSinkDTOBuilder();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public String getZkQuorum() {
        return this.zkQuorum;
    }

    public String getZkNodeParent() {
        return this.zkNodeParent;
    }

    public String getBufferFlushMaxSize() {
        return this.bufferFlushMaxSize;
    }

    public String getBufferFlushMaxRows() {
        return this.bufferFlushMaxRows;
    }

    public String getBufferFlushInterval() {
        return this.bufferFlushInterval;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public void setZkQuorum(String zkQuorum) {
        this.zkQuorum = zkQuorum;
    }

    public void setZkNodeParent(String zkNodeParent) {
        this.zkNodeParent = zkNodeParent;
    }

    public void setBufferFlushMaxSize(String bufferFlushMaxSize) {
        this.bufferFlushMaxSize = bufferFlushMaxSize;
    }

    public void setBufferFlushMaxRows(String bufferFlushMaxRows) {
        this.bufferFlushMaxRows = bufferFlushMaxRows;
    }

    public void setBufferFlushInterval(String bufferFlushInterval) {
        this.bufferFlushInterval = bufferFlushInterval;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HBaseSinkDTO)) {
            return false;
        }
        HBaseSinkDTO other = (HBaseSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$rowKey = this.getRowKey();
        String other$rowKey = other.getRowKey();
        if (this$rowKey == null ? other$rowKey != null : !this$rowKey.equals(other$rowKey)) {
            return false;
        }
        String this$zkQuorum = this.getZkQuorum();
        String other$zkQuorum = other.getZkQuorum();
        if (this$zkQuorum == null ? other$zkQuorum != null : !this$zkQuorum.equals(other$zkQuorum)) {
            return false;
        }
        String this$zkNodeParent = this.getZkNodeParent();
        String other$zkNodeParent = other.getZkNodeParent();
        if (this$zkNodeParent == null ? other$zkNodeParent != null : !this$zkNodeParent.equals(other$zkNodeParent)) {
            return false;
        }
        String this$bufferFlushMaxSize = this.getBufferFlushMaxSize();
        String other$bufferFlushMaxSize = other.getBufferFlushMaxSize();
        if (this$bufferFlushMaxSize == null ? other$bufferFlushMaxSize != null : !this$bufferFlushMaxSize.equals(other$bufferFlushMaxSize)) {
            return false;
        }
        String this$bufferFlushMaxRows = this.getBufferFlushMaxRows();
        String other$bufferFlushMaxRows = other.getBufferFlushMaxRows();
        if (this$bufferFlushMaxRows == null ? other$bufferFlushMaxRows != null : !this$bufferFlushMaxRows.equals(other$bufferFlushMaxRows)) {
            return false;
        }
        String this$bufferFlushInterval = this.getBufferFlushInterval();
        String other$bufferFlushInterval = other.getBufferFlushInterval();
        if (this$bufferFlushInterval == null ? other$bufferFlushInterval != null : !this$bufferFlushInterval.equals(other$bufferFlushInterval)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HBaseSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $rowKey = this.getRowKey();
        result = result * 59 + ($rowKey == null ? 43 : $rowKey.hashCode());
        String $zkQuorum = this.getZkQuorum();
        result = result * 59 + ($zkQuorum == null ? 43 : $zkQuorum.hashCode());
        String $zkNodeParent = this.getZkNodeParent();
        result = result * 59 + ($zkNodeParent == null ? 43 : $zkNodeParent.hashCode());
        String $bufferFlushMaxSize = this.getBufferFlushMaxSize();
        result = result * 59 + ($bufferFlushMaxSize == null ? 43 : $bufferFlushMaxSize.hashCode());
        String $bufferFlushMaxRows = this.getBufferFlushMaxRows();
        result = result * 59 + ($bufferFlushMaxRows == null ? 43 : $bufferFlushMaxRows.hashCode());
        String $bufferFlushInterval = this.getBufferFlushInterval();
        result = result * 59 + ($bufferFlushInterval == null ? 43 : $bufferFlushInterval.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "HBaseSinkDTO(namespace=" + this.getNamespace() + ", tableName=" + this.getTableName() + ", rowKey=" + this.getRowKey() + ", zkQuorum=" + this.getZkQuorum() + ", zkNodeParent=" + this.getZkNodeParent() + ", bufferFlushMaxSize=" + this.getBufferFlushMaxSize() + ", bufferFlushMaxRows=" + this.getBufferFlushMaxRows() + ", bufferFlushInterval=" + this.getBufferFlushInterval() + ", properties=" + this.getProperties() + ")";
    }

    public HBaseSinkDTO() {
    }

    public HBaseSinkDTO(String namespace, String tableName, String rowKey, String zkQuorum, String zkNodeParent, String bufferFlushMaxSize, String bufferFlushMaxRows, String bufferFlushInterval, Map<String, Object> properties) {
        this.namespace = namespace;
        this.tableName = tableName;
        this.rowKey = rowKey;
        this.zkQuorum = zkQuorum;
        this.zkNodeParent = zkNodeParent;
        this.bufferFlushMaxSize = bufferFlushMaxSize;
        this.bufferFlushMaxRows = bufferFlushMaxRows;
        this.bufferFlushInterval = bufferFlushInterval;
        this.properties = properties;
    }

    public static class HBaseSinkDTOBuilder {
        private String namespace;
        private String tableName;
        private String rowKey;
        private String zkQuorum;
        private String zkNodeParent;
        private String bufferFlushMaxSize;
        private String bufferFlushMaxRows;
        private String bufferFlushInterval;
        private Map<String, Object> properties;

        HBaseSinkDTOBuilder() {
        }

        public HBaseSinkDTOBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public HBaseSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public HBaseSinkDTOBuilder rowKey(String rowKey) {
            this.rowKey = rowKey;
            return this;
        }

        public HBaseSinkDTOBuilder zkQuorum(String zkQuorum) {
            this.zkQuorum = zkQuorum;
            return this;
        }

        public HBaseSinkDTOBuilder zkNodeParent(String zkNodeParent) {
            this.zkNodeParent = zkNodeParent;
            return this;
        }

        public HBaseSinkDTOBuilder bufferFlushMaxSize(String bufferFlushMaxSize) {
            this.bufferFlushMaxSize = bufferFlushMaxSize;
            return this;
        }

        public HBaseSinkDTOBuilder bufferFlushMaxRows(String bufferFlushMaxRows) {
            this.bufferFlushMaxRows = bufferFlushMaxRows;
            return this;
        }

        public HBaseSinkDTOBuilder bufferFlushInterval(String bufferFlushInterval) {
            this.bufferFlushInterval = bufferFlushInterval;
            return this;
        }

        public HBaseSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public HBaseSinkDTO build() {
            return new HBaseSinkDTO(this.namespace, this.tableName, this.rowKey, this.zkQuorum, this.zkNodeParent, this.bufferFlushMaxSize, this.bufferFlushMaxRows, this.bufferFlushInterval, this.properties);
        }

        public String toString() {
            return "HBaseSinkDTO.HBaseSinkDTOBuilder(namespace=" + this.namespace + ", tableName=" + this.tableName + ", rowKey=" + this.rowKey + ", zkQuorum=" + this.zkQuorum + ", zkNodeParent=" + this.zkNodeParent + ", bufferFlushMaxSize=" + this.bufferFlushMaxSize + ", bufferFlushMaxRows=" + this.bufferFlushMaxRows + ", bufferFlushInterval=" + this.bufferFlushInterval + ", properties=" + this.properties + ")";
        }
    }
}

