/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hive;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.hive.HivePartitionField;
import org.apache.inlong.manager.pojo.sink.hive.HiveSinkRequest;

@ApiModel(value="Hive sink info")
@JsonTypeDefine(value="HIVE")
public class HiveSink
extends StreamSink {
    @ApiModelProperty(value="Hive JDBC URL, such as jdbc:hive2://${ip}:${port}")
    private String jdbcUrl;
    @ApiModelProperty(value="Username of the Hive server")
    private String username;
    @ApiModelProperty(value="User password of the Hive server")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="Partition interval, support: 1 H, 1 D, 30 I, 10 I")
    private Integer partitionInterval;
    @ApiModelProperty(value="Partition field list")
    private List<HivePartitionField> partitionFieldList;
    @ApiModelProperty(value="Partition creation strategy, partition start, partition close")
    private String partitionCreationStrategy;
    @ApiModelProperty(value="File format, support: TextFile, ORCFile, RCFile, SequenceFile, Avro, Parquet, etc")
    private String fileFormat;
    @ApiModelProperty(value="Data encoding format: UTF-8, GBK")
    private String dataEncoding;
    @ApiModelProperty(value="Data separator")
    private String dataSeparator;
    @ApiModelProperty(value="Version for Hive, such as: 3.2.1")
    private String hiveVersion;
    @ApiModelProperty(value="Config directory of Hive on HDFS, needed by sort in light mode, must include hive-site.xml")
    private String hiveConfDir;

    public HiveSink() {
        this.setSinkType("HIVE");
    }

    @Override
    public SinkRequest genSinkRequest() {
        return (SinkRequest)CommonBeanUtils.copyProperties((Object)this, HiveSinkRequest::new);
    }

    protected HiveSink(HiveSinkBuilder<?, ?> b) {
        super((StreamSink.StreamSinkBuilder<?, ?>)b);
        this.jdbcUrl = ((HiveSinkBuilder)b).jdbcUrl;
        this.username = ((HiveSinkBuilder)b).username;
        this.password = ((HiveSinkBuilder)b).password;
        this.dbName = ((HiveSinkBuilder)b).dbName;
        this.tableName = ((HiveSinkBuilder)b).tableName;
        this.dataPath = ((HiveSinkBuilder)b).dataPath;
        this.partitionInterval = ((HiveSinkBuilder)b).partitionInterval;
        this.partitionFieldList = ((HiveSinkBuilder)b).partitionFieldList;
        this.partitionCreationStrategy = ((HiveSinkBuilder)b).partitionCreationStrategy;
        this.fileFormat = ((HiveSinkBuilder)b).fileFormat;
        this.dataEncoding = ((HiveSinkBuilder)b).dataEncoding;
        this.dataSeparator = ((HiveSinkBuilder)b).dataSeparator;
        this.hiveVersion = ((HiveSinkBuilder)b).hiveVersion;
        this.hiveConfDir = ((HiveSinkBuilder)b).hiveConfDir;
    }

    public static HiveSinkBuilder<?, ?> builder() {
        return new HiveSinkBuilderImpl();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public Integer getPartitionInterval() {
        return this.partitionInterval;
    }

    public List<HivePartitionField> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public String getPartitionCreationStrategy() {
        return this.partitionCreationStrategy;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getDataEncoding() {
        return this.dataEncoding;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getHiveVersion() {
        return this.hiveVersion;
    }

    public String getHiveConfDir() {
        return this.hiveConfDir;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setPartitionInterval(Integer partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public void setPartitionFieldList(List<HivePartitionField> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    public void setPartitionCreationStrategy(String partitionCreationStrategy) {
        this.partitionCreationStrategy = partitionCreationStrategy;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setDataEncoding(String dataEncoding) {
        this.dataEncoding = dataEncoding;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setHiveVersion(String hiveVersion) {
        this.hiveVersion = hiveVersion;
    }

    public void setHiveConfDir(String hiveConfDir) {
        this.hiveConfDir = hiveConfDir;
    }

    public HiveSink(String jdbcUrl, String username, String password, String dbName, String tableName, String dataPath, Integer partitionInterval, List<HivePartitionField> partitionFieldList, String partitionCreationStrategy, String fileFormat, String dataEncoding, String dataSeparator, String hiveVersion, String hiveConfDir) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.tableName = tableName;
        this.dataPath = dataPath;
        this.partitionInterval = partitionInterval;
        this.partitionFieldList = partitionFieldList;
        this.partitionCreationStrategy = partitionCreationStrategy;
        this.fileFormat = fileFormat;
        this.dataEncoding = dataEncoding;
        this.dataSeparator = dataSeparator;
        this.hiveVersion = hiveVersion;
        this.hiveConfDir = hiveConfDir;
    }

    @Override
    public String toString() {
        return "HiveSink(super=" + super.toString() + ", jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", partitionInterval=" + this.getPartitionInterval() + ", partitionFieldList=" + this.getPartitionFieldList() + ", partitionCreationStrategy=" + this.getPartitionCreationStrategy() + ", fileFormat=" + this.getFileFormat() + ", dataEncoding=" + this.getDataEncoding() + ", dataSeparator=" + this.getDataSeparator() + ", hiveVersion=" + this.getHiveVersion() + ", hiveConfDir=" + this.getHiveConfDir() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiveSink)) {
            return false;
        }
        HiveSink other = (HiveSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$partitionInterval = this.getPartitionInterval();
        Integer other$partitionInterval = other.getPartitionInterval();
        if (this$partitionInterval == null ? other$partitionInterval != null : !((Object)this$partitionInterval).equals(other$partitionInterval)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        List<HivePartitionField> this$partitionFieldList = this.getPartitionFieldList();
        List<HivePartitionField> other$partitionFieldList = other.getPartitionFieldList();
        if (this$partitionFieldList == null ? other$partitionFieldList != null : !((Object)this$partitionFieldList).equals(other$partitionFieldList)) {
            return false;
        }
        String this$partitionCreationStrategy = this.getPartitionCreationStrategy();
        String other$partitionCreationStrategy = other.getPartitionCreationStrategy();
        if (this$partitionCreationStrategy == null ? other$partitionCreationStrategy != null : !this$partitionCreationStrategy.equals(other$partitionCreationStrategy)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$dataEncoding = this.getDataEncoding();
        String other$dataEncoding = other.getDataEncoding();
        if (this$dataEncoding == null ? other$dataEncoding != null : !this$dataEncoding.equals(other$dataEncoding)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        String this$hiveVersion = this.getHiveVersion();
        String other$hiveVersion = other.getHiveVersion();
        if (this$hiveVersion == null ? other$hiveVersion != null : !this$hiveVersion.equals(other$hiveVersion)) {
            return false;
        }
        String this$hiveConfDir = this.getHiveConfDir();
        String other$hiveConfDir = other.getHiveConfDir();
        return !(this$hiveConfDir == null ? other$hiveConfDir != null : !this$hiveConfDir.equals(other$hiveConfDir));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HiveSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $partitionInterval = this.getPartitionInterval();
        result = result * 59 + ($partitionInterval == null ? 43 : ((Object)$partitionInterval).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        List<HivePartitionField> $partitionFieldList = this.getPartitionFieldList();
        result = result * 59 + ($partitionFieldList == null ? 43 : ((Object)$partitionFieldList).hashCode());
        String $partitionCreationStrategy = this.getPartitionCreationStrategy();
        result = result * 59 + ($partitionCreationStrategy == null ? 43 : $partitionCreationStrategy.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $dataEncoding = this.getDataEncoding();
        result = result * 59 + ($dataEncoding == null ? 43 : $dataEncoding.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        String $hiveVersion = this.getHiveVersion();
        result = result * 59 + ($hiveVersion == null ? 43 : $hiveVersion.hashCode());
        String $hiveConfDir = this.getHiveConfDir();
        result = result * 59 + ($hiveConfDir == null ? 43 : $hiveConfDir.hashCode());
        return result;
    }

    private static final class HiveSinkBuilderImpl
    extends HiveSinkBuilder<HiveSink, HiveSinkBuilderImpl> {
        private HiveSinkBuilderImpl() {
        }

        @Override
        protected HiveSinkBuilderImpl self() {
            return this;
        }

        @Override
        public HiveSink build() {
            return new HiveSink(this);
        }
    }

    public static abstract class HiveSinkBuilder<C extends HiveSink, B extends HiveSinkBuilder<C, B>>
    extends StreamSink.StreamSinkBuilder<C, B> {
        private String jdbcUrl;
        private String username;
        private String password;
        private String dbName;
        private String tableName;
        private String dataPath;
        private Integer partitionInterval;
        private List<HivePartitionField> partitionFieldList;
        private String partitionCreationStrategy;
        private String fileFormat;
        private String dataEncoding;
        private String dataSeparator;
        private String hiveVersion;
        private String hiveConfDir;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B dbName(String dbName) {
            this.dbName = dbName;
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B dataPath(String dataPath) {
            this.dataPath = dataPath;
            return (B)this.self();
        }

        public B partitionInterval(Integer partitionInterval) {
            this.partitionInterval = partitionInterval;
            return (B)this.self();
        }

        public B partitionFieldList(List<HivePartitionField> partitionFieldList) {
            this.partitionFieldList = partitionFieldList;
            return (B)this.self();
        }

        public B partitionCreationStrategy(String partitionCreationStrategy) {
            this.partitionCreationStrategy = partitionCreationStrategy;
            return (B)this.self();
        }

        public B fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return (B)this.self();
        }

        public B dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return (B)this.self();
        }

        public B dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return (B)this.self();
        }

        public B hiveVersion(String hiveVersion) {
            this.hiveVersion = hiveVersion;
            return (B)this.self();
        }

        public B hiveConfDir(String hiveConfDir) {
            this.hiveConfDir = hiveConfDir;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HiveSink.HiveSinkBuilder(super=" + super.toString() + ", jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", dataPath=" + this.dataPath + ", partitionInterval=" + this.partitionInterval + ", partitionFieldList=" + this.partitionFieldList + ", partitionCreationStrategy=" + this.partitionCreationStrategy + ", fileFormat=" + this.fileFormat + ", dataEncoding=" + this.dataEncoding + ", dataSeparator=" + this.dataSeparator + ", hiveVersion=" + this.hiveVersion + ", hiveConfDir=" + this.hiveConfDir + ")";
        }
    }
}

